<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Worker;
use App\Models\SubAgent;

class AssignRandomSubAgents extends Command
{
    protected $signature = 'workers:assign-random-subagent';
    protected $description = 'Assign a random sub-agent to all existing workers';

    public function __construct()
    {
        parent::__construct();
    }

    public function handle()
    {
        $workers = Worker::all(); // Get all workers
        $subAgents = SubAgent::all(); // Get all sub-agents

        if ($subAgents->isEmpty()) {
            $this->info('No sub-agents found!');
            return;
        }

        foreach ($workers as $worker) {
            // Assign a random sub-agent to each worker
            $worker->sub_agent_id = $subAgents->random()->id;
            $worker->save();
        }

        $this->info('Random sub-agents have been assigned to all workers.');
    }
}
