<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;

class BackupDatabase extends Command
{
    protected $signature = 'backup:run {type=full : The type of backup to run (full, database, or files)}';
    protected $description = 'Run the backup process';

    public function handle()
    {
        $type = $this->argument('type');
        
        if (!in_array($type, ['full', 'database', 'files'])) {
            $this->error('Invalid backup type. Must be one of: full, database, files');
            return 1;
        }

        $this->info("Starting {$type} backup...");

        try {
            $options = [];
            if ($type === 'database') {
                $options['--only-db'] = true;
            } elseif ($type === 'files') {
                $options['--only-files'] = true;
            }
            Artisan::call('backup:run', $options);
            $this->info('Backup completed successfully!');
            return 0;
        } catch (\Exception $e) {
            $this->error('Backup failed: ' . $e->getMessage());
            return 1;
        }
    }
} 