<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class UsersExport implements FromCollection, WithHeadings, WithMapping
{
    protected $data;

    public function __construct($data)
    {
        $this->data = $data;
    }

    public function collection()
    {
        return $this->data;
    }

    public function headings(): array
    {
        if ($this->data->isEmpty()) {
            return [];
        }

        $first = $this->data->first();
        if (is_array($first)) {
            return $first;
        }

        return array_keys($first->toArray());
    }

    public function map($row): array
    {
        if (is_array($row)) {
            return $row;
        }

        return array_values($row->toArray());
    }
} 