<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class ApplicationController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, Job $job)
    {
        $validated = $request->validate([
            'cover_letter' => 'required|string|min:50',
            'resume' => 'required|file|mimes:pdf,doc,docx|max:2048',
        ]);
    
        $path = $request->file('resume')->store('resumes');
    
        $job->applications()->create([
            'user_id' => auth()->id(),
            'cover_letter' => $validated['cover_letter'],
            'resume_path' => $path,
        ]);
    
        return redirect()->route('jobs.show', $job)
            ->with('success', 'Application submitted successfully!');
    }
    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
