<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\LogsExport;
use Barryvdh\DomPDF\Facade\Pdf;
use Spatie\Activitylog\Models\Activity;

class LogController extends Controller
{
    public function export($format)
    {
        if ($format === 'csv') {
            return Excel::download(new LogsExport, 'activity_logs.csv');
        } elseif ($format === 'pdf') {
            $activities = Activity::with('causer')->latest()->get();
            $pdf = Pdf::loadView('exports.logs_pdf', compact('activities'));
            return $pdf->download('activity_logs.pdf');
        }

        return redirect()->back()->with('error', 'Invalid export format');
    }

    public function view()
    {
        $activities = Activity::with('causer')
            ->latest()
            ->paginate(15);

        return view('logs.view', compact('activities'));
    }
}
