<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Document;
use App\Models\Application;
use App\Models\Message;
use App\Models\Activity;
use Illuminate\Http\Request;

class UserController extends Controller
{
    public function dashboard()
    {
        $user = auth()->user();
        
        // Get user's documents count
        $documentsCount = Document::where('user_id', $user->id)->count();
        
        // Get user's applications count
        $applicationsCount = Application::where('user_id', $user->id)->count();
        
        // Get user's unread messages count
        $messagesCount = Message::where('recipient_id', $user->id)
            ->where('read_at', null)
            ->count();
        
        // Get recent activities
        $recentActivities = Activity::where('causer_id', $user->id)
            ->orWhere('subject_id', $user->id)
            ->latest()
            ->take(5)
            ->get();
        
        // Get recent notifications
        $notifications = $user->notifications()
            ->latest()
            ->take(5)
            ->get();

        return view('user.dashboard', [
            'user' => $user,
            'documentsCount' => $documentsCount,
            'applicationsCount' => $applicationsCount,
            'messagesCount' => $messagesCount,
            'recentActivities' => $recentActivities,
            'notifications' => $notifications
        ]);
    }

    public function profile()
    {
        return view('user.profile', [
            'user' => auth()->user()
        ]);
    }
}