<?php

namespace App\Http\Controllers;

use App\Models\Visitor;
use Illuminate\Http\Request;
use App\Exports\VisitorExport;
use Maatwebsite\Excel\Facades\Excel;
use Barryvdh\DomPDF\Facade\Pdf;

class VisitorExportController extends Controller
{
    public function export($format)
    {
        if ($format === 'csv') {
            return Excel::download(new VisitorExport, 'visitors.csv');
        } elseif ($format === 'pdf') {
            $visitors = Visitor::all();
            $pdf = Pdf::loadView('visitors.export_pdf', compact('visitors'));
            return $pdf->download('visitors.pdf');
        }

        return back()->with('error', 'Invalid export format');
    }

    public function exportLogs($format)
    {
        // Placeholder for logs export (similar to visitors)
        return back()->with('error', 'Logs export not implemented yet');
    }
}
