<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Relations\HasMany;
use App\Models\Traits\SystemActivityLog;

class ExternalAgency extends Model
{
    use SystemActivityLog;

    // Table name (optional if it follows naming convention)
    protected $table = 'external_agencies';

    // Allow mass assignment for these fields
    protected $fillable = [
        'company_name',
        'logo',
        'license_number',
        'license_date',
        'city',
        'country',
        'responsible_name',
        'email',
        'phone',
        'recruitment_fee',
        'name',
        'contact_person',
        'address',
        'status'
    ];

    /**
     * Get the display name of the agency
     */
    public function getDisplayNameAttribute()
    {
        return $this->company_name ?? $this->name;
    }

    /**
     * Relationship with employment statuses
     */
    public function employmentStatuses(): HasMany
    {
        return $this->hasMany(EmploymentStatus::class, 'external_agency_id');
    }

    /**
     * Relationship with workers through employment status
     */
    public function workers()
    {
        return $this->hasManyThrough(
            Worker::class,
            EmploymentStatus::class,
            'external_agency_id', // Foreign key on employment_statuses table
            'id', // Foreign key on workers table
            'id', // Local key on external_agencies table
            'worker_id' // Local key on employment_statuses table
        );
    }

    /**
     * Get the invoices for this agency.
     */
    public function invoices(): HasMany
    {
        return $this->hasMany(Invoice::class);
    }
}
