<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Traits\SystemActivityLog;

class JobApplication extends Model
{
    use HasFactory, SystemActivityLog;

    protected $fillable = [
        'job_id',
        'worker_id',
        'status',
        'notes',
        'applied_at',
        'processed_at'
    ];

    protected $casts = [
        'applied_at' => 'datetime',
        'processed_at' => 'datetime'
    ];

    // Relationships
    public function job()
    {
        return $this->belongsTo(JobListing::class, 'job_id');
    }

    public function worker()
    {
        return $this->belongsTo(Worker::class);
    }

    // Scopes
    public function scopePending($query)
    {
        return $query->where('status', 'pending');
    }

    public function scopeApproved($query)
    {
        return $query->where('status', 'approved');
    }

    public function scopeRejected($query)
    {
        return $query->where('status', 'rejected');
    }
} 