<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('job_listings', function (Blueprint $table) {
            // Drop existing columns if they exist
            $table->dropColumn([
                'title', 'company', 'type', 'location', 'salary', 'currency',
                'description', 'skills', 'posted', 'closing_date', 'urgent',
                'highSalary', 'commission', 'status'
            ]);
        });

        Schema::table('job_listings', function (Blueprint $table) {
            // Recreate columns with proper structure
            $table->string('title');
            $table->string('company');
            $table->string('type');
            $table->string('location');
            $table->decimal('salary', 10, 2)->nullable();
            $table->string('currency', 10)->default('SAR');
            $table->text('description');
            $table->json('skills')->nullable();
            $table->date('posted')->nullable();
            $table->date('closing_date')->nullable();
            $table->boolean('urgent')->default(false);
            $table->boolean('highSalary')->default(false);
            $table->boolean('commission')->default(false);
            $table->string('status')->default('active');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('job_listings', function (Blueprint $table) {
            // Drop columns
            $table->dropColumn([
                'title', 'company', 'type', 'location', 'salary', 'currency',
                'description', 'skills', 'posted', 'closing_date', 'urgent',
                'highSalary', 'commission', 'status'
            ]);
        });
    }
};
