<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\EmploymentStatus;
use App\Models\Worker;  // Assuming you have the Worker model

class EmploymentStatusSeeder extends Seeder
{
    public function run()
    {
        // First, delete existing data from the table
        EmploymentStatus::truncate();

        // Create new records with all statuses
        $workers = Worker::all(); // Get all workers (ensure you have workers in your DB)

        // Add a record for each status and associate it with a worker
        $statuses = [
            EmploymentStatus::STATUS_PENDING,
            EmploymentStatus::STATUS_SENT_NEA,
            EmploymentStatus::STATUS_NEA_APPROVED,
            EmploymentStatus::STATUS_MEDICAL_FIT,
            EmploymentStatus::STATUS_READY_FOR_SUBMISSION,
            EmploymentStatus::STATUS_SUBMITTED_EMBASSY,
            EmploymentStatus::STATUS_VISA_ISSUED,
            EmploymentStatus::STATUS_TRAVELLED,
        ];

        foreach ($workers as $worker) {
            foreach ($statuses as $status) {
                $employmentStatus = EmploymentStatus::create([
                    'contract_number' => 'CNT-' . str_pad($i, 3, '0', STR_PAD_LEFT),
                    'visa_number' => 'VISA-' . str_pad($i, 4, '0', STR_PAD_LEFT),
                    'worker_id' => $worker->id,
                    'payment_status' => 'Pending',
                    'status' => $status,
                    'creation_date' => now(),
                    'external_agency_id' => 1, // Placeholder external_agency_id
                ]);
            }
        }

        // Output a success message
        $this->command->info('Employment statuses table seeded successfully.');
    }
}
