<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\ExternalAgency;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class ExternalAgencySeeder extends Seeder
{
    public function run(): void
    {
        // Optional: Clear existing records
        DB::table('external_agencies')->truncate();

        // Seed 10 records
        for ($i = 1; $i <= 5; $i++) {
            ExternalAgency::create([
                'company_name' => "Agency Company $i",
                'license_number' => strtoupper(Str::random(10)),
                'license_date' => now()->subDays(rand(100, 1000)),
                'city' => fake()->city(),
                'country' => fake()->country(),
                'responsible_name' => fake()->name(),
                'email' => fake()->unique()->safeEmail(),
                'phone' => fake()->phoneNumber(),
                'logo' => 'logos/logo' . $i . '.png', // Assuming logos are stored like this
            ]);
        }
    }
}
