<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\JobListing;
use App\Models\User;

class JobListingSeeder extends Seeder
{
    public function run(): void
    {
        // Create admin user if not exists
        $admin = User::firstOrCreate(
            ['email' => 'admin@example.com'],
            [
                'name' => 'Admin User',
                'password' => bcrypt('password'),
                'role' => 'admin'
            ]
        );

        // Create 50 active jobs
        JobListing::factory()->count(50)->create([
            'user_id' => $admin->id,
            'status' => 'active'
        ]);

        // Create 10 urgent jobs
        JobListing::factory()->count(10)->create([
            'user_id' => $admin->id,
            'status' => 'active',
            'urgent' => true
        ]);

        // Create 5 high-salary jobs
        JobListing::factory()->count(5)->create([
            'user_id' => $admin->id,
            'status' => 'active',
            'highSalary' => true
        ]);

        // Create 5 closed jobs
        JobListing::factory()->count(5)->create([
            'user_id' => $admin->id,
            'status' => 'closed'
        ]);
    }
}
