<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class VisitorsTableSeeder extends Seeder
{
    public function run()
    {
        DB::table('visitors')->insert([
            [
                'name' => 'John Doe',
                'email' => 'john.doe@example.com',
                'phone' => '1234567890',
                'purpose' => 'Business Meeting',
                'check_in' => Carbon::now(),
                'check_out' => null,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
                'deleted_at' => null,
            ],
            [
                'name' => 'Alice Smith',
                'email' => 'alice.smith@example.com',
                'phone' => '9876543210',
                'purpose' => 'Job Interview',
                'check_in' => Carbon::now()->subHours(2),
                'check_out' => Carbon::now()->subHour(),
                'created_at' => Carbon::now()->subDay(),
                'updated_at' => Carbon::now()->subDay(),
                'deleted_at' => null,
            ],
        ]);
    }
}
