@extends('layouts.app')

@section('content')
    <x-jobs-nav />
    
    <div class="container py-4">
        <div class="card">
            <div class="card-header">
                <h2 class="h5 mb-0">Job Applications</h2>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Applicant</th>
                                <th>Job Title</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($applications as $application)
                            <tr>
                                <td>{{ $application->user->name }}</td>
                                <td>{{ $application->job->title }}</td>
                                <td>
                                    <span class="badge 
                                        @if($application->status === 'pending') bg-warning text-dark
                                        @elseif($application->status === 'approved') bg-success
                                        @else bg-danger
                                        @endif">
                                        {{ ucfirst($application->status) }}
                                    </span>
                                </td>
                                <td>
                                    <a href="{{ route('applications.show', $application) }}" 
                                       class="btn btn-sm btn-outline-primary">
                                        View
                                    </a>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                
                {{ $applications->links() }}
            </div>
        </div>
    </div>
@endsection