@extends('layouts.app')

@section('content')
    <x-jobs-nav />
    
    <div class="container py-4">
        <div class="card">
            <div class="card-header">
                <h2 class="h5 mb-0">Application Details</h2>
            </div>
            <div class="card-body">
                <div class="row mb-4">
                    <div class="col-md-6">
                        <h3 class="h6">Applicant</h3>
                        <p>{{ $application->user->name }}</p>
                        <p>{{ $application->user->email }}</p>
                    </div>
                    <div class="col-md-6">
                        <h3 class="h6">Job Details</h3>
                        <p><strong>{{ $application->job->title }}</strong></p>
                        <p>{{ $application->job->location }}</p>
                    </div>
                </div>
                
                <div class="mb-4">
                    <h3 class="h6">Cover Letter</h3>
                    <div class="p-3 bg-light rounded">
                        {!! nl2br(e($application->cover_letter)) !!}
                    </div>
                </div>
                
                <div class="mb-4">
                    <h3 class="h6">Resume</h3>
                    <a href="{{ Storage::url($application->resume_path) }}" 
                       class="btn btn-outline-primary" 
                       target="_blank">
                        Download Resume
                    </a>
                </div>
                
                @if(auth()->user()->isAdmin())
                    <form method="POST" action="{{ route('applications.update', $application) }}">
                        @csrf
                        @method('PUT')
                        
                        <div class="mb-3">
                            <label for="status" class="form-label">Status</label>
                            <select class="form-select" id="status" name="status">
                                <option value="pending" {{ $application->status === 'pending' ? 'selected' : '' }}>Pending</option>
                                <option value="approved" {{ $application->status === 'approved' ? 'selected' : '' }}>Approved</option>
                                <option value="rejected" {{ $application->status === 'rejected' ? 'selected' : '' }}>Rejected</option>
                            </select>
                        </div>
                        
                        <div class="mb-3">
                            <label for="feedback" class="form-label">Feedback</label>
                            <textarea class="form-control" id="feedback" name="feedback" rows="3">{{ old('feedback', $application->feedback) }}</textarea>
                        </div>
                        
                        <button type="submit" class="btn btn-primary">Update Application</button>
                    </form>
                @endif
            </div>
        </div>
    </div>
@endsection