@props(['expenses', 'activeTab'])

<div class="tab-pane fade {{ $activeTab === 'expenses' ? 'show active' : '' }}" id="expenses" role="tabpanel" aria-labelledby="expenses-tab" tabindex="0">
    <div class="card border-0 shadow-sm">
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h5 class="card-title mb-0">Monthly Expenses</h5>
                <div class="btn-group">
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addExpenseModal">
                        <i class="fas fa-plus me-2"></i>Add Monthly Expense
                    </button>
                    <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#updateCreditModal">
                        <i class="fas fa-credit-card me-2"></i>Update Credit
                    </button>
                </div>
            </div>

            @php
                $totalAmountPaid = $expenses->sum('amount_paid');
                $totalCredit = $expenses->sum('credit');
            @endphp

            <div class="table-responsive">
                <table class="table table-striped align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>Name</th>
                            <th>Task</th>
                            <th>Amount Paid</th>
                            <th>Credit</th>
                            <th>Current Account</th>
                            <th>Due Date</th>
                            <th>Notes</th>
                            <th>Actions</th>
                        </tr>
                    </thead>

                    <tbody>
                        @php $runningBalance = 0; @endphp
                        @foreach($expenses as $expense)
                            @php
                                $runningBalance += $expense->credit - $expense->amount_paid;
                            @endphp
                            <tr>
                                <td>{{ $expense->name }}</td>
                                <td>{{ $expense->task }}</td>
                                <td>{{ number_format($expense->amount_paid, 2) }}</td>
                                <td>{{ number_format($expense->credit, 2) }}</td>
                                <td>{{ number_format($runningBalance, 2) }}</td>
                                <td>{{ \Carbon\Carbon::parse($expense->due_date)->format('Y-m-d') }}</td>
                                <td>{{ $expense->notes }}</td>
                                <td>
                                    <button class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#editExpenseModal{{ $expense->id }}">
                                        <i class="fas fa-edit me-1"></i>Edit
                                    </button>
                                    <form action="{{ route('monthly-expenses.destroy', $expense->id) }}" method="POST" style="display:inline-block;">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">
                                            <i class="fas fa-trash me-1"></i>Delete
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>

                    <tfoot class="table-light fw-bold">
                        <tr>
                            <td colspan="2">Totals</td>
                            <td>{{ number_format($totalAmountPaid, 2) }}</td>
                            <td>{{ number_format($totalCredit, 2) }}</td>
                            <td colspan="3" class="{{ ($totalCredit - $totalAmountPaid) >= 0 ? 'text-success' : 'text-danger' }}">
                                {{ number_format($totalCredit - $totalAmountPaid, 2) }}
                            </td>
                            <td colspan="3"></td>
                        </tr>
                        <tr>
                            <td colspan="2">Net Balance (Credit - Amount Paid)</td>
                            <td colspan="3" class="{{ ($totalCredit - $totalAmountPaid) >= 0 ? 'text-success' : 'text-danger' }}">
                                {{ number_format($totalCredit - $totalAmountPaid, 2) }}
                            </td>
                            <td colspan="3"></td>
                        </tr>
                    </tfoot>
                </table>
            </div>

            <div class="d-flex justify-content-end mb-3 gap-2">
                <a href="{{ route('monthly-expenses.export') }}" class="btn btn-success">
                    <i class="fas fa-file-excel me-2"></i>Export to Excel
                </a>
                <a href="{{ route('monthly-expenses.export-pdf') }}" class="btn btn-danger">
                    <i class="fas fa-file-pdf me-2"></i>Export to PDF
                </a>
            </div>
        </div>
    </div>
</div>

@include('invoices.partials.modals.create-expense-modal') 