<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                Create Employment Request
            </h2>
             <a href="{{ route('employment_status.index') }}" class="text-blue hover:text-blue-200 transition-colors">
                    <i class="fas fa-arrow-left mr-1"></i> Back to List
                </a>
        </div>
    </x-slot>

    <div class="py-6">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">

            {{-- Search by Passport Number --}}
            <div class="card shadow-sm mb-4">
                <div class="card-header bg-info text-white">
                    <strong>Search Candidate</strong>
                </div>
                <div class="card-body">
                    <form method="GET" action="{{ route('employment_status.create') }}">
                        <div class="input-group">
                            <input type="text" name="passport_number" class="form-control" placeholder="Enter Passport Number" value="{{ request('passport_number') }}">
                            <button class="btn btn-primary" type="submit">
                                <i class="bi bi-search"></i> Search
                            </button>
                        </div>
                    </form>
                </div>
            </div>

            {{-- Worker Check --}}
            @if (isset($worker))
                @if ($workerNotAvailable ?? false)
                    <div class="alert alert-warning text-center">
                        This worker is currently marked as <strong>{{ $worker->status }}</strong> and cannot be assigned a new contract.
                    </div>
                @else
                    {{-- Show Contract Form --}}
                    <div class="card shadow-sm">
                        <div class="card-header bg-light">
                            Assign Contract to: <strong>{{ $worker->surname }} {{ $worker->given_names }}</strong>
                        </div>
                        <div class="card-body">

                            {{-- SUCCESS Message --}}
                            @if (session('success'))
                                <div class="alert alert-success">
                                    <h5><i class="fas fa-check-circle"></i> {{ session('success.title') ?? 'Success' }}</h5>
                                    <p>{{ session('success.content') ?? session('success') }}</p>
                                    @if (isset(session('success')['details']))
                                        <ul>
                                            @foreach (session('success.details') as $key => $value)
                                                <li><strong>{{ ucfirst(str_replace('_', ' ', $key)) }}:</strong> {{ $value }}</li>
                                            @endforeach
                                        </ul>
                                    @endif
                                </div>
                            @endif

                            {{-- ERROR Validation --}}
                            @if ($errors->any())
                                <div class="alert alert-danger">
                                    <h5><i class="fas fa-exclamation-triangle"></i> Please fix the following errors:</h5>
                                    <ul class="mb-0">
                                        @foreach ($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif

                            {{-- Session Error --}}
                            @if (session('error'))
                                <div class="alert alert-danger">
                                    <h5><i class="fas fa-times-circle"></i> {{ is_array(session('error')) ? session('error.title') : 'Error' }}</h5>
                                    <p>{{ is_array(session('error')) ? session('error.content') : session('error') }}</p>
                                    @if (is_array(session('error')) && config('app.debug') && session('error.error'))
                                        <small class="text-muted">Debug: {{ session('error.error') }}</small>
                                    @endif
                                </div>
                            @endif

                            <form method="POST" action="{{ route('employment_status.store') }}">
                                @csrf
                                <input type="hidden" name="worker_id" value="{{ $worker->id }}">

                                <div class="row g-3">
                                    {{-- Contract Number --}}
                                    <div class="col-md-6">
                                        <label for="contract_number" class="form-label">Contract Number</label>
                                        <div class="input-group">
                                            <span class="input-group-text"><i class="bi bi-file-earmark-text"></i></span>
                                            <input type="text" name="contract_number" class="form-control" value="{{ $nextContractNumber }}" readonly>
                                        </div>
                                    </div>

                                    {{-- Visa Number --}}
                                    <div class="col-md-6">
                                        <label for="visa_number" class="form-label">Visa Number</label>
                                        <div class="input-group">
                                            <span class="input-group-text"><i class="bi bi-file-earmark-person"></i></span>
                                            <input type="text" name="visa_number" class="form-control" required placeholder="Enter Visa Number">
                                        </div>
                                    </div>

                                    {{-- Occupation --}}
                                    <div class="col-md-6">
                                        <label for="Occupation" class="form-label">Occupation</label>
                                        <input type="text" name="Occupation" class="form-control" value="{{ $worker->occupation }}" readonly>
                                    </div>

                                    {{-- e_Agency Assignment --}}
                                    <div class="col-md-6">
                                        <label for="external_agency_id" class="form-label">Assign e_Agency</label>
                                        <select name="external_agency_id" class="form-select" required>
                                            <option value="">Select a e_Agency</option>
                                            @foreach ($external_agencies as $external_agency)
                                                <option value="{{ $external_agency->id }}">{{ $external_agency->company_name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="mt-4">
                                    <button type="submit" name="action" value="create" class="btn btn-primary">
                                        <i class="fas fa-save"></i> Create
                                    </button>

                                    <button type="submit" name="action" value="create_another" class="btn btn-success">
                                        <i class="fas fa-plus-circle"></i> Create & Create Another
                                    </button>

                                    <a href="{{ route('employment_status.index') }}" class="btn btn-outline-secondary">
                                        <i class="fas fa-times"></i> Cancel
                                    </a>
                                </div>
                            </form>
                        </div>
                    </div>
                @endif
            @elseif(request('passport_number'))
                <div class="alert alert-danger text-center">
                    No worker found with passport number <strong>{{ request('passport_number') }}</strong>.
                </div>
            @endif
        </div>
    </div>

    @push('scripts')
    <script>
        // Show success toast using SweetAlert2
        function showSuccessToast(message = 'Contract created successfully!') {
            const Toast = Swal.mixin({
                toast: true,
                position: 'center',
                showConfirmButton: false,
                timer: 3000,
                timerProgressBar: true,
                didOpen: (toast) => {
                    toast.addEventListener('mouseenter', Swal.stopTimer)
                    toast.addEventListener('mouseleave', Swal.resumeTimer)
                }
            });

            Toast.fire({
                icon: 'success',
                title: message
            });
        }

        // Check for success message in session
        @if(session('success'))
            @if(is_array(session('success')))
                showSuccessToast("{{ session('success.content') ?? 'Contract created successfully!' }}");
            @else
                showSuccessToast("{{ session('success') }}");
            @endif
        @endif

        // Add click handler for "Create & Create Another" button
        document.querySelector('button[value="create_another"]').addEventListener('click', function() {
            showSuccessToast('Contract created successfully! Creating another...');
        });
    </script>
    @endpush
</x-app-layout>
