@extends('layouts.workers')

@section('content')
<div class="container py-4">
    <div class="card shadow-lg mb-4">
        <!-- Header -->
        <div class="bg-blue-600 px-6 py-4">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h2 class="text-2xl font-bold text-blue">Employment Contract</h2>
                    <p class="text-blue-100 mb-0">Details for {{ strtoupper($worker->surname) }} {{ strtoupper($worker->given_names) }}</p>
                </div>
                <a href="{{ route('employment_status.index') }}" class="text-blue hover:text-blue-200">
                    <i class="fas fa-arrow-left me-2"></i> Back to List
                </a>
            </div>
        </div>

        <div class="card-header bg-white text-primary d-flex justify-content-between align-items-center">
            <h5 class="mb-0 fw-semibold"><i class="fas fa-file-contract me-2"></i>Contract Information</h5>
        </div>

        <div class="card-body">
            <div class="row g-4">
                <!-- Left Column -->
                <div class="col-md-6">
                    <div class="p-3 bg-light rounded h-100">
                        <div class="d-flex mb-2">
                            <strong class="me-2" style="min-width: 140px;">Contract #:</strong>
                            <span>{{ $employment->contract_number ?? 'N/A' }}</span>
                        </div>
                        <div class="d-flex mb-2">
                            <strong class="me-2" style="min-width: 140px;">Visa:</strong>
                            <span>{{ $employment->visa_number ?? 'N/A' }}</span>
                        </div>
                        <div class="d-flex mb-2">
                            <strong class="me-2" style="min-width: 140px;">Candidate:</strong>
                            <span class="text-uppercase fw-bold">{{ $worker->surname }} {{ $worker->given_names }}</span>
                        </div>
                        <div class="d-flex mb-2">
                            <strong class="me-2" style="min-width: 140px;">Passport No:</strong>
                            <span>{{ $worker->passport_number ?? 'N/A' }}</span>
                        </div>
                        <div class="d-flex mb-2">
                            <strong class="me-2" style="min-width: 140px;">Occupation:</strong>
                            <span>{{ $worker->occupation ?? 'N/A' }}</span>
                        </div>
                    </div>
                </div>

                <!-- Right Column -->
                <div class="col-md-6">
                    <div class="p-3 bg-light rounded h-100">
                        <div class="d-flex mb-2">
                            <strong class="me-2" style="min-width: 140px;">e_Agency:</strong>
                            <span>{{ $employment->company_name ?? 'N/A' }}</span>
                        </div>
                        <div class="d-flex mb-2">
                            <strong class="me-2" style="min-width: 140px;">Nationality:</strong>
                            <span>{{ $worker->country ?? 'N/A' }}</span>
                        </div>
                        <div class="d-flex mb-2">
                            <strong class="me-2" style="min-width: 140px;">Payment:</strong>
                            <span class="badge bg-{{ $employment->payment_status === 'Paid' ? 'success' : 'danger' }} bg-opacity-10 text-{{ $employment->payment_status === 'Paid' ? 'success' : 'danger' }}">
                                {{ $employment->payment_status ?? 'Unpaid' }}
                            </span>
                        </div>
                        <div class="d-flex mb-2">
                            <strong class="me-2" style="min-width: 140px;">Created on:</strong>
                            <span>{{ \Carbon\Carbon::parse($employment->created_at)->format('d M Y') }}</span>
                        </div>
                    </div>
                </div>
            </div>

          
        </div>
    </div>
</div>
@endsection
