<div class="modal fade" id="editAgencyModal" tabindex="-1" aria-labelledby="editAgencyModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="editAgencyModalLabel">Edit External Agency</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="editAgencyForm" method="POST" enctype="multipart/form-data">
            @csrf
                @method('PUT')
                <div class="modal-body">
                    <div class="row g-3">
                        <!-- Company Information -->
                        <div class="col-md-6">
                            <label for="edit_company_name" class="form-label">Company Name</label>
                            <input type="text" class="form-control" id="edit_company_name" name="company_name" required>
                        </div>
                        
                        <div class="col-md-6">
                            <label for="edit_recruitment_fee" class="form-label">Recruitment Fee</label>
                            <div class="input-group">
                                <span class="input-group-text">$</span>
                                <input type="number" step="0.01" class="form-control" id="edit_recruitment_fee" name="recruitment_fee" required>
                            </div>
                        </div>
                        
                        <!-- License Information -->
                        <div class="col-md-6">
                            <label for="edit_license_number" class="form-label">License Number</label>
                            <input type="text" class="form-control" id="edit_license_number" name="license_number" required>
                        </div>
                        
                        <div class="col-md-6">
                            <label for="edit_license_date" class="form-label">License Date</label>
                            <input type="date" class="form-control" id="edit_license_date" name="license_date" required>
                        </div>
                        
                        <!-- Location Information -->
                        <div class="col-md-6">
                            <label for="edit_city" class="form-label">City</label>
                            <input type="text" class="form-control" id="edit_city" name="city" required>
                        </div>
                        
                        <div class="col-md-6">
                            <label for="edit_country" class="form-label">Country</label>
                            <input type="text" class="form-control" id="edit_country" name="country" required>
                        </div>
                        
                        <!-- Contact Information -->
                        <div class="col-md-6">
                            <label for="edit_responsible_name" class="form-label">Responsible Person</label>
                            <input type="text" class="form-control" id="edit_responsible_name" name="responsible_name" required>
                        </div>
                        
                        <div class="col-md-6">
                            <label for="edit_email" class="form-label">Email</label>
                            <input type="email" class="form-control" id="edit_email" name="email" required>
                        </div>
                        
                        <div class="col-md-6">
                            <label for="edit_phone" class="form-label">Phone</label>
                            <input type="tel" class="form-control" id="edit_phone" name="phone" required>
                        </div>
                        
                        <div class="col-md-6">
                            <label for="edit_logo" class="form-label">Logo</label>
                            <input type="file" class="form-control" id="edit_logo" name="logo" accept="image/jpeg,image/png,image/jpg">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Save Changes</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Handle modal show event
    $('#editAgencyModal').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget); // Button that triggered the modal
        var agency = button.data('agency'); // Extract info from data-* attributes
        
        // Update the modal's content
        var modal = $(this);
        modal.find('#edit_company_name').val(agency.company_name);
        modal.find('#edit_recruitment_fee').val(agency.recruitment_fee);
        modal.find('#edit_license_number').val(agency.license_number);
        modal.find('#edit_license_date').val(agency.license_date);
        modal.find('#edit_city').val(agency.city);
        modal.find('#edit_country').val(agency.country);
        modal.find('#edit_responsible_name').val(agency.responsible_name);
        modal.find('#edit_email').val(agency.email);
        modal.find('#edit_phone').val(agency.phone);
        
        // Update form action
        modal.find('form').attr('action', '/external_agencies/' + agency.id);
    });

    // Handle form submission
    const editForm = document.querySelector('#editAgencyForm');
    if (editForm) {
        editForm.addEventListener('submit', function(e) {
            e.preventDefault();
            const formData = new FormData(this);
            
            // Show loading state
            const submitButton = this.querySelector('button[type="submit"]');
            const originalText = submitButton.innerHTML;
            submitButton.disabled = true;
            submitButton.innerHTML = '<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Saving...';
            
            fetch(this.action, {
                method: 'POST',
                body: formData,
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                }
            })
            .then(response => response.json())
            .then(data => {
                // Reset button state
                submitButton.disabled = false;
                submitButton.innerHTML = originalText;

                if (data.success) {
                    // Close the modal
                    const modal = bootstrap.Modal.getInstance(document.querySelector('#editAgencyModal'));
                    modal.hide();
                    
                    // Show success message
                    const Toast = Swal.mixin({
                        toast: true,
                        position: 'center',
                        showConfirmButton: false,
                        timer: 3000,
                        timerProgressBar: true,
                        width: 'auto',
                        padding: '0.5em',
                        customClass: {
                            popup: 'colored-toast'
                        }
                    });

                    Toast.fire({
                        icon: 'success',
                        title: data.message
                    }).then(() => {
                        window.location.reload();
                    });
                } else {
                    throw new Error(data.message || 'Update failed');
                }
            })
            .catch(error => {
                // Reset button state
                submitButton.disabled = false;
                submitButton.innerHTML = originalText;

                // Show error message
                const ErrorAlert = Swal.mixin({
                    toast: true,
                    position: 'center',
                    showConfirmButton: true,
                    confirmButtonColor: '#3085d6',
                    confirmButtonText: 'OK',
                    icon: 'error',
                    width: 'auto',
                    padding: '0.5em',
                    customClass: {
                        popup: 'colored-toast'
                    }
                });

                ErrorAlert.fire({
                    title: 'Error',
                    text: error.message || 'An error occurred while updating the agency'
                });
            });
        });
    }
});
</script>