<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                External Agencies
            </h2>

            <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#addExternalAgencyModal">
                <i class="fas fa-plus"></i> Add External Agency
            </button>

        </div>
    </x-slot>

    <div class="py-6">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">

            {{-- Search + Filters (Optional) --}}
            <div class="card shadow-sm border-light rounded mb-4">
                <div class="card-header bg-info text-white text-center">
                    <h5>Filter External Agencies</h5>
                </div>

                <form method="GET" action="{{ route('external_agencies.index') }}" class="p-3">
    <div class="row g-2 align-items-end">
        {{-- Responsible Name --}}
        <div class="col-md">
            <label class="form-label">Responsible Name</label>
            <div class="input-group">
                <span class="input-group-text"><i class="bi bi-person"></i></span>
                <input type="text" name="responsible_name" class="form-control" placeholder="Search by responsible name" value="{{ request('responsible_name') }}">
            </div>
        </div>

        {{-- Company Name --}}
        <div class="col-md">
            <label class="form-label">Company Name</label>
            <div class="input-group">
                <span class="input-group-text"><i class="bi bi-building"></i></span>
                <input type="text" name="company_name" class="form-control" placeholder="Search by company name" value="{{ request('company_name') }}">
            </div>
        </div>

        {{-- Submit & Clear --}}
        <div class="col-auto">
            <button type="submit" class="btn btn-info mt-2">
                <i class="bi bi-funnel-fill"></i> Filter
            </button>
            <a href="{{ route('external_agencies.index') }}" class="btn btn-outline-secondary mt-2 ms-2">
                <i class="bi bi-x-circle"></i> Clear
            </a>
        </div>
    </div>
</form>

            </div>

            {{-- External Agencies List --}}
            <div class="card shadow-sm border-light rounded">
                <div class="card-header bg-light">
                    <h5 class="mb-0">External Agencies List</h5>
                </div>

                <div class="card-body">
    <div class="row">
        @foreach ($external_agencies as $agency)
            <div class="col-12 mb-4">
                <div class="card shadow rounded shadow-lg">
                    <div class="card-body">
                        <div class="row align-items-start">
                            {{-- Agency Info --}}
                            <div class="col">
                                <div class="row g-3">
                                    {{-- Responsible Name --}}
                                    <div class="col-6 col-md-3">
                                        <div class="text-muted small">
                                            <i class="bi bi-person"></i> Responsible Name
                                        </div>
                                        <span id="responsibleNameText{{ $agency->id }}">{{ $agency->responsible_name ?? 'N/A' }}</span>
                                        <input type="text" id="responsibleNameInput{{ $agency->id }}" class="form-control" value="{{ $agency->responsible_name ?? 'N/A' }}" style="display:none;">
                                    </div>

                                    {{-- Company Name --}}
                                    <div class="col-6 col-md-3">
                                        <div class="text-muted small">
                                            <i class="bi bi-building"></i> Company
                                        </div>
                                        <span id="companyNameText{{ $agency->id }}">{{ $agency->company_name ?? 'N/A' }}</span>
                                        <input type="text" id="companyNameInput{{ $agency->id }}" class="form-control" value="{{ $agency->company_name ?? 'N/A' }}" style="display:none;">
                                    </div>

                                    {{-- License Number --}}
                                    <div class="col-6 col-md-3">
                                        <div class="text-muted small">
                                            <i class="bi bi-file-earmark-lock"></i> Licence No
                                        </div>
                                        <span id="licenseNumberText{{ $agency->id }}">{{ $agency->license_number ?? 'N/A' }}</span>
                                        <input type="text" id="licenseNumberInput{{ $agency->id }}" class="form-control" value="{{ $agency->license_number ?? 'N/A' }}" style="display:none;">
                                    </div>

                                    {{-- License Date --}}
                                    <div class="col-6 col-md-3">
                                        <div class="text-muted small">
                                            <i class="bi bi-calendar-check"></i> Licence Date
                                        </div>
                                        <span id="licenseDateText{{ $agency->id }}">{{ $agency->license_date ?? 'N/A' }}</span>
                                        <input type="date" id="licenseDateInput{{ $agency->id }}" class="form-control" value="{{ $agency->license_date ?? 'N/A' }}" style="display:none;">
                                    </div>

                                    {{-- Email --}}
                                    <div class="col-6 col-md-3">
                                        <div class="text-muted small">
                                            <i class="bi bi-envelope"></i> Email
                                        </div>
                                        <span id="emailText{{ $agency->id }}">{{ $agency->email }}</span>
                                        <input type="email" id="emailInput{{ $agency->id }}" class="form-control" value="{{ $agency->email }}" style="display:none;">
                                    </div>

                                    {{-- Phone --}}
                                    <div class="col-6 col-md-3">
                                        <div class="text-muted small">
                                            <i class="bi bi-telephone"></i> Phone
                                        </div>
                                        <span id="phoneText{{ $agency->id }}">{{ $agency->phone ?? 'N/A' }}</span>
                                        <input type="text" id="phoneInput{{ $agency->id }}" class="form-control" value="{{ $agency->phone ?? 'N/A' }}" style="display:none;">
                                    </div>

                                    {{-- City --}}
                                    <div class="col-6 col-md-3">
                                        <div class="text-muted small">
                                            <i class="bi bi-house-door"></i> City
                                        </div>
                                        <span id="cityText{{ $agency->id }}">{{ $agency->city ?? 'N/A' }}</span>
                                        <input type="text" id="cityInput{{ $agency->id }}" class="form-control" value="{{ $agency->city ?? 'N/A' }}" style="display:none;">
                                    </div>

                                    {{-- Country --}}
                                    <div class="col-6 col-md-3">
                                        <div class="text-muted small">
                                            <i class="bi bi-geo-alt"></i> Country
                                        </div>
                                        <span id="countryText{{ $agency->id }}">{{ $agency->country ?? 'N/A' }}</span>
                                        <input type="text" id="countryInput{{ $agency->id }}" class="form-control" value="{{ $agency->country ?? 'N/A' }}" style="display:none;">
                                    </div>
                                </div>
                            </div>

                            {{-- Actions --}}
                            <div class="col-auto text-end">
                                <div class="d-flex flex-column gap-1">
                                <button class="btn btn-sm btn-primary" data-bs-toggle="modal" 
                                        data-bs-target="#editAgencyModal"
                                        data-agency='@json($agency)'>
                                    <i class="fas fa-edit"></i> Edit
                                </button>
                                    <button type="button" class="btn btn-danger btn-sm delete-agency" 
                                            data-agency-id="{{ $agency->id }}"
                                            data-agency-name="{{ $agency->company_name }}"
                                            data-delete-url="{{ route('external_agencies.destroy', $agency->id) }}">
                                        <i class="fas fa-trash"></i> Delete
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach

        {{-- No Results --}}
        @if ($external_agencies->isEmpty())
            <div class="col-12 text-center text-muted">
                <p>No external agencies found.</p>
            </div>
        @endif
    </div>

    {{-- Pagination --}}
    <div class="d-flex justify-content-center mt-3">
        {{ $external_agencies->appends(request()->query())->links('pagination::bootstrap-4') }}
    </div>
</div>


            </div>
        </div>
    </div>

    <!-- Add External Agency Modal -->
    @include('external_agencies.create')

    <!-- Edit External Agency Modal -->
    @include('external_agencies.edit-modal')

    {{-- SweetAlert2 CDN --}}
    <link href="https://cdn.jsdelivr.net/npm/sweetalert2@11.4.27/dist/sweetalert2.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.4.27/dist/sweetalert2.min.js"></script>

    <script>
        // Toast configuration for success messages
        const Toast = Swal.mixin({
            toast: true,
            position: 'center',
            showConfirmButton: false,
            timer: 3000,
            timerProgressBar: true,
            width: 'auto',
            padding: '0.5em',
            customClass: {
                popup: 'colored-toast'
            },
            didOpen: (toast) => {
                toast.addEventListener('mouseenter', Swal.stopTimer)
                toast.addEventListener('mouseleave', Swal.resumeTimer)
            }
        });

        // Error alert configuration
        const ErrorAlert = Swal.mixin({
            toast: true,
            position: 'center',
            showConfirmButton: true,
            confirmButtonColor: '#3085d6',
            confirmButtonText: 'OK',
            icon: 'error',
            width: 'auto',
            padding: '0.5em',
            customClass: {
                popup: 'colored-toast'
            }
        });

        // Add custom styles for smaller popups
        const style = document.createElement('style');
        style.textContent = `
            .colored-toast {
                font-size: 0.9em !important;
                min-width: 200px !important;
                max-width: 400px !important;
            }
            .colored-toast .swal2-title {
                font-size: 1.1em !important;
                margin: 0.5em !important;
            }
            .colored-toast .swal2-html-container {
                font-size: 0.9em !important;
                margin: 0.5em !important;
            }
            .colored-toast .swal2-confirm {
                padding: 0.3em 1em !important;
                font-size: 0.9em !important;
            }
        `;
        document.head.appendChild(style);

        // Handle Delete Action
        document.querySelectorAll('.delete-agency').forEach(button => {
            button.addEventListener('click', function() {
                const agencyId = this.dataset.agencyId;
                const agencyName = this.dataset.agencyName;
                const deleteUrl = this.dataset.deleteUrl;
                
                Swal.fire({
                    title: 'Are you sure?',
                    text: `Do you want to delete ${agencyName}?`,
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Yes, delete it!',
                    width: 'auto',
                    padding: '0.5em',
                    customClass: {
                        popup: 'colored-toast'
                    }
                }).then((result) => {
                    if (result.isConfirmed) {
                        // Create a form and submit it
                        const form = document.createElement('form');
                        form.method = 'POST';
                        form.action = deleteUrl;

                        // Add CSRF token
                        const csrfInput = document.createElement('input');
                        csrfInput.type = 'hidden';
                        csrfInput.name = '_token';
                        csrfInput.value = document.querySelector('meta[name="csrf-token"]').content;
                        form.appendChild(csrfInput);

                        // Add method spoofing for DELETE
                        const methodInput = document.createElement('input');
                        methodInput.type = 'hidden';
                        methodInput.name = '_method';
                        methodInput.value = 'DELETE';
                        form.appendChild(methodInput);

                        // Add form to document and submit
                        document.body.appendChild(form);
                        form.submit();
                    }
                });
            });
        });

        // Handle Edit Form Submit
        const editForm = document.querySelector('#editAgencyForm');
        if (editForm) {
            editForm.addEventListener('submit', function(e) {
                e.preventDefault();
                const formData = new FormData(this);
                
                fetch(this.action, {
                    method: 'POST',
                    body: formData,
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                    }
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        Toast.fire({
                            icon: 'success',
                            title: data.message
                        }).then(() => {
                            window.location.reload();
                        });
                    }
                })
                .catch(error => {
                    ErrorAlert.fire({
                        title: 'Error',
                        text: 'An error occurred while updating the agency'
                    });
                });
            });
        }

        // Handle Success Messages
        @if(session('success'))
            Toast.fire({
                icon: 'success',
                title: '{{ session('success') }}'
            });
        @endif

        // Handle Error Messages
        @if(session('error'))
            ErrorAlert.fire({
                title: 'Error',
                text: '{{ session('error') }}'
            });
        @endif
    </script>

   </x-app-layout>
