<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Monthly Expenses PDF</title>
    <style>
        body { font-family: sans-serif; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { border: 1px solid #ccc; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
        tfoot td { font-weight: bold; background-color: #f9f9f9; }
    </style>
</head>
<body>
    <h2>Monthly Expenses Report</h2>
    <table width="100%" border="1" cellspacing="0" cellpadding="5">
    <thead>
        <tr>
            <th>Name</th>
            <th>Task</th>
            <th>Amount Paid</th>
            <th>Credit</th>
            <th>Current Account</th>
            <th>Due Date</th>
            <th>Notes</th>
        </tr>
    </thead>
    <tbody>
        @foreach($expenses as $expense)
        <tr>
            <td>{{ $expense->name }}</td>
            <td>{{ $expense->task }}</td>
            <td>{{ number_format($expense->amount_paid, 2) }}</td>
            <td>{{ number_format($expense->credit, 2) }}</td>
            <td>{{ number_format($expense->calculated_current_account, 2) }}</td>
            <td>{{ \Carbon\Carbon::parse($expense->due_date)->format('Y-m-d') }}</td>
            <td>{{ $expense->notes }}</td>
        </tr>
        @endforeach
    </tbody>
    <tfoot>
        <tr>
            <th colspan="2">Totals</th>
            <th>{{ number_format($totalAmountPaid, 2) }}</th>
            <th>{{ number_format($totalCredit, 2) }}</th>
            <th colspan="3"></th>
        </tr>
        <tr>
            <th colspan="2">Net Balance (Credit - Paid)</th>
            <th colspan="5">{{ number_format($netBalance, 2) }}</th>
        </tr>
    </tfoot>
</table>

</body>
</html>
