@props(['expenses'])

<div class="tab-pane fade" id="expenses-pane" role="tabpanel" aria-labelledby="expenses-tab" tabindex="0">
    <div class="card border-0 shadow-sm">
        <div class="card-body">
            <h5 class="card-title mb-4">Monthly Expenses</h5>

            <!-- Add Monthly Expense Form -->
            <form action="{{ route('monthly-expenses.store') }}" method="POST" class="mb-4 p-4 bg-white rounded-lg shadow border border-gray-200">
                @csrf
                <h5 class="text-xl font-semibold mb-4">Add Monthly Expense</h5>
                <div class="flex flex-wrap gap-4">
                    <!-- Name -->
                    <div class="flex-1 min-w-[200px]">
                        <label for="name" class="block text-sm font-medium text-gray-700">Name</label>
                        <input type="text" name="name" id="name" class="form-control mt-1 w-full px-3 py-2 border rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500 text-sm" placeholder="Name" required>
                    </div>

                    <!-- Task -->
                    <div class="flex-1 min-w-[200px]">
                        <label for="task" class="block text-sm font-medium text-gray-700">Task</label>
                        <input type="text" name="task" id="task" class="form-control mt-1 w-full px-3 py-2 border rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500 text-sm" placeholder="Task" required>
                    </div>

                    <!-- Amount Paid -->
                    <div class="flex-1 min-w-[150px]">
                        <label for="amount_paid" class="block text-sm font-medium text-gray-700">Amount Paid</label>
                        <input type="number" name="amount_paid" id="amount_paid" step="0.01" class="form-control mt-1 w-full px-3 py-2 border rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500 text-sm" placeholder="Amount Paid" required>
                    </div>

                    <!-- Notes -->
                    <div class="flex-1 min-w-[250px]">
                        <label for="notes" class="block text-sm font-medium text-gray-700">Notes</label>
                        <input type="text" name="notes" id="notes" class="form-control mt-1 w-full px-3 py-2 border rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500 text-sm" placeholder="Notes">
                    </div>

                    <!-- Submit -->
                    <div class="flex items-end">
                        <button type="submit" class="flex items-center gap-2 bg-white text-blue-600 border border-blue-600 px-4 py-2 rounded-md hover:bg-blue-600 hover:text-green-500 transition-all mt-6 shadow-md">
                            <!-- Plus Icon -->
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-blue-600 hover:text-white transition-colors" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4" />
                            </svg>
                            Add Expenses
                        </button>
                    </div>
                </div>
            </form>

            <!-- Update Credit Form -->
            <form action="{{ route('monthly-expenses.store') }}" method="POST" class="mb-4 p-4 bg-white rounded-lg shadow border border-gray-200">
                @csrf
                <h5 class="text-xl font-semibold mb-4">Update Credit</h5>
                <div class="flex flex-wrap gap-4">
                    <!-- Name -->
                    <div class="flex-1 min-w-[200px]">
                        <label for="name" class="block text-sm font-medium text-gray-700">Name</label>
                        <input type="text" name="name" id="name" class="form-control mt-1 w-full px-3 py-2 border rounded-md" placeholder="Name" required>
                    </div>

                    <!-- Task -->
                    <div class="flex-1 min-w-[200px]">
                        <label for="task" class="block text-sm font-medium text-gray-700">Task</label>
                        <input type="text" name="task" id="task" class="form-control mt-1 w-full px-3 py-2 border rounded-md" placeholder="Task" required>
                    </div>

                    <!-- Credit -->
                    <div class="flex-1 min-w-[150px]">
                        <label for="credit" class="block text-sm font-medium text-gray-700">Credit Amount</label>
                        <input type="number" name="credit" id="credit" step="0.01" class="form-control mt-1 w-full px-3 py-2 border rounded-md" placeholder="Credit" required>
                    </div>

                    <!-- Notes -->
                    <div class="flex-1 min-w-[250px]">
                        <label for="notes" class="block text-sm font-medium text-gray-700">Notes</label>
                        <input type="text" name="notes" id="notes" class="form-control mt-1 w-full px-3 py-2 border rounded-md" placeholder="Notes">
                    </div>

                    <!-- Submit -->
                    <div class="flex items-end">
                        <button type="submit" class="flex items-center gap-2 bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700 transition-all mt-6 shadow-md">
                            <!-- Plus Icon -->
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4" />
                            </svg>
                            Update Credit
                        </button>
                    </div>
                </div>
            </form>

            @php
                $totalAmountPaid = $expenses->sum('amount_paid');
                $totalCredit = $expenses->sum('credit');
            @endphp

            <div class="table-responsive">
                <table class="table table-striped align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>Name</th>
                            <th>Task</th>
                            <th>Amount Paid</th>
                            <th>Credit</th>
                            <th>Current Account</th>
                            <th>Due Date</th>
                            <th>Notes</th>
                            <th>Actions</th>
                        </tr>
                    </thead>

                    <tbody>
                        @php $runningBalance = 0; @endphp
                        @foreach($expenses as $expense)
                            @php
                                $runningBalance += $expense->credit - $expense->amount_paid;
                            @endphp
                            <tr>
                                <td>{{ $expense->name }}</td>
                                <td>{{ $expense->task }}</td>
                                <td>{{ number_format($expense->amount_paid, 2) }}</td>
                                <td>{{ number_format($expense->credit, 2) }}</td>
                                <td>{{ number_format($runningBalance, 2) }}</td>
                                <td>{{ \Carbon\Carbon::parse($expense->due_date)->format('Y-m-d') }}</td>
                                <td>{{ $expense->notes }}</td>
                                <td>
                                    <button class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#editExpenseModal{{ $expense->id }}">Edit</button>
                                    <form action="{{ route('monthly-expenses.destroy', $expense->id) }}" method="POST" style="display:inline-block;">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</button>
                                    </form>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>

                    <tfoot class="table-light fw-bold">
                        <tr>
                            <td colspan="2">Totals</td>
                            <td>{{ number_format($totalAmountPaid, 2) }}</td>
                            <td>{{ number_format($totalCredit, 2) }}</td>
                            <td colspan="3" class="{{ ($totalCredit - $totalAmountPaid) >= 0 ? 'text-success' : 'text-danger' }}">
                                {{ number_format($totalCredit - $totalAmountPaid, 2) }}
                            </td>
                            <td colspan="3"></td>
                        </tr>
                        <tr>
                            <td colspan="2">Net Balance (Credit - Amount Paid)</td>
                            <td colspan="3" class="{{ ($totalCredit - $totalAmountPaid) >= 0 ? 'text-success' : 'text-danger' }}">
                                {{ number_format($totalCredit - $totalAmountPaid, 2) }}
                            </td>
                            <td colspan="3"></td>
                        </tr>
                    </tfoot>
                </table>
            </div>

            <div class="d-flex justify-content-end mb-3 gap-2">
                <a href="{{ route('monthly-expenses.export') }}" class="btn btn-success">Export to Excel</a>
                <a href="{{ route('monthly-expenses.export-pdf') }}" class="btn btn-danger">Export to PDF</a>
            </div>
        </div>
    </div>
</div> 