<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Invoice {{ $invoice->invoice_number }}</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap');

        @page {
            margin: 0;
        }

        body {
            font-family: 'Poppins', sans-serif;
            font-size: 14px;
            color: #2c3e50;
            margin: 0;
            padding: 0;
            background: url('{{ public_path("images/INVOICE-bg.jpg") }}') no-repeat center top;
            background-size: cover;
            min-height: 100vh;
        }

        .invoice-container {
            width: 800px;
            margin: 180px auto 100px auto;
            padding: 40px;
            background: rgba(255, 255, 255, 0.95);
            position: relative;
            z-index: 2;
            border-radius: 15px;
            box-shadow: 0 0 30px rgba(0, 0, 0, 0.1);
        }

        .header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 40px;
            padding-bottom: 20px;
            border-bottom: 2px solid #f0f0f0;
        }

        .company-logo {
            max-width: 200px;
            margin-bottom: 20px;
        }

        .invoice-header {
            text-align: right;
        }

        .invoice-header h1 {
            font-size: 32px;
            color: #2c3e50;
            margin: 0 0 10px 0;
            font-weight: 700;
        }

        .invoice-details {
            background: #f8fafc;
            padding: 20px;
            border-radius: 10px;
            margin-bottom: 30px;
        }

        .invoice-details p {
            margin: 5px 0;
            font-size: 13px;
            color: #4a5568;
        }

        .section-title {
            font-size: 18px;
            font-weight: 600;
            color: #2c3e50;
            margin-bottom: 15px;
            padding-bottom: 8px;
            border-bottom: 2px solid #3498db;
            display: inline-block;
        }

        .client-info {
            background: #f8fafc;
            padding: 25px;
            border-radius: 10px;
            margin-bottom: 30px;
        }

        .client-info p {
            margin: 8px 0;
            font-size: 13px;
            color: #4a5568;
        }

        .invoice-table {
            width: 100%;
            border-collapse: separate;
            border-spacing: 0;
            margin-bottom: 30px;
        }

        .invoice-table th {
            background: #3498db;
            color: white;
            font-size: 12px;
            text-transform: uppercase;
            font-weight: 600;
            padding: 15px;
            text-align: left;
        }

        .invoice-table th:first-child {
            border-top-left-radius: 8px;
        }

        .invoice-table th:last-child {
            border-top-right-radius: 8px;
        }

        .invoice-table td {
            padding: 15px;
            border-bottom: 1px solid #e2e8f0;
            font-size: 13px;
        }

        .invoice-table tr:nth-child(even) {
            background-color: #f8fafc;
        }

        .invoice-table tfoot td {
            font-weight: 600;
            background: #f8fafc;
        }

        .grand-total td {
            background: #3498db !important;
            color: white;
            font-size: 16px;
            font-weight: 600;
        }

        .status-badge {
            display: inline-block;
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
            text-transform: uppercase;
        }

        .status-pending {
            background-color: #f1c40f;
            color: #fff;
        }

        .status-paid {
            background-color: #2ecc71;
            color: #fff;
        }

        .status-overdue {
            background-color: #e74c3c;
            color: #fff;
        }

        .payment-details {
            background: #f8fafc;
            padding: 25px;
            border-radius: 10px;
            margin-bottom: 30px;
            border-left: 4px solid #3498db;
        }

        .payment-details h4 {
            font-size: 16px;
            margin-bottom: 15px;
            color: #2c3e50;
            font-weight: 600;
        }

        .payment-table {
            width: 100%;
            font-size: 13px;
        }

        .payment-table td {
            padding: 8px 5px;
            border-bottom: 1px solid #e2e8f0;
        }

        .payment-table .label {
            font-weight: 600;
            width: 35%;
            color: #4a5568;
        }

        .footer {
            margin-top: 40px;
            text-align: center;
            font-size: 12px;
            color: #718096;
            padding-top: 20px;
            border-top: 2px solid #f0f0f0;
        }

        .text-end {
            text-align: right;
        }

        .text-center {
            text-align: center;
        }

        .amount {
            font-family: 'Poppins', monospace;
            font-weight: 600;
        }

        .watermark {
            position: absolute;
            opacity: 0.03;
            font-size: 150px;
            color: #3498db;
            transform: rotate(-30deg);
            top: 30%;
            left: 10%;
            z-index: -1;
            font-weight: 700;
        }
    </style>
</head>
<body>
    <div class="invoice-container">
        <div class="watermark">INVOICE</div>

        <div class="header">
            <div>
                <img src="{{ public_path('images/logo-address.png') }}" alt="Company Logo" class="company-logo">
            </div>
            <div class="invoice-header">
                <h1>INVOICE</h1>
                <div class="invoice-details">
                    <p><strong>Invoice #:</strong> {{ $invoice->invoice_number }}</p>
                    <p><strong>Date Issued:</strong> {{ $invoice->invoice_date->format('d M Y') }}</p>
                    <p><strong>Due Date:</strong> {{ $invoice->invoice_date->addDays(14)->format('d M Y') }}</p>
                    <p><strong>Status:</strong> 
                        <span class="status-badge status-{{ strtolower($invoice->status) }}">
                            {{ ucfirst($invoice->status) }}
                        </span>
                    </p>
                </div>
            </div>
        </div>

        <div class="client-info">
            <h3 class="section-title">Bill To</h3>
            <p><strong>{{ $invoice->client_name }}</strong></p>
            <p>{{ $invoice->client_email }}</p>
            <p>{{ $invoice->client_phone }}</p>
            <p>{{ $invoice->client_city }}, {{ $invoice->client_country }}</p>
        </div>

        <table class="invoice-table">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Worker Name</th>
                    <th>Passport Number</th>
                    <th class="text-end">Stamping Fee</th>
                    <th class="text-end">Arrival Fee</th>
                    <th class="text-end">Subtotal</th>
                </tr>
            </thead>
            <tbody>
                @php
                    $totalStamping = 0;
                    $totalArrival = 0;
                    $workers = is_array($invoice->workers_data) ? $invoice->workers_data : json_decode($invoice->workers_data, true);
                @endphp
                @foreach($workers as $index => $worker)
                    @php
                        $totalStamping += $worker['stamping_fee'];
                        $totalArrival += $worker['arrival_fee'];
                        $subtotal = $worker['stamping_fee'] + $worker['arrival_fee'];
                    @endphp
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td>{{ $worker['worker_name'] }}</td>
                        <td>{{ $worker['passport_number'] }}</td>
                        <td class="text-end amount">${{ number_format($worker['stamping_fee'], 2) }}</td>
                        <td class="text-end amount">${{ number_format($worker['arrival_fee'], 2) }}</td>
                        <td class="text-end amount">${{ number_format($subtotal, 2) }}</td>
                    </tr>
                @endforeach
            </tbody>
            <tfoot>
                <tr>
                    <td colspan="3" rowspan="2" style="border-bottom: none;">
                        <p style="font-style: italic; color: #718096;">Thank you for your business!</p>
                    </td>
                    <td colspan="2" class="text-end">Subtotal</td>
                    <td class="text-end amount">${{ number_format($totalStamping + $totalArrival, 2) }}</td>
                </tr>
                <tr class="grand-total">
                    <td colspan="2" class="text-end">Grand Total</td>
                    <td class="text-end amount">${{ number_format($totalStamping + $totalArrival, 2) }}</td>
                </tr>
            </tfoot>
        </table>

        <div class="payment-details">
            <h4>Payment Information</h4>
            <table class="payment-table">
                <tr>
                    <td class="label">Bank Name:</td>
                    <td>GULF AFRICAN BANK</td>
                </tr>
                <tr>
                    <td class="label">Bank Code:</td>
                    <td>72</td>
                </tr>
                <tr>
                    <td class="label">Branch:</td>
                    <td>KENYATTA AVENUE</td>
                </tr>
                <tr>
                    <td class="label">Branch Code:</td>
                    <td>004</td>
                </tr>
                <tr>
                    <td class="label">Account/IBAN:</td>
                    <td>0900580502</td>
                </tr>
                <tr>
                    <td class="label">Account Name:</td>
                    <td>JESPET AGENCIES LTD</td>
                </tr>
                <tr>
                    <td class="label">SWIFT Code:</td>
                    <td>GAFRKENAXXX</td>
                </tr>
                <tr>
                    <td class="label">Payment Terms:</td>
                    <td>Within 7 days</td>
                </tr>
            </table>
        </div>

        <div class="footer">
            <p>Please make payment by the due date. For any questions regarding this invoice, contact our accounts department.</p>
            <p>JESPET AGENCIES LTD | P.O. Box 870-00516, Nairobi, Kenya | Tel: +254 700 000000 | Email: accounts@jespetagencies.com</p>
        </div>
    </div>
</body>
</html>
