@foreach ($jobs as $job)
    <div class="bg-white rounded-lg shadow-md p-6 mb-4">
        <div class="flex justify-between items-start">
            <div>
                <h2 class="text-xl font-semibold text-gray-800">{{ $job->title }}</h2>
                <p class="text-sm text-gray-500">{{ $job->company }} • {{ $job->location }}</p>
            </div>
            @if ($job->urgent)
                <span class="inline-block bg-red-100 text-red-600 text-xs font-semibold px-2 py-1 rounded">Urgent</span>
            @endif
        </div>

        <div class="mt-4 flex flex-wrap gap-2">
            @if ($job->type)
                <span class="inline-block bg-blue-100 text-blue-700 text-xs px-2 py-1 rounded">{{ $job->type }}</span>
            @endif
            @if ($job->highSalary)
                <span class="inline-block bg-green-100 text-green-700 text-xs px-2 py-1 rounded">High Salary</span>
            @endif
            @if ($job->commission)
                <span class="inline-block bg-purple-100 text-purple-700 text-xs px-2 py-1 rounded">Commission</span>
            @endif
        </div>

        <div class="mt-4 text-gray-700 text-sm line-clamp-3">
            {{ \Illuminate\Support\Str::limit($job->description, 150) }}
        </div>

        <div class="mt-4 text-sm text-gray-500">
            <span>Posted: {{ \Carbon\Carbon::parse($job->posted)->diffForHumans() }}</span>
            <span class="mx-2">|</span>
            <span>Closes: {{ \Carbon\Carbon::parse($job->closes)->format('M d, Y') }}</span>
        </div>

        <a href="#" class="inline-block mt-4 text-blue-600 hover:underline text-sm font-medium">View Details</a>
    </div>
@endforeach
