@extends('layouts.visitors')

@section('title', 'Office Visitors')

@section('content')
<div class="container mt-4">
    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    @if(session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
    @endif
    <div class="card">
        <div class="card-header d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center gap-2">
            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#create">
                Add Visitor
            </button>

            <!-- Export Buttons -->
            <div class="btn-group">
                <a href="{{ route('visitors.export', ['format' => 'csv']) }}" class="btn btn-sm btn-outline-primary">Export to CSV</a>
                <a href="{{ route('visitors.export', ['format' => 'pdf']) }}" class="btn btn-sm btn-outline-danger">Export to PDF</a>
            </div>

            <!-- Filters -->
            <div class="btn-group flex-wrap">
                <a href="{{ route('visitors.index') }}" class="btn btn-secondary {{ request('filter') == null ? 'active' : '' }}">
                    All ({{ $allCount }})
                </a>
                <a href="{{ route('visitors.index', ['filter' => 'checked-in']) }}" class="btn btn-warning {{ request('filter') == 'checked-in' ? 'active' : '' }}">
                    Checked-In ({{ $checkedInCount }})
                </a>
                <a href="{{ route('visitors.index', ['filter' => 'checked-out']) }}" class="btn btn-success {{ request('filter') == 'checked-out' ? 'active' : '' }}">
                    Checked-Out ({{ $checkedOutCount }})
                </a>
                <a href="{{ route('visitors.index', ['filter' => 'deleted']) }}" class="btn btn-primary {{ request('filter') == 'deleted' ? 'active' : '' }}">
                    Registered ({{ $deletedCount }})
                </a>
            </div>

            <!-- Search -->
            <form action="{{ route('visitors.index') }}" method="GET" class="d-flex flex-wrap gap-2 mt-2">
                <input type="text" name="search" class="form-control" placeholder="Search visitors..." value="{{ request('search') }}">
                <button type="submit" class="btn btn-primary">Search</button>
            </form>
        </div>

        <div class="card-body">
            <h3>Visitors List</h3>
            <div class="table-responsive">
                <table class="table table-striped table-bordered align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>#</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Phone</th>
                            <th>Purpose</th>
                            <th>Check-in</th>
                            <th>Check-out</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($visitors as $index => $visitor)
                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td>{{ $visitor->name }}</td>
                            <td>{{ $visitor->email ?? 'N/A' }}</td>
                            <td>{{ $visitor->phone ?? 'N/A' }}</td>
                            <td>{{ $visitor->purpose }}</td>
                            <td>{{ $visitor->check_in ? \Carbon\Carbon::parse($visitor->check_in)->format('d M Y H:i') : 'N/A' }}</td>
                            <td>
                                @if($visitor->check_out)
                                    {{ $visitor->check_out ? \Carbon\Carbon::parse($visitor->check_out)->format('d M Y H:i') : 'N/A' }}
                                @else
                                    <span class="badge bg-warning text-dark">Not Checked Out</span>
                                @endif
                            </td>
                            <td>
                                @if(!$visitor->check_out)
                                    <form action="{{ route('visitors.checkout', $visitor->id) }}" method="POST" class="d-inline">
                                        @csrf
                                        <button type="submit" class="btn btn-warning btn-sm">Check Out</button>
                                    </form>
                                @else
                                    <span class="badge bg-success">Checked Out</span>
                                @endif
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            @if(method_exists($visitors, 'links'))
                <div class="d-flex justify-content-center mt-3">
                    {{ $visitors->links() }}
                </div>
            @endif
        </div>
    </div>

    <!-- Visitor Logs Section -->
    <div class="card mt-4">
        <div class="card-header d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center gap-2">
            <h3>Visitor Logs</h3>

            <!-- Export -->
            <div class="btn-group">
                <a href="{{ route('logs.export', ['format' => 'csv']) }}" class="btn btn-sm btn-outline-primary">Export to CSV</a>
                <a href="{{ route('logs.export', ['format' => 'pdf']) }}" class="btn btn-sm btn-outline-danger">Export to PDF</a>
            </div>

            <!-- Filters -->
            <form action="{{ route('visitors.index') }}" method="GET" class="d-flex flex-wrap gap-2 mt-2">
                <input type="text" name="search" class="form-control" placeholder="Search logs..." value="{{ request('search') }}">
                <select name="log_filter" class="form-select">
                    <option value="">All Actions</option>
                    <option value="Checked In" {{ request('log_filter') == 'Checked In' ? 'selected' : '' }}>Checked In</option>
                    <option value="Checked Out" {{ request('log_filter') == 'Checked Out' ? 'selected' : '' }}>Checked Out</option>
                </select>
                <button type="submit" class="btn btn-primary">Filter</button>
            </form>
        </div>
        <div class="card-body">
            @if($visitorLogs->isEmpty())
                <p class="text-danger">No logs found!</p>
            @else
                <div class="table-responsive">
                    <table class="table table-striped table-bordered align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>#</th>
                                <th>Visitor</th>
                                <th>Action</th>
                                <th>Time</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($visitorLogs as $index => $log)
                            <tr>
                                <td>{{ $index + 1 }}</td>
                                <td>{{ optional($log->visitor)->name ?? 'Unknown' }}</td>
                                <td>{{ $log->action }}</td>
                                <td>{{ \Carbon\Carbon::parse($log->action_time)->format('d M Y H:i') }}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @endif
            @if(method_exists($visitorLogs, 'links'))
                <div class="d-flex justify-content-center mt-3">
                    {{ $visitorLogs->links() }}
                </div>
            @endif
        </div>
    </div>

    @include('visitors.create')
</div>
@endsection

@section('css')
<link href="https://cdn.jsdelivr.net/npm/sweetalert2@11.4.27/dist/sweetalert2.min.css" rel="stylesheet">
@endsection

@section('js')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.4.27/dist/sweetalert2.min.js"></script>
<script>
    document.addEventListener("DOMContentLoaded", function() {
        let now = new Date();
        let formattedDateTime = now.getFullYear() + "-" 
            + String(now.getMonth() + 1).padStart(2, '0') + "-" 
            + String(now.getDate()).padStart(2, '0') + " " 
            + String(now.getHours()).padStart(2, '0') + ":" 
            + String(now.getMinutes()).padStart(2, '0') + ":" 
            + String(now.getSeconds()).padStart(2, '0');
        document.getElementById("check_in_time").value = formattedDateTime;
    });
</script>
@endsection
