@extends('layouts.vouchers')

@section('content')
<div class="container">
    <!-- Header Section -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="mb-0">Payment Vouchers</h4>
        <div>
            <a href="{{ route('vouchers.create') }}" class="btn btn-primary">
                <i class="fas fa-plus"></i> Create Voucher
            </a>
            <a href="{{ route('vouchers.index', ['status' => 'pending']) }}" class="btn btn-outline-secondary ms-2">
                <i class="fas fa-clock"></i> View Pending
            </a>
        </div>
    </div>

    <!-- Voucher Creation Section (Only shown on create route) -->
    @if(request()->routeIs('vouchers.create'))
        @include('vouchers.partials.worker_selection', [
            'travelledWorkers' => $travelledWorkers,
            'selectedWorker' => $selectedWorker ?? null
        ])

        @if(isset($selectedWorker))
            @include('vouchers.partials.voucher_form', [
                'selectedWorker' => $selectedWorker,
                'subAgents' => $subAgents
            ])
        @elseif(isset($travelledWorkers) && $travelledWorkers->isNotEmpty())
            <div class="alert alert-warning">
                <i class="fas fa-exclamation-triangle me-2"></i>
                Please select a worker to create a voucher
            </div>
        @endif
    @endif

    <!-- Voucher Listing Section -->
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Voucher Records</h5>
            <div class="d-flex">
                <form method="GET" class="me-2">
                    <div class="input-group input-group-sm">
                        <input type="text" name="search" class="form-control" placeholder="Search..." 
                               value="{{ request('search') }}">
                        <button class="btn btn-outline-secondary" type="submit">
                            <i class="fas fa-search"></i>
                        </button>
                    </div>
                </form>
                <div class="dropdown">
                    <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button" 
                            data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="fas fa-filter"></i> Status
                    </button>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="?status=all">All</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="?status=pending">Pending</a></li>
                        <li><a class="dropdown-item" href="?status=approved">Approved</a></li>
                        <li><a class="dropdown-item" href="?status=paid">Paid</a></li>
                        <li><a class="dropdown-item" href="?status=rejected">Rejected</a></li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="card-body">
            @if($vouchers->isEmpty())
                <div class="text-center py-4">
                    <p class="text-muted mb-0">No vouchers found matching your criteria.</p>
                    @if(request()->routeIs('vouchers.index'))
                        <a href="{{ route('vouchers.create') }}" class="btn btn-primary mt-2">
                            <i class="fas fa-plus"></i> Create First Voucher
                        </a>
                    @endif
                </div>
            @else
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead class="table-light">
                            <tr>
                                <th>Voucher #</th>
                                <th>Worker</th>
                                <th>Sub Agent</th>
                                <th>Type</th>
                                <th>Amount</th>
                                <th>Status</th>
                                <th>Created</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($vouchers as $voucher)
                                <tr>
                                    <td>
                                        <a href="{{ route('vouchers.show', $voucher) }}" class="text-primary">
                                            {{ $voucher->voucher_number }}
                                        </a>
                                    </td>
                                    <td>
                                        @if($voucher->worker)
                                            {{ $voucher->worker->surname }} {{ $voucher->worker->given_names }}
                                        @else
                                            N/A
                                        @endif
                                    </td>
                                    <td>{{ $voucher->subAgent->name ?? 'N/A' }}</td>
                                    <td>
                                        <span class="badge bg-{{ $voucher->voucher_type === 'advance' ? 'info' : 'primary' }}">
                                            {{ ucfirst($voucher->voucher_type) }}
                                        </span>
                                    </td>
                                    <td class="fw-bold">{{ number_format($voucher->total_amount, 2) }}</td>
                                    <td>
                                        <span class="badge bg-{{ 
                                            $voucher->status === 'pending' ? 'warning' : 
                                            ($voucher->status === 'approved' ? 'success' : 
                                            ($voucher->status === 'paid' ? 'primary' :
                                            ($voucher->status === 'rejected' ? 'danger' : 'secondary'))) 
                                        }}">
                                            {{ ucfirst($voucher->status) }}
                                        </span>
                                    </td>
                                    <td>{{ $voucher->created_at->format('M d, Y') }}</td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <a href="{{ route('vouchers.show', $voucher) }}" 
                                               class="btn btn-outline-primary" title="View">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            @if($voucher->canBeEdited())
                                                <form action="{{ route('vouchers.destroy', $voucher) }}" method="POST" 
                                                      class="d-inline">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-outline-danger" 
                                                            title="Delete"
                                                            onclick="return confirm('Are you sure you want to delete this voucher?')">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <div class="d-flex justify-content-between align-items-center mt-4">
                    <div class="text-muted small">
                        Showing {{ $vouchers->firstItem() }} to {{ $vouchers->lastItem() }} 
                        of {{ $vouchers->total() }} entries
                    </div>
                    {{ $vouchers->withQueryString()->links() }}
                </div>
            @endif
        </div>
    </div>
</div>
@endsection

@if(request()->routeIs('vouchers.create'))
    @push('styles')
    <style>
        .fi {
            width: 1em;
            height: 1em;
            border-radius: 50%;
            box-shadow: 0 0 1px rgba(0,0,0,0.5);
        }
        .table-primary {
            background-color: rgba(13, 110, 253, 0.1);
        }
    </style>
    @endpush
@endif