<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>HireStream - Streamline Your Hiring Process</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">

    <!-- Bootstrap JS Bundle -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=inter:300,400,500,600,700" rel="stylesheet" />
    <style>
  body {
    font-family: 'Inter', sans-serif;
  }
  
  /* Utility Classes */
  .feature-icon {
    width: 48px;
    height: 48px;
  }
  
  .step-number {
    width: 40px;
    height: 40px;
  }
  
  .z-0 { z-index: 0; }
  .z-1 { z-index: 1; }
  
  /* Gradients */
  .text-gradient-primary {
    background: linear-gradient(90deg, #3b82f6, #8b5cf6);
    -webkit-background-clip: text;
    background-clip: text;
    -webkit-text-fill-color: transparent;
  }
  
  .bg-gradient-light {
    background: linear-gradient(135deg, rgba(255,255,255,1) 0%, rgba(236,245,255,1) 100%);
  }
  
  .bg-gradient-shade {
    background: linear-gradient(45deg, rgba(59,130,246,0.05) 0%, rgba(255,255,255,0) 50%);
  }
  
  .bg-gradient-instagram {
    background: linear-gradient(45deg, #405DE6, #5851DB, #833AB4, #C13584, #E1306C, #FD1D1D, #F56040, #F77737, #FCAF45, #FFDC80);
  }
  
  /* Hover Effects */
  .hover-lift {
    transition: all 0.3s ease;
  }
  
  .hover-lift:hover {
    transform: translateY(-3px);
    box-shadow: 0 10px 20px rgba(0,0,0,0.15) !important;
  }
  
  .shadow-sm-hover:hover {
    box-shadow: 0 4px 12px rgba(59, 130, 246, 0.3);
  }
  
  .hover-shadow:hover {
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
  }
  
  /* Component Styles */
  .hero-section {
    position: relative;
  }
  
  /* Modal Z-index Fixes */
  .modal {
    z-index: 1050;
  }
  
  .modal-backdrop {
    z-index: 1040;
  }
  
  /* Accordion Fixes */
  .accordion-button:not(.collapsed) {
    box-shadow: none;
    background-color: white;
  }
  
  .accordion-button:focus {
    box-shadow: none;
  }
</style>

</head>
<body class="bg-light">
    <!-- Header with Auth -->
<header class="bg-white shadow-sm sticky-top">
    <nav class="navbar navbar-expand-lg navbar-light py-3">
        <div class="container">
            <!-- Brand/Logo -->
            <a class="navbar-brand fs-4 fw-bold text-primary" href="#">
                <i class="bi bi-people-fill me-2"></i>HireStream
            </a>
            
            <!-- Mobile Toggle Button -->
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            
            <!-- Navbar Links -->
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav me-auto">
                    <li class="nav-item mx-2">
                        <a class="nav-link" href="#">Home</a>
                    </li>
                    <li class="nav-item mx-2">
                        <a class="nav-link" href="#features">Features</a>
                    </li>
                    <li class="nav-item mx-2">
                        <a class="nav-link" href="#pricing">Pricing</a>
                    </li>
                    <li class="nav-item mx-2">
                        <a class="nav-link" href="#solutions">Solutions</a>
                    </li>
                    <li class="nav-item mx-2">
                        <a class="nav-link" href="#faq">FAQ</a>
                    </li>
                    <li class="nav-item mx-2">
                        <a class="nav-link" href="#contact">Contact Us</a>
                    </li>
                </ul>
                
                <!-- Auth Links -->
                <ul class="navbar-nav">
                    @if (Route::has('login'))
                        @auth
                            <li class="nav-item ms-2">
                                <a href="{{ url('/dashboard') }}" class="btn btn-outline-secondary">
                                    Dashboard
                                </a>
                            </li>
                        @else
                            <li class="nav-item">
                                <a href="{{ route('login') }}" class="btn btn-outline-primary me-2">
                                    Log in
                                </a>
                            </li>
                            @if (Route::has('register'))
                                <li class="nav-item">
                                <a href="{{ route('register') }}" class="btn btn-outline-success">
                                Get Started
                                    </a>
                                </li>
                            @endif
                        @endauth
                    @endif
                </ul>
            </div>
        </div>
    </nav>
</header>

    <main>
       <!-- Hero Section with Background Image -->
<section class="py-7 position-relative overflow-hidden hero-section" style="background: linear-gradient(rgba(255,255,255,0.9), rgba(255,255,255,0.8)), url('https://images.unsplash.com/photo-1521791136064-7986c2920216?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2069&q=80') center/cover no-repeat;">
  <div class="container py-5 position-relative" style="z-index: 2;">
    <div class="row justify-content-center">
      <div class="col-lg-9 text-center">
        <!-- Header with gradient text -->
        <h1 class="display-3 fw-bold mb-4 text-dark">
          <span class="text-gradient-primary">Transform Your Hiring</span><br>
          <span class="text-dark">With Smart Recruitment AI</span>
        </h1>
        
        <!-- Content with semi-transparent background for readability -->
        <div class="lead mb-5 mx-auto p-4 p-md-5 bg-white bg-opacity-75 rounded-4 shadow-sm" style="max-width: 800px;">
          <p class="mb-4">
            HireStream revolutionizes recruitment by combining AI-powered automation with intuitive tools, helping businesses of all sizes find and hire top talent faster than ever.
          </p>
          
          <!-- Feature highlights -->
          <ul class="list-unstyled text-start mb-4">
            <li class="mb-2"><i class="bi bi-check-circle-fill text-primary me-2"></i> End-to-end hiring solution from sourcing to onboarding</li>
            <li class="mb-2"><i class="bi bi-check-circle-fill text-primary me-2"></i> Bias-reducing smart matching algorithms</li>
            <li class="mb-2"><i class="bi bi-check-circle-fill text-primary me-2"></i> Real-time analytics and reporting</li>
            <li class="mb-2"><i class="bi bi-check-circle-fill text-primary me-2"></i> Digital contract authentication</li>
          </ul>
          
          <p class="mb-0">
            Trusted by HR teams worldwide, we ensure transparency, fairness, and efficiency at every step.
          </p>
        </div>
        
        <!-- CTA Buttons with YouTube Modal -->
        <div class="d-flex flex-wrap justify-content-center gap-3 mb-4">
          <a href="{{ route('register') }}" class="btn btn-primary btn-lg px-5 py-3 fw-bold hover-lift">
            Start Free Trial <i class="bi bi-arrow-right ms-2"></i>
          </a>
          <button type="button" class="btn btn-outline-dark btn-lg px-5 py-3 fw-bold hover-lift" data-bs-toggle="modal" data-bs-target="#demoVideoModal">
            <i class="bi bi-play-circle me-2"></i> Watch Demo
          </button>
        </div>
        
        <!-- Trust Badges -->
        <div class="d-flex flex-wrap justify-content-center gap-4 mt-4">
          <div class="bg-white bg-opacity-75 px-4 py-2 rounded-pill shadow-sm">
            <i class="bi bi-shield-check text-primary me-2"></i> SOC 2 Certified
          </div>
          <div class="bg-white bg-opacity-75 px-4 py-2 rounded-pill shadow-sm">
            <i class="bi bi-globe2 text-primary me-2"></i> 50+ Countries
          </div>
          <div class="bg-white bg-opacity-75 px-4 py-2 rounded-pill shadow-sm">
            <i class="bi bi-people-fill text-primary me-2"></i> 10,000+ Placements
          </div>
        </div>
      </div>
    </div>
  </div>
  
  <!-- Gradient Overlay -->
  <div class="position-absolute top-0 start-0 w-100 h-100 overflow-hidden" style="z-index: 1;">
    <div class="position-absolute top-0 start-0 w-100 h-100 bg-gradient-shade"></div>
  </div>
</section>

<!-- YouTube Modal -->
<div class="modal fade" id="demoVideoModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content border-0 overflow-hidden">
      <div class="modal-header border-0 pb-0">
        <h5 class="modal-title text-dark fw-bold">See HireStream in Action</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body p-0">
        <div class="ratio ratio-16x9">
          <iframe id="demoVideoFrame" src="https://www.youtube.com/embed/YOUR_VIDEO_ID?enablejsapi=1" 
                  frameborder="0" 
                  allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" 
                  allowfullscreen></iframe>
        </div>
      </div>
      <div class="modal-footer border-0 bg-light">
        <a href="{{ route('register') }}" class="btn btn-primary me-auto">
          Start Free Trial <i class="bi bi-arrow-right ms-2"></i>
        </a>
        <small class="text-muted">1:30 min overview</small>
      </div>
    </div>
  </div>
</div>

<style>
  .text-gradient-primary {
    background: linear-gradient(90deg, #3b82f6 0%, #8b5cf6 100%);
    -webkit-background-clip: text;
    background-clip: text;
    -webkit-text-fill-color: transparent;
  }
  
  .bg-gradient-shade {
    background: linear-gradient(45deg, rgba(59,130,246,0.05) 0%, rgba(255,255,255,0) 50%);
  }
  
  .hover-lift {
    transition: all 0.3s ease;
  }
  .hover-lift:hover {
    transform: translateY(-3px);
    box-shadow: 0 10px 20px rgba(0,0,0,0.15);
  }
  
  /* Z-index fixes */
  .hero-section {
    position: relative;
  }
  
  .modal {
    z-index: 1050;
  }
  
  .modal-backdrop {
    z-index: 1040;
  }
</style>




        <!-- Features Section -->
        <section class="py-5 bg-white">
            <div class="container py-5">
                <div class="text-center mb-5">
                    <h2 class="display-5 fw-bold mb-3">Powerful Hiring Tools</h2>
                    <p class="text-muted mx-auto" style="max-width: 600px;">
                        Everything you need to streamline your recruitment workflow and make better hiring decisions
                    </p>
                </div>

                <div class="row g-4">
                    <!-- Feature 1 -->
                    <div class="col-md-6 col-lg-4">
                        <div class="card h-100 shadow-sm">
                            <div class="card-body p-4">
                                <div class="feature-icon bg-primary bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center mb-4">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-search text-primary" viewBox="0 0 16 16">
                                        <path d="M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0z"/>
                                    </svg>
                                </div>
                                <h3 class="h4 mb-3">Smart Candidate Search</h3>
                                <p class="text-muted mb-0">
                                    Our AI-powered search helps you find the perfect candidates based on skills, experience, and culture fit.
                                </p>
                            </div>
                        </div>
                    </div>

                    <!-- Feature 2 -->
                    <div class="col-md-6 col-lg-4">
                        <div class="card h-100 shadow-sm">
                            <div class="card-body p-4">
                                <div class="feature-icon bg-primary bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center mb-4">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-file-earmark-text text-primary" viewBox="0 0 16 16">
                                        <path d="M5.5 7a.5.5 0 0 0 0 1h5a.5.5 0 0 0 0-1h-5zM5 9.5a.5.5 0 0 1 .5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5zm0 2a.5.5 0 0 1 .5-.5h2a.5.5 0 0 1 0 1h-2a.5.5 0 0 1-.5-.5z"/>
                                        <path d="M9.5 0H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V4.5L9.5 0zm0 1v2A1.5 1.5 0 0 0 11 4.5h2V14a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1h5.5z"/>
                                    </svg>
                                </div>
                                <h3 class="h4 mb-3">Automated Screening</h3>
                                <p class="text-muted mb-0">
                                    Save time with automated resume screening and pre-qualification questions.
                                </p>
                            </div>
                        </div>
                    </div>

                    <!-- Feature 3 -->
                    <div class="col-md-6 col-lg-4">
                        <div class="card h-100 shadow-sm">
                            <div class="card-body p-4">
                                <div class="feature-icon bg-primary bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center mb-4">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-calendar text-primary" viewBox="0 0 16 16">
                                        <path d="M3.5 0a.5.5 0 0 1 .5.5V1h8V.5a.5.5 0 0 1 1 0V1h1a2 2 0 0 1 2 2v11a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V3a2 2 0 0 1 2-2h1V.5a.5.5 0 0 1 .5-.5zM1 4v10a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V4H1z"/>
                                    </svg>
                                </div>
                                <h3 class="h4 mb-3">Interview Scheduling</h3>
                                <p class="text-muted mb-0">
                                    Automated scheduling eliminates back-and-forth emails and reduces time-to-hire.
                                </p>
                            </div>
                        </div>
                    </div>

                    <!-- Feature 4 -->
                    <div class="col-md-6 col-lg-4">
                        <div class="card h-100 shadow-sm">
                            <div class="card-body p-4">
                                <div class="feature-icon bg-primary bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center mb-4">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-check-circle text-primary" viewBox="0 0 16 16">
                                        <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z"/>
                                        <path d="M10.97 4.97a.235.235 0 0 0-.02.022L7.477 9.417 5.384 7.323a.75.75 0 0 0-1.06 1.06L6.97 11.03a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 0 0-1.071-1.05z"/>
                                    </svg>
                                </div>
                                <h3 class="h4 mb-3">Candidate Assessments</h3>
                                <p class="text-muted mb-0">
                                    Customizable skills tests and coding challenges to evaluate candidates objectively.
                                </p>
                            </div>
                        </div>
                    </div>

                    <!-- Feature 5 -->
                    <div class="col-md-6 col-lg-4">
                        <div class="card h-100 shadow-sm">
                            <div class="card-body p-4">
                                <div class="feature-icon bg-primary bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center mb-4">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-people text-primary" viewBox="0 0 16 16">
                                        <path d="M15 14s1 0 1-1-1-4-5-4-5 3-5 4 1 1 1 1h8zm-7.978-1A.261.261 0 0 1 7 12.996c.001-.264.167-1.03.76-1.72C8.312 10.629 9.282 10 11 10c1.717 0 2.687.63 3.24 1.276.593.69.758 1.457.76 1.72l-.008.002a.274.274 0 0 1-.014.002H7.022zM11 7a2 2 0 1 0 0-4 2 2 0 0 0 0 4zm3-2a3 3 0 1 1-6 0 3 3 0 0 1 6 0zM6.936 9.28a5.88 5.88 0 0 0-1.23-.247A7.35 7.35 0 0 0 5 9c-4 0-5 3-5 4 0 .667.333 1 1 1h4.216A2.238 2.238 0 0 1 5 13c0-1.01.377-2.042 1.09-2.904.243-.294.526-.569.846-.816zM4.92 10A5.493 5.493 0 0 0 4 13H1c0-.26.164-1.03.76-1.724.545-.636 1.492-1.256 3.16-1.275zM1.5 5.5a3 3 0 1 1 6 0 3 3 0 0 1-6 0zm3-2a2 2 0 1 0 0 4 2 2 0 0 0 0-4z"/>
                                    </svg>
                                </div>
                                <h3 class="h4 mb-3">Collaborative Hiring</h3>
                                <p class="text-muted mb-0">
                                    Involve your team with shared notes, ratings, and feedback in one centralized platform.
                                </p>
                            </div>
                        </div>
                    </div>

                    <!-- Feature 6 -->
                    <div class="col-md-6 col-lg-4">
                        <div class="card h-100 shadow-sm">
                            <div class="card-body p-4">
                                <div class="feature-icon bg-primary bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center mb-4">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-bar-chart text-primary" viewBox="0 0 16 16">
                                        <path d="M4 11H2v3h2v-3zm5-4H7v7h2V7zm5-5v12h-2V2h2zm-2-1a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1h-2zM6 7a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v7a1 1 0 0 1-1 1H7a1 1 0 0 1-1-1V7zm-5 4a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v3a1 1 0 0 1-1 1H2a1 1 0 0 1-1-1v-3z"/>
                                    </svg>
                                </div>
                                <h3 class="h4 mb-3">Analytics Dashboard</h3>
                                <p class="text-muted mb-0">
                                    Track key metrics like time-to-hire, source effectiveness, and diversity statistics.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
<!-- Hero Features Section -->
<section id="features" class="py-7 bg-gradient-light">
  <div class="container">
    <div class="row align-items-center">
      <!-- Left Column - Feature Highlights -->
      <div class="col-lg-6 mb-5 mb-lg-0">
        <span class="badge bg-primary bg-opacity-10 text-primary mb-3 px-4 py-2 rounded-pill">
          <i class="bi bi-lightning-charge me-2"></i>AI-Powered Recruitment
        </span>
        <h1 class="display-4 fw-bold mb-4">Transform Hiring with <span class="text-gradient-primary">Smart Automation</span></h1>
        <p class="lead text-muted mb-5">From eTawtheeq’s contract authentication to HireStream’s AI matching – we’ve revolutionized recruitment workflows for the digital age.</p>
        
        <!-- Key Feature Cards -->
        <div class="d-flex flex-column gap-4">
          <!-- Feature 1 -->
          <div class="d-flex align-items-start p-4 bg-white rounded-4 shadow-sm hover-lift">
            <div class="bg-primary bg-opacity-10 p-3 rounded-3 me-4">
              <i class="bi bi-file-earmark-check-fill text-primary fs-3"></i>
            </div>
            <div>
              <h4 class="fw-bold mb-2">Digital Contract Authentication</h4>
              <p class="mb-0">Secure, legally-binding e-contracts between employers and candidates – perfected from our eTawtheeq foundation.</p>
            </div>
          </div>
          
          <!-- Feature 2 -->
          <div class="d-flex align-items-start p-4 bg-white rounded-4 shadow-sm hover-lift">
            <div class="bg-primary bg-opacity-10 p-3 rounded-3 me-4">
              <i class="bi bi-robot text-primary fs-3"></i>
            </div>
            <div>
              <h4 class="fw-bold mb-2">AI Candidate Matching</h4>
              <p class="mb-0">Our proprietary algorithm analyzes 50+ data points to surface perfect-fit candidates in seconds.</p>
            </div>
          </div>
          
          <!-- Feature 3 -->
          <div class="d-flex align-items-start p-4 bg-white rounded-4 shadow-sm hover-lift">
            <div class="bg-primary bg-opacity-10 p-3 rounded-3 me-4">
              <i class="bi bi-globe text-primary fs-3"></i>
            </div>
            <div>
              <h4 class="fw-bold mb-2">Global Compliance</h4>
              <p class="mb-0">Automated adherence to labor regulations across 18 countries – built on Ministry-approved frameworks.</p>
            </div>
          </div>
        </div>
      </div>
      
      <!-- Right Column - Feature Visualization -->
      <div class="col-lg-6">
        <div class="position-relative p-5">
          <!-- Main Dashboard Mockup -->
          <div class="rounded-4 overflow-hidden shadow-lg">
            <img src="https://images.unsplash.com/photo-1551288049-bebda4e38f71?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=1470&q=80" 
                 class="img-fluid" 
                 alt="Recruitment Dashboard" 
                 style="border: 15px solid white; border-bottom: 40px solid white">
          </div>
          
          <!-- Animated Stats Floater 1 -->
          <div class="position-absolute top-0 start-0 translate-middle bg-white p-3 rounded-3 shadow-sm hover-lift" style="width: 160px;">
            <div class="d-flex align-items-center">
              <div class="bg-success bg-opacity-10 p-2 rounded-2 me-2">
                <i class="bi bi-graph-up-arrow text-success"></i>
              </div>
              <div>
                <h6 class="fw-bold mb-0">87% Faster</h6>
                <small class="text-muted">Hiring cycle</small>
              </div>
            </div>
          </div>
          
          <!-- Animated Stats Floater 2 -->
          <div class="position-absolute bottom-0 end-0 translate-middle bg-white p-3 rounded-3 shadow-sm hover-lift" style="width: 160px;">
            <div class="d-flex align-items-center">
              <div class="bg-primary bg-opacity-10 p-2 rounded-2 me-2">
                <i class="bi bi-people-fill text-primary"></i>
              </div>
              <div>
                <h6 class="fw-bold mb-0">5,000+</h6>
                <small class="text-muted">Daily placements</small>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>


        <!-- Process Section -->
        <section id="solutions"class="py-5">
            <div class="container py-5">
                <div class="text-center mb-5">
                    <h2 class="display-5 fw-bold mb-3">Simplified Hiring Process</h2>
                    <p class="text-muted mx-auto" style="max-width: 600px;">
                        How HireStream transforms your recruitment workflow
                    </p>
                </div>

                <div class="row justify-content-center">
                    <div class="col-lg-8">
                        <div class="d-flex flex-column gap-4">
                            <!-- Step 1 -->
                            <div class="d-flex gap-4">
                                <div class="step-number bg-primary text-white rounded-circle d-flex align-items-center justify-content-center flex-shrink-0">
                                    1
                                </div>
                                <div>
                                    <h3 class="h4 mb-2">Create Job Postings</h3>
                                    <p class="text-muted mb-0">
                                        Easily create attractive job listings with our templates and distribute them to multiple job boards with one click.
                                    </p>
                                </div>
                            </div>

                            <!-- Step 2 -->
                            <div class="d-flex gap-4">
                                <div class="step-number bg-primary text-white rounded-circle d-flex align-items-center justify-content-center flex-shrink-0">
                                    2
                                </div>
                                <div>
                                    <h3 class="h4 mb-2">Source Candidates</h3>
                                    <p class="text-muted mb-0">
                                        Our AI scans thousands of profiles to find the best matches based on your requirements.
                                    </p>
                                </div>
                            </div>

                            <!-- Step 3 -->
                            <div class="d-flex gap-4">
                                <div class="step-number bg-primary text-white rounded-circle d-flex align-items-center justify-content-center flex-shrink-0">
                                    3
                                </div>
                                <div>
                                    <h3 class="h4 mb-2">Screen & Qualify</h3>
                                    <p class="text-muted mb-0">
                                        Automated screening questions and skills assessments help you quickly identify top candidates.
                                    </p>
                                </div>
                            </div>

                            <!-- Step 4 -->
                            <div class="d-flex gap-4">
                                <div class="step-number bg-primary text-white rounded-circle d-flex align-items-center justify-content-center flex-shrink-0">
                                    4
                                </div>
                                <div>
                                    <h3 class="h4 mb-2">Interview & Evaluate</h3>
                                    <p class="text-muted mb-0">
                                        Schedule interviews, collect feedback from your team, and compare candidates side-by-side.
                                    </p>
                                </div>
                            </div>

                            <!-- Step 5 -->
                            <div class="d-flex gap-4">
                                <div class="step-number bg-primary text-white rounded-circle d-flex align-items-center justify-content-center flex-shrink-0">
                                    5
                                </div>
                                <div>
                                    <h3 class="h4 mb-2">Make Offers & Onboard</h3>
                                    <p class="text-muted mb-0">
                                        Send offers with e-signature and seamlessly transition new hires to your onboarding process.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
<!-- Pricing Section -->
<section id="pricing"class="py-5 bg-light">
  <div class="container py-5">
    <div class="text-center mb-5">
      <span class="badge bg-primary bg-opacity-10 text-primary mb-3 px-4 py-2 rounded-pill">
        <i class="bi bi-tag me-2"></i>Simple Pricing
      </span>
      <h2 class="display-5 fw-bold mb-3">Plans That <span class="text-primary">Scale</span> With You</h2>
      <p class="lead text-muted mx-auto" style="max-width: 700px;">
        Start small and upgrade as your hiring needs grow. No long-term contracts, cancel anytime.
      </p>
    </div>

    <div class="row g-4 justify-content-center">
      <!-- Starter Plan -->
      <div class="col-md-4">
        <div class="card h-100 border-0 shadow-sm hover-lift">
          <div class="card-body p-4 text-center">
            <h3 class="fw-bold mb-3">Starter</h3>
            <p class="text-muted mb-4">Perfect for small teams</p>
            
            <div class="mb-4">
              <span class="display-4 fw-bold text-primary">$29</span>
              <span class="text-muted">/month</span>
            </div>
            
            <ul class="list-unstyled mb-4 text-start">
              <li class="mb-3"><i class="bi bi-check-circle-fill text-success me-2"></i> 3 active job posts</li>
              <li class="mb-3"><i class="bi bi-check-circle-fill text-success me-2"></i> 50 candidate profiles/mo</li>
              <li class="mb-3"><i class="bi bi-check-circle-fill text-success me-2"></i> Basic analytics</li>
              <li class="mb-3"><i class="bi bi-check-circle-fill text-success me-2"></i> Email support</li>
            </ul>
            
            <a href="#" class="btn btn-outline-primary w-100 py-3">Get Started</a>
          </div>
        </div>
      </div>

      <!-- Professional Plan (Popular) -->
      <div class="col-md-4">
        <div class="card h-100 border-0 shadow-lg hover-lift">
          <div class="position-relative">
            <!-- Ribbon Badge (only custom element) -->
            <div class="position-absolute top-0 start-50 translate-middle" style="z-index: 1;">
              <span class="badge bg-primary rounded-pill px-3 py-2 shadow-sm">
                <i class="bi bi-star-fill me-1"></i> Most Popular
              </span>
            </div>
          </div>
          <div class="card-body p-4 text-center">
            <h3 class="fw-bold mb-3">Professional</h3>
            <p class="text-muted mb-4">For growing businesses</p>
            
            <div class="mb-4">
              <span class="display-4 fw-bold text-primary">$99</span>
              <span class="text-muted">/month</span>
            </div>
            
            <ul class="list-unstyled mb-4 text-start">
              <li class="mb-3"><i class="bi bi-check-circle-fill text-success me-2"></i> 10 active job posts</li>
              <li class="mb-3"><i class="bi bi-check-circle-fill text-success me-2"></i> 200 candidate profiles/mo</li>
              <li class="mb-3"><i class="bi bi-check-circle-fill text-success me-2"></i> Advanced analytics</li>
              <li class="mb-3"><i class="bi bi-check-circle-fill text-success me-2"></i> AI candidate matching</li>
              <li class="mb-3"><i class="bi bi-check-circle-fill text-success me-2"></i> Priority support</li>
            </ul>
            
            <a href="#" class="btn btn-primary w-100 py-3">Start Free Trial</a>
          </div>
        </div>
      </div>

      <!-- Enterprise Plan -->
      <div class="col-md-4">
        <div class="card h-100 border-0 shadow-sm hover-lift">
          <div class="card-body p-4 text-center">
            <h3 class="fw-bold mb-3">Enterprise</h3>
            <p class="text-muted mb-4">For large organizations</p>
            
            <div class="mb-4">
              <span class="display-4 fw-bold text-primary">Custom</span>
            </div>
            
            <ul class="list-unstyled mb-4 text-start">
              <li class="mb-3"><i class="bi bi-check-circle-fill text-success me-2"></i> Unlimited job posts</li>
              <li class="mb-3"><i class="bi bi-check-circle-fill text-success me-2"></i> Unlimited candidates</li>
              <li class="mb-3"><i class="bi bi-check-circle-fill text-success me-2"></i> Dedicated account manager</li>
              <li class="mb-3"><i class="bi bi-check-circle-fill text-success me-2"></i> API access</li>
              <li class="mb-3"><i class="bi bi-check-circle-fill text-success me-2"></i> HRIS integrations</li>
              <li class="mb-3"><i class="bi bi-check-circle-fill text-success me-2"></i> 24/7 support</li>
            </ul>
            
            <a href="#contact" class="btn btn-outline-primary w-100 py-3">Contact Sales</a>
          </div>
        </div>
      </div>
    </div>

    <!-- Enterprise Note -->
    <div class="text-center mt-5">
      <p class="text-muted mb-0">
        Need something different? <a href="#contact" class="text-decoration-none">Contact us</a> for custom enterprise solutions.
      </p>
    </div>
  </div>
</section>

<!-- FAQ Section -->
<section id="faq" class="py-7 bg-white">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-lg-8 text-center mb-6">
        <span class="badge bg-primary bg-opacity-10 text-primary mb-3 px-4 py-2 rounded-pill">
          <i class="bi bi-question-circle me-2"></i>Need Help?
        </span>
        <h2 class="display-5 fw-bold mb-3">Frequently Asked <span class="text-primary">Questions</span></h2>
        <p class="lead text-muted">Everything you need to know about HireStream's recruitment solutions</p>
      </div>
    </div>
    
    <div class="row justify-content-center">
      <div class="col-lg-10">
        <!-- Accordion -->
        <div class="accordion" id="faqAccordion">
          <!-- Item 1 -->
          <div class="accordion-item border-0 rounded-3 shadow-sm mb-3 hover-lift">
            <h3 class="accordion-header" id="headingOne">
              <button class="accordion-button bg-white rounded-3 py-4 px-4 fw-bold text-dark" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                <i class="bi bi-file-earmark-text text-primary me-3"></i>
                How does HireStream ensure contract compliance?
              </button>
            </h3>
            <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#faqAccordion">
              <div class="accordion-body pt-0 px-4 pb-4">
                <p>Building on our eTawtheeq foundation, HireStream digitally authenticates all employment contracts with:</p>
                <ul class="mb-0">
                  <li>Automated Ministry of Labor regulation checks</li>
                  <li>Biometric e-signatures for all parties</li>
                  <li>Blockchain-backed contract storage</li>
                  <li>Real-time compliance alerts</li>
                </ul>
              </div>
            </div>
          </div>
          
          <!-- Item 2 -->
          <div class="accordion-item border-0 rounded-3 shadow-sm mb-3 hover-lift">
            <h3 class="accordion-header" id="headingTwo">
              <button class="accordion-button collapsed bg-white rounded-3 py-4 px-4 fw-bold text-dark" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                <i class="bi bi-robot text-primary me-3"></i>
                What makes your AI matching different?
              </button>
            </h3>
            <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo" data-bs-parent="#faqAccordion">
              <div class="accordion-body pt-0 px-4 pb-4">
                <p>Our AI analyzes 50+ qualification dimensions while avoiding bias:</p>
                <div class="row">
                  <div class="col-md-6">
                    <ul>
                      <li>Skills verification testing</li>
                      <li>Cultural fit prediction</li>
                      <li>Salary expectation matching</li>
                    </ul>
                  </div>
                  <div class="col-md-6">
                    <ul>
                      <li>Video interview analysis</li>
                      <li>Reference validation scoring</li>
                      <li>Retention likelihood</li>
                    </ul>
                  </div>
                </div>
              </div>
            </div>
          </div>
          
          <!-- Item 3 -->
          <div class="accordion-item border-0 rounded-3 shadow-sm mb-3 hover-lift">
            <h3 class="accordion-header" id="headingThree">
              <button class="accordion-button collapsed bg-white rounded-3 py-4 px-4 fw-bold text-dark" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                <i class="bi bi-currency-exchange text-primary me-3"></i>
                What's included in the free trial?
              </button>
            </h3>
            <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree" data-bs-parent="#faqAccordion">
              <div class="accordion-body pt-0 px-4 pb-4">
                <p>Our 14-day trial gives full access to:</p>
                <div class="d-flex flex-wrap gap-3 mb-3">
                  <span class="badge bg-primary bg-opacity-10 text-primary py-2 px-3">3 Job Posts</span>
                  <span class="badge bg-primary bg-opacity-10 text-primary py-2 px-3">50 Candidate Matches</span>
                  <span class="badge bg-primary bg-opacity-10 text-primary py-2 px-3">Basic Analytics</span>
                  <span class="badge bg-primary bg-opacity-10 text-primary py-2 px-3">Email Support</span>
                </div>
                <p class="mb-0">No credit card required. Upgrade anytime during the trial to unlock more features.</p>
              </div>
            </div>
          </div>
          
          <!-- Item 4 -->
          <div class="accordion-item border-0 rounded-3 shadow-sm mb-3 hover-lift">
            <h3 class="accordion-header" id="headingFour">
              <button class="accordion-button collapsed bg-white rounded-3 py-4 px-4 fw-bold text-dark" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                <i class="bi bi-shield-lock text-primary me-3"></i>
                How secure is candidate data?
              </button>
            </h3>
            <div id="collapseFour" class="accordion-collapse collapse" aria-labelledby="headingFour" data-bs-parent="#faqAccordion">
              <div class="accordion-body pt-0 px-4 pb-4">
                <div class="d-flex flex-column flex-md-row gap-4">
                  <div class="flex-shrink-0">
                    <div class="bg-primary bg-opacity-10 p-4 rounded-3">
                      <i class="bi bi-shield-check text-primary fs-1"></i>
                    </div>
                  </div>
                  <div>
                    <p>We maintain enterprise-grade security:</p>
                    <ul>
                      <li>SOC 2 Type II certified</li>
                      <li>GDPR and CCPA compliant</li>
                      <li>End-to-end encryption</li>
                      <li>Role-based access controls</li>
                      <li>Regular penetration testing</li>
                    </ul>
                  </div>
                </div>
              </div>
            </div>
          </div>
          
          <!-- Item 5 -->
          <div class="accordion-item border-0 rounded-3 shadow-sm hover-lift">
            <h3 class="accordion-header" id="headingFive">
              <button class="accordion-button collapsed bg-white rounded-3 py-4 px-4 fw-bold text-dark" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                <i class="bi bi-gear text-primary me-3"></i>
                Can we integrate with our existing HR tools?
              </button>
            </h3>
            <div id="collapseFive" class="accordion-collapse collapse" aria-labelledby="headingFive" data-bs-parent="#faqAccordion">
              <div class="accordion-body pt-0 px-4 pb-4">
                <p>HireStream connects seamlessly with:</p>
                <div class="row g-3">
                  <div class="col-6 col-md-4">
                    <div class="p-3 border rounded-2 text-center">
                      <i class="bi bi-briefcase fs-3 text-primary mb-2"></i>
                      <p class="mb-0 fw-bold small">ATS Systems</p>
                    </div>
                  </div>
                  <div class="col-6 col-md-4">
                    <div class="p-3 border rounded-2 text-center">
                      <i class="bi bi-cash-coin fs-3 text-primary mb-2"></i>
                      <p class="mb-0 fw-bold small">Payroll Providers</p>
                    </div>
                  </div>
                  <div class="col-6 col-md-4">
                    <div class="p-3 border rounded-2 text-center">
                      <i class="bi bi-person-vcard fs-3 text-primary mb-2"></i>
                      <p class="mb-0 fw-bold small">HRIS Platforms</p>
                    </div>
                  </div>
                  <div class="col-6 col-md-4">
                    <div class="p-3 border rounded-2 text-center">
                      <i class="bi bi-microsoft-teams fs-3 text-primary mb-2"></i>
                      <p class="mb-0 fw-bold small">Microsoft 365</p>
                    </div>
                  </div>
                  <div class="col-6 col-md-4">
                    <div class="p-3 border rounded-2 text-center">
                      <i class="bi bi-google fs-3 text-primary mb-2"></i>
                      <p class="mb-0 fw-bold small">Google Workspace</p>
                    </div>
                  </div>
                  <div class="col-6 col-md-4">
                    <div class="p-3 border rounded-2 text-center">
                      <i class="bi bi-plug fs-3 text-primary mb-2"></i>
                      <p class="mb-0 fw-bold small">API Access</p>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        
        <!-- CTA -->
        <div class="text-center mt-6">
          <div class="card border-0 shadow-sm bg-primary bg-opacity-10">
            <div class="card-body p-4">
              <h4 class="fw-bold mb-3">Still have questions?</h4>
              <p class="mb-4">Our recruitment experts are ready to help</p>
              <a href="#contact" class="btn btn-primary px-5 py-3">
                Contact Support <i class="bi bi-arrow-right ms-2"></i>
              </a>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>



        <!-- CTA Section -->
        <section class="py-5 bg-primary text-white">
            <div class="container text-center py-5">
                <h2 class="display-5 fw-bold mb-4">Ready to Transform Your Hiring?</h2>
                <p class="lead mb-5 mx-auto" style="max-width: 600px; opacity: 0.9;">
                    Join thousands of companies who have streamlined their recruitment process with HireStream.
                </p>
                <a href="#" class="btn btn-light btn-lg px-4">Start Free Trial</a>
            </div>
        </section>
    </main>

    <!-- Bootstrap-only Contact Section -->
<section id="contact" class="py-5 bg-light">
  <div class="container py-5">
    <!-- Header -->
    <div class="text-center mb-5">
      <span class="badge bg-primary bg-opacity-10 text-primary mb-3 px-4 py-2 rounded-pill">
        <i class="bi bi-chat-square-text me-2"></i>Get In Touch
      </span>
      <h2 class="display-5 fw-bold mb-3">Contact Our <span class="text-primary">Team</span></h2>
      <p class="lead text-muted mx-auto" style="max-width: 600px;">
        Have questions? Our support team is ready to help you streamline your hiring process.
      </p>
    </div>

    <div class="row g-4 justify-content-center">
  <!-- Contact Cards -->
  <div class="col-lg-4">
    <div class="d-flex flex-column gap-3 h-100">
      <!-- Email Card -->
      <div class="card border-0 shadow-sm h-100 hover-shadow">
        <div class="card-body p-4">
          <div class="d-flex align-items-start">
            <div class="bg-primary bg-opacity-10 p-3 rounded-3 me-4">
              <i class="bi bi-envelope text-primary fs-3"></i>
            </div>
            <div>
              <h4 class="fw-bold mb-2">Email Us</h4>
              <a href="mailto:hello@hirestream.com" class="text-decoration-none stretched-link">hello@hirestream.com</a>
              <p class="text-muted small mt-2 mb-0">Typically responds within 2 hours</p>
            </div>
          </div>
        </div>
      </div>

      <!-- Phone Card -->
      <div class="card border-0 shadow-sm h-100 hover-shadow">
        <div class="card-body p-4">
          <div class="d-flex align-items-start">
            <div class="bg-success bg-opacity-10 p-3 rounded-3 me-4">
              <i class="bi bi-telephone text-success fs-3"></i>
            </div>
            <div>
              <h4 class="fw-bold mb-2">Call Us</h4>
              <a href="tel:+18005551234" class="text-decoration-none stretched-link">+1 (800) 555-1234</a>
              <p class="text-muted small mt-2 mb-0">Mon-Fri, 9am-5pm EST</p>
            </div>
          </div>
        </div>
      </div>

      <!-- WhatsApp Card -->
      <div class="card border-0 shadow-sm h-100 hover-shadow">
        <div class="card-body p-4">
          <div class="d-flex align-items-start">
            <div class="bg-success bg-opacity-10 p-3 rounded-3 me-4">
              <i class="bi bi-whatsapp text-success fs-3"></i>
            </div>
            <div>
              <h4 class="fw-bold mb-2">WhatsApp</h4>
              <a href="https://wa.me/18005551234" class="text-decoration-none stretched-link">+1 (800) 555-1234</a>
              <p class="text-muted small mt-2 mb-0">24/7 instant messaging</p>
            </div>
          </div>
        </div>
      </div>

      <!-- Social Links -->
      <div class="card border-0 shadow-sm">
  <div class="card-body p-4">
    <h4 class="fw-bold mb-3 text-primary">Join Our Community</h4>
    <p class="text-muted small mb-3">Connect with us for hiring tips and updates</p>
    <div class="d-flex flex-wrap gap-2">
      <!-- LinkedIn - Professional Networking -->
      <a href="#" class="btn btn-icon rounded-circle p-3 bg-primary bg-opacity-10 text-primary hover-lift">
        <i class="bi bi-linkedin fs-5"></i>
      </a>
      
      <!-- Twitter - Quick Updates -->
      <a href="#" class="btn btn-icon rounded-circle p-3 bg-info bg-opacity-10 text-info hover-lift">
        <i class="bi bi-twitter fs-5"></i>
      </a>
      
      <!-- Facebook - Community Building -->
      <a href="#" class="btn btn-icon rounded-circle p-3 bg-primary bg-opacity-10 text-primary hover-lift">
        <i class="bi bi-facebook fs-5"></i>
      </a>
      
      <!-- Instagram - Company Culture -->
      <a href="#" class="btn btn-icon rounded-circle p-3 bg-gradient-instagram text-white hover-lift">
        <i class="bi bi-instagram fs-5"></i>
      </a>
      
      <!-- TikTok - Recruitment Tips -->
      <a href="#" class="btn btn-icon rounded-circle p-3 bg-dark bg-opacity-10 text-dark hover-lift">
        <i class="bi bi-tiktok fs-5"></i>
      </a>
      
      <!-- YouTube - Tutorials -->
      <a href="#" class="btn btn-icon rounded-circle p-3 bg-danger bg-opacity-10 text-danger hover-lift">
        <i class="bi bi-youtube fs-5"></i>
      </a>
    </div>
  </div>
</div>
    </div>
  </div>

      <!-- Contact Form -->
      <div class="col-lg-6">
        <div class="card border-0 shadow-sm h-100">
          <div class="card-body p-4 p-md-5">
            <h3 class="fw-bold mb-4">Send a Message</h3>
            <form>
              <div class="row g-3">
                <div class="col-md-6">
                  <label class="form-label">First Name</label>
                  <input type="text" class="form-control form-control-lg" placeholder="John">
                </div>
                <div class="col-md-6">
                  <label class="form-label">Last Name</label>
                  <input type="text" class="form-control form-control-lg" placeholder="Doe">
                </div>
                <div class="col-12">
                  <label class="form-label">Email</label>
                  <input type="email" class="form-control form-control-lg" placeholder="john@company.com">
                </div>
                <div class="col-12">
                  <label class="form-label">Subject</label>
                  <select class="form-select form-select-lg">
                    <option selected>Select a topic</option>
                    <option>Sales Inquiry</option>
                    <option>Technical Support</option>
                    <option>Partnership</option>
                  </select>
                </div>
                <div class="col-12">
                  <label class="form-label">Message</label>
                  <textarea class="form-control form-control-lg" rows="4" placeholder="Your message..."></textarea>
                </div>
                <div class="col-12">
                  <div class="form-check">
                    <input class="form-check-input" type="checkbox" id="consent">
                    <label class="form-check-label small text-muted" for="consent">
                      I agree to the privacy policy and terms of service
                    </label>
                  </div>
                </div>
                <div class="col-12 mt-4">
                  <button type="submit" class="btn btn-primary btn-lg w-100 py-3">
                    Send Message <i class="bi bi-send ms-2"></i>
                  </button>
                </div>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

    <footer class="bg-dark text-white py-5">
        <div class="container py-4">
            <div class="row g-4">
                <!-- Column 1 -->
                <div class="col-md-6 col-lg-3">
                    <h3 class="h5 mb-3">HireStream</h3>
                    <p class="text-light">
                        Making hiring simpler, faster, and more effective for businesses of all sizes.
                    </p>
                </div>

                <!-- Column 2 -->
                <div class="col-md-6 col-lg-3">
                    <h3 class="h5 mb-3">Product</h3>
                    <ul class="list-unstyled">
                        <li class="mb-2"><a href="#" class="text-light text-decoration-none hover-text-warning">Features</a></li>
                        <li class="mb-2"><a href="#" class="text-light text-decoration-none hover-text-warning">Pricing</a></li>
                        <li class="mb-2"><a href="#" class="text-light text-decoration-none hover-text-warning">Integrations</a></li>
                        <li><a href="#" class="text-light text-decoration-none hover-text-warning">Updates</a></li>
                    </ul>
                </div>

                <!-- Column 3 -->
                <div class="col-md-6 col-lg-3">
                    <h3 class="h5 mb-3">Resources</h3>
                    <ul class="list-unstyled">
                        <li class="mb-2"><a href="#" class="text-light text-decoration-none hover-text-warning">Blog</a></li>
                        <li class="mb-2"><a href="#" class="text-light text-decoration-none hover-text-warning">Help Center</a></li>
                        <li class="mb-2"><a href="#" class="text-light text-decoration-none hover-text-warning">Tutorials</a></li>
                        <li><a href="#" class="text-light text-decoration-none hover-text-warning">Community</a></li>
                    </ul>
                </div>

                <!-- Column 4 -->
                <div class="col-md-6 col-lg-3">
                    <h3 class="h5 mb-3">Company</h3>
                    <ul class="list-unstyled">
                        <li class="mb-2"><a href="#" class="text-light text-decoration-none hover-text-warning">About Us</a></li>
                        <li class="mb-2"><a href="#" class="text-light text-decoration-none hover-text-warning">Careers</a></li>
                        <li class="mb-2"><a href="#" class="text-light text-decoration-none hover-text-warning">Contact</a></li>
                        <li><a href="#" class="text-light text-decoration-none hover-text-warning">Legal</a></li>
                    </ul>
                </div>
            </div>

            <div class="border-top border-light mt-5 pt-4 text-center">
                <p class="text-white mb-0">&copy; 2025 HireStream. All rights reserved.</p>
            </div>
        </div>
    </footer>

    @if (Route::has('login'))
        <div class="d-none d-lg-block" style="height: 56px;"></div>
    @endif

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <script>
  // Pause video when modal closes
  document.getElementById('demoVideoModal').addEventListener('hidden.bs.modal', function () {
    const iframe = document.getElementById('demoVideoFrame');
    iframe.src = iframe.src; // Reset video
  });
</script>
</body>
</html>