<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Worker CV</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: Arial, sans-serif;
            background: #f8f9fa;
        }
        .cv-container {
            max-width: 900px;
            margin: auto;
            background: #fff;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .header {
            background: #800080;
            color: white;
            text-align: center;
            padding: 10px;
            font-size: 18px;
            font-weight: bold;
        }
        .photo {
            text-align: center;
        }
        .photo img {
            max-width: 150px;
            border-radius: 10px;
            border: 2px solid #800080;
            padding: 5px;
        }
        .table thead {
            background: #800080;
            color: white;
        }
    </style>
</head>
<body>
<div class="cv-container">
    <div class="header">Curriculum Vitae | السيرة الذاتية</div>
    <div class="row mt-3">
        <div class="col-md-9">
            <table class="table table-bordered text-center">
                <thead>
                    <tr>
                        <th>Field</th>
                        <th>Details</th>
                        <th>المعلومات</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>Given Names</td>
                        <td>{{ $worker->given_names ?? 'N/A' }}</td>
                        <td>الاسم الكامل</td>
                    </tr>
                    <tr>
                        <td>Surname</td>
                        <td>{{ $worker->surname ?? 'N/A' }}</td>                        <td>الجنسية</td>
                    </tr>
                    <tr>
                        <td>Religion</td>
                        <td>{{ $worker->religion }}</td>
                        <td>الديانة</td>
                    </tr>
                    <tr>
                        <td>Date of Birth</td>
                        <td>{{ $worker->dob }}</td>
                        <td>تاريخ الميلاد</td>
                    </tr>
                    <tr>
                        <td>Marital Status</td>
                        <td>{{ $worker->marital_status }}</td>
                        <td>الحالة الاجتماعية</td>
                    </tr>
                    <tr>
                        <td>Height</td>
                        <td>{{ $worker->height }} cm</td>
                        <td>الطول</td>
                    </tr>
                    <tr>
                        <td>Weight</td>
                        <td>{{ $worker->weight }} kg</td>
                        <td>الوزن</td>
                    </tr>
                    <tr>
                        <td>Skills</td>
                        <td>
                            @php
                                $skills = json_decode($worker->skills, true); // Decode JSON safely
                            @endphp
                            {{ is_array($skills) ? implode(', ', $skills) : 'N/A' }}
                        </td>
                        <td>المهارات</td>
                    </tr>

                </tbody>
            </table>
        </div>
        <div class="col-md-3 photo">
            <img src="{{ asset('storage/' . $worker->photo) }}" alt="Worker Photo">
        </div>
    </div>
    
    <div class="mt-4">
        <div class="header">Passport Information | معلومات حول السفر</div>
        <table class="table table-bordered text-center">
            <tbody>
                <tr>
                    <td>Passport Number</td>
                    <td>{{ $worker->passport_number }}</td>
                    <td>رقم الجواز</td>
                </tr>
                <tr>
                    <td>Issue Place</td>
                    <td>{{ $worker->passport_issue_place }}</td>
                    <td>مكان الإصدار</td>
                </tr>
                <tr>
                    <td>Issue Date</td>
                    <td>{{ $worker->passport_issue_date }}</td>
                    <td>تاريخ الإصدار</td>
                </tr>
                <tr>
                    <td>Expiry Date</td>
                    <td>{{ $worker->passport_expiry_date }}</td>
                    <td>تاريخ الانتهاء</td>
                </tr>
            </tbody>
        </table>
    </div>
    
    <div class="mt-4">
        <div class="header">Address & Contact | العنوان والاتصال</div>
        <table class="table table-bordered text-center">
            <tbody>
                <tr>
                    <td>Country</td>
                    <td>{{ $worker->country }}</td>
                    <td>البلد</td>
                </tr>
                <tr>
                    <td>City</td>
                    <td>{{ $worker->city }}</td>
                    <td>المدينة</td>
                </tr>
                <tr>
                    <td>Full Address</td>
                    <td>{{ $worker->address }}</td>
                    <td>العنوان بالكامل</td>
                </tr>
                <tr>
                    <td>Relative Name</td>
                    <td>{{ $worker->relative_name }}</td>
                    <td>اسم القريب</td>
                </tr>
                <tr>
                    <td>Kinship</td>
                    <td>{{ $worker->relative_kinship }}</td>
                    <td>صلة القرابة</td>
                </tr>
                <tr>
                    <td>Phone</td>
                    <td>{{ $worker->relative_phone }}</td>
                    <td>الهاتف</td>
                </tr>
                <tr>
                    <td>Relative Address</td>
                    <td>{{ $worker->relative_address }}</td>
                    <td>عنوان القريب</td>
                </tr>
            </tbody>
        </table>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
