<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                Domestic Service Workers
            </h2>

            <a href="{{ route('workers.create') }}" class="btn btn-success">
                <i class="fas fa-plus"></i> Add New Candidates
            </a>
        </div>
    </x-slot>

    <div class="py-6">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">

            {{-- Search + Filters --}}
            <div class="card shadow-sm border-light rounded mb-4">
                <div class="card-header bg-info text-white text-center">
                    <h5>Search Workers</h5>
                </div>

                <form method="GET" action="{{ route('workers.index') }}" class="p-3">
                    <div class="row g-2 align-items-end">
                        {{-- Sort --}}
                        <div class="col-md">
                            <label class="form-label">Sort</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-calendar-range"></i></span>
                                <select name="sort" class="form-select">
                                    <option value="newest" {{ request('sort') == 'newest' ? 'selected' : '' }}>Date (Newest)</option>
                                    <option value="oldest" {{ request('sort') == 'oldest' ? 'selected' : '' }}>Date (Oldest)</option>
                                </select>
                            </div>
                        </div>

                        {{-- occupation --}}
                        <div class="col-md">
                            <label class="form-label">Passport No</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-passport"></i></span>
                                <input type="text" name="passport_number" class="form-control" placeholder="Enter passport number" value="{{ request('passport_number') }}">
                            </div>
                        </div>

                        {{-- Skill --}}
                        <div class="col-md">
                            <label class="form-label">Skill</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-tools"></i></span>
                                <select name="skill" class="form-select">
                                    <option value="">All</option>
                                    @foreach($skills as $skill)
                                        <option value="{{ $skill }}" {{ request('skill') == $skill ? 'selected' : '' }}>{{ $skill }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        {{-- Education --}}
                        <div class="col-md">
                            <label class="form-label">Education</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-mortarboard-fill"></i></span>
                                <select name="education_level" class="form-select">
                                    <option value="">All</option>
                                    <option value="Primary" {{ request('education_level') == 'Primary' ? 'selected' : '' }}>Primary</option>
                                    <option value="Secondary" {{ request('education_level') == 'Secondary' ? 'selected' : '' }}>Secondary</option>
                                    <option value="Tertiary" {{ request('education_level') == 'Tertiary' ? 'selected' : '' }}>Tertiary</option>
                                </select>
                            </div>
                        </div>

                        {{-- Gender --}}
                        <div class="col-md">
                            <label class="form-label">Gender</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-gender-ambiguous"></i></span>
                                <select name="gender" class="form-select">
                                    <option value="">All</option>
                                    <option value="Male" {{ request('gender') == 'Male' ? 'selected' : '' }}>Male</option>
                                    <option value="Female" {{ request('gender') == 'Female' ? 'selected' : '' }}>Female</option>
                                </select>
                            </div>
                        </div>

                        {{-- Religion --}}
                        <div class="col-md">
                            <label class="form-label">Religion</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-book"></i></span>
                                <select name="religion" class="form-select">
                                    <option value="">All</option>
                                    <option value="Christian" {{ request('religion') == 'Christian' ? 'selected' : '' }}>Christian</option>
                                    <option value="Muslim" {{ request('religion') == 'Muslim' ? 'selected' : '' }}>Muslim</option>
                                </select>
                            </div>
                        </div>

                        {{-- Keywords --}}
                        <div class="col-md">
                            <label class="form-label">Keywords</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-search"></i></span>
                                <input type="text" name="keywords" class="form-control" placeholder="Search..." value="{{ request('keywords') }}">
                            </div>
                        </div>

                        {{-- Submit & Clear --}}
                        <div class="col-auto">
                            <button type="submit" class="btn btn-info mt-2">
                                <i class="bi bi-funnel-fill"></i> Filter
                            </button>
                            <a href="{{ route('workers.index') }}" class="btn btn-outline-secondary mt-2 ms-2">
                                <i class="bi bi-x-circle"></i> Clear
                            </a>
                        </div>
                    </div>
                </form>
            </div>

            {{-- Status Tabs --}}
            @php
                $currentStatus = request('status', 'All');
                $queryParams = request()->except('status', 'page');
            @endphp
            <ul class="nav nav-tabs mb-3" id="statusTabs">
                @foreach (['All', 'Available', 'Processing', 'Employee', 'Back_Out'] as $status)
                    <li class="nav-item">
                        <a class="nav-link {{ $currentStatus === $status ? 'active' : '' }}"
                           href="{{ route('workers.index', array_merge($queryParams, ['status' => $status])) }}">
                            {{ $status }}
                        </a>
                    </li>
                @endforeach
            </ul>

            {{-- Worker Cards --}}
            <div class="card shadow-sm border-light rounded">
                <div class="card-header bg-light">
                    <h5 class="mb-0">Candidates List</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        @foreach ($workers as $worker)
                            <div class="col-12 mb-4 worker-card" data-status="{{ $worker->status }}">
                                <div class="card shadow rounded shadow-lg">
                                    <div class="card-body">
                                        <div class="row align-items-center">
                                            {{-- Status + Photo --}}
                                            <div class="col-auto text-center">
                                                <div class="mb-2">
                                                   <span class="badge bg-{{ 
                                                        $worker->status === 'available' ? 'primary' : (
                                                            $worker->status === 'processing' ? 'info' : (
                                                                $worker->status === 'employee' ? 'success' : 'danger'
                                                            )
                                                        )
                                                    }}">

                                                    {{
                                                        $worker->status === 'available' ? 'Available' :
                                                        ($worker->status === 'processing' ? 'Processing' :
                                                        ($worker->status === 'employee' ? 'Employee' : 'Back Out'))
                                                    }}
                                                </span>
                                                </div>
                                                <img src="{{ $worker->photo_url ? asset($worker->photo_url) : asset('default-avatar.png') }}"
                                                     alt="Photo of {{ $worker->surname }}"
                                                     class="rounded-circle"
                                                     style="width: 60px; height: 60px; object-fit: cover;">
                                            </div>

                                            {{-- Info --}}
                                            <div class="col">
                                                <div class="row g-3">
                                                    <div class="col-6 col-md-2"><div class="text-muted small">Full Name</div><strong>{{ $worker->surname }} {{ $worker->given_names }}</strong></div>
                                                    <div class="col-6 col-md-2"><div class="text-muted small">Religion</div>{{ $worker->religion ?? 'N/A' }}</div>
                                                    <div class="col-6 col-md-2"><div class="text-muted small">Passport No </div>{{ $worker->passport_number ?? 'N/A' }}</div>
                                                    <div class="col-6 col-md-2"><div class="text-muted small">Occupation</div>{{ $worker->occupation ?? 'N/A' }}</div>
                                                    <div class="col-6 col-md-2"><div class="text-muted small">Mobile</div>{{ $worker->mobile_number ?? 'N/A' }}</div>
                                                    <div class="col-6 col-md-2"><div class="text-muted small">Location</div>{{ $worker->city ?? 'N/A' }}, {{ $worker->country ?? 'N/A' }}</div>
                                                </div>
                                            </div>

                                            {{-- Actions --}}
                                            <div class="col-auto text-end">
                                                <div class="d-flex flex-column gap-1">
                                                    <a href="{{ route('workers.show', $worker->id) }}" class="btn btn-success btn-sm text-white">Details</a>
                                                    @php
                                                        // Normalize the worker's status to lowercase and trim any whitespace
                                                        $normalizedStatus = strtolower(trim($worker->status));
                                                    @endphp

                                                    @if ($normalizedStatus === 'available')
                                                        <a href="{{ route('workers.edit', $worker->id) }}" class="btn btn-info btn-sm text-white">
                                                            Edit
                                                        </a>
                                                    @elseif ($normalizedStatus === 'back_out')
                                                        <form action="{{ route('workers.revoke-backout', $worker->id) }}" method="POST" class="d-inline">
                                                            @csrf
                                                            @method('PUT')
                                                            <button type="submit" class="btn btn-warning btn-sm text-white">
                                                                Revoke
                                                            </button>
                                                        </form>
                                                    @endif

                                                    @php
                                                    $canDelete = in_array(strtolower($worker->status), ['available', 'back_out']);
                                                @endphp

                                                @if ($canDelete)
                                                    <button type="button" 
                                                            class="btn btn-link text-danger text-decoration-underline p-0 m-0 btn-sm delete-worker"
                                                            data-worker-id="{{ $worker->id }}"
                                                            data-worker-name="{{ $worker->surname }} {{ $worker->given_names }}">
                                                        Delete
                                                    </button>
                                                @endif

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach

                        {{-- No Results --}}
                        <div id="noResultsMessage" class="text-center text-muted w-100 my-4" style="display: none;">
                            <p>No results match your search.</p>
                        </div>
                    </div>

                    {{-- Pagination --}}
                    <div class="d-flex justify-content-center mt-3">
                        {{ $workers->appends(request()->query())->links('pagination::bootstrap-4') }}
                    </div>
                </div>
            </div>

        </div>
    </div>

    {{-- SweetAlert Script --}}
    @push('scripts')
        {{-- Success Message Handler --}}
        @if(session('success'))
            <script>
                document.addEventListener("DOMContentLoaded", function() {
                    const Toast = Swal.mixin({
                        toast: true,
                        position: 'center',
                        showConfirmButton: false,
                        timer: 3000,
                        timerProgressBar: true,
                        width: 'auto',
                        padding: '0.5em',
                        customClass: {
                            popup: 'colored-toast'
                        }
                    });

                    @if(is_array(session('success')))
                        Toast.fire({
                            icon: 'success',
                            title: "{{ session('success')['title'] ?? 'Success' }}",
                            text: "{{ session('success')['message'] ?? '' }}"
                        });
                    @else
                        Toast.fire({
                            icon: 'success',
                            title: "{{ session('success') }}"
                        });
                    @endif
                });
            </script>
        @endif

        {{-- Error Message Handler --}}
        @if(session('error'))
            <script>
                document.addEventListener("DOMContentLoaded", function() {
                    const ErrorAlert = Swal.mixin({
                        toast: true,
                        position: 'center',
                        showConfirmButton: true,
                        confirmButtonColor: '#3085d6',
                        confirmButtonText: 'OK',
                        icon: 'error',
                        width: 'auto',
                        padding: '0.5em',
                        customClass: {
                            popup: 'colored-toast'
                        }
                    });

                    ErrorAlert.fire({
                        title: 'Error',
                        text: "{{ session('error') }}"
                    });
                });
            </script>
        @endif

        {{-- Delete Confirmation Handler --}}
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                // Handle delete buttons
                document.querySelectorAll('.delete-worker').forEach(button => {
                    button.addEventListener('click', function() {
                        const workerId = this.getAttribute('data-worker-id');
                        const workerName = this.getAttribute('data-worker-name');
                        
                        Swal.fire({
                            title: 'Are you sure?',
                            text: `Do you want to delete ${workerName}?`,
                            icon: 'warning',
                            showCancelButton: true,
                            confirmButtonColor: '#d33',
                            cancelButtonColor: '#3085d6',
                            confirmButtonText: 'Yes, delete it!',
                            width: 'auto',
                            padding: '0.5em',
                            customClass: {
                                popup: 'colored-toast'
                            }
                        }).then((result) => {
                            if (result.isConfirmed) {
                                // Create a form and submit it
                                const form = document.createElement('form');
                                form.method = 'POST';
                                form.action = `/workers/${workerId}`;

                                // Add CSRF token
                                const csrfInput = document.createElement('input');
                                csrfInput.type = 'hidden';
                                csrfInput.name = '_token';
                                csrfInput.value = document.querySelector('meta[name="csrf-token"]').content;
                                form.appendChild(csrfInput);

                                // Add method spoofing for DELETE
                                const methodInput = document.createElement('input');
                                methodInput.type = 'hidden';
                                methodInput.name = '_method';
                                methodInput.value = 'DELETE';
                                form.appendChild(methodInput);

                                // Add form to document and submit
                                document.body.appendChild(form);
                                form.submit();
                            }
                        });
                    });
                });

                // Add custom styles for smaller popups
                const style = document.createElement('style');
                style.textContent = `
                    .colored-toast {
                        font-size: 0.9em !important;
                        min-width: 200px !important;
                        max-width: 400px !important;
                    }
                    .colored-toast .swal2-title {
                        font-size: 1.1em !important;
                        margin: 0.5em !important;
                    }
                    .colored-toast .swal2-html-container {
                        font-size: 0.9em !important;
                        margin: 0.5em !important;
                    }
                    .colored-toast .swal2-confirm {
                        padding: 0.3em 1em !important;
                        font-size: 0.9em !important;
                    }
                `;
                document.head.appendChild(style);
            });
        </script>

        {{-- Tab Filtering Script --}}
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                const tabs = document.querySelectorAll('#statusTabs .nav-link');
                const cards = document.querySelectorAll('.worker-card');
                const noResults = document.getElementById('noResultsMessage');

                tabs.forEach(tab => {
                    tab.addEventListener('click', function () {
                        const status = this.getAttribute('data-status');
                        let count = 0;
                        cards.forEach(card => {
                            const cardStatus = card.getAttribute('data-status');
                            if (status === 'All' || cardStatus === status) {
                                card.style.display = 'block';
                                count++;
                            } else {
                                card.style.display = 'none';
                            }
                        });
                        noResults.style.display = count === 0 ? 'block' : 'none';
                    });
                });
            });
        </script>
    @endpush
</x-app-layout>
