@extends('layouts.workers')

@section('content')
<div class="container py-4">
    @if(strtolower($worker->status) === 'back_out' && $worker->backout_reason)
        <div class="alert alert-danger mb-4">
            <div class="d-flex align-items-center">
                <i class="fas fa-exclamation-triangle me-2"></i>
                <div>
                    <strong>Back Out Reason:</strong>
                    <p class="mb-0">{{ $worker->backout_reason }}</p>
                </div>
            </div>
        </div>
    @endif

    <!-- Candidate Overview -->
    <div class="card shadow-lg mb-4">
    <!-- Header -->
    <div class="bg-blue-600 px-6 py-4">
                <div class="flex justify-between items-center">
                    <div>
                        <h2 class="text-2xl font-bold text-blue">Candidate Information</h2>
                        <p class="text-blue-100">View candidate information below</p>
                    </div>
                    <a href="{{ route('workers.index') }}" class="text-blue hover:text-blue-200">
                        <i class="fas fa-arrow-left"></i> Back to List
                    </a>
                </div>
            </div>
        <div class="card-header bg-white text-primary d-flex justify-content-between align-items-center">
            <h5 class="mb-0  fw-semibold "><i class="fas fa-id-card me-2"></i>Personal Information</h5>
        </div>

        <div class="card-body">
            <div class="row g-4">
                <!-- Personal Info Left -->
                <div class="col-md-6">
                    <div class="p-3 bg-light rounded h-100">

                        <div class="d-flex mb-2">
                            <strong class="me-2" style="min-width: 140px;">Name:</strong>
                            <span class="text-uppercase fw-bold ">{{ $worker->surname }} {{ $worker->given_names }}</span>
                        </div> 
                        <div class="d-flex mb-2">
                            <strong class="me-2" style="min-width: 140px;">Gender:</strong>
                            <span>{{ $worker->gender ?? 'N/A' }}</span>
                        </div>

                        <div class="d-flex mb-2">
                            <strong class="me-2" style="min-width: 140px;">Job:</strong>
                            <span>{{ $worker->occupation ?? 'N/A' }}</span>
                        </div>

                        <div class="d-flex mb-2">
                            <strong class="me-2" style="min-width: 140px;">Mobile:</strong>
                            <span>{{ $worker->mobile_number ?? 'N/A' }}</span>
                        </div>

                        <div class="d-flex mb-2">
                            <strong class="me-2" style="min-width: 140px;">Languages:</strong>
                            @if(!empty($worker->languages))
                                @php $languages = json_decode($worker->languages, true) ?? []; @endphp
                                @if(count($languages) > 0)
                                    <div class="d-flex flex-wrap gap-2">
                                        @foreach($languages as $language)
                                            <span class="badge bg-success bg-opacity-10 text-success">{{ $language }}</span>
                                        @endforeach
                                    </div>
                                @else
                                    <p class="mb-0">N/A</p>
                                @endif
                            @else
                                <p class="mb-0">N/A</p>
                            @endif                        </div>

                        <div class="d-flex mb-2">
                            <strong class="me-2" style="min-width: 140px;">Experience:</strong>
                            <span>{{ $worker->work_experience ?? 'N/A' }}</span>
                        </div>

                        <div class="d-flex">
                            <strong class="me-2" style="min-width: 140px;">Photo:</strong>
                            @if($worker->photo_url)
                                <a href="{{ asset($worker->photo_url) }}" target="_blank" class="text-primary">
                                    <i class="fas fa-user-circle text-secondary"></i> View
                                </a>
                            @else
                                <span>N/A</span>
                            @endif
                        </div>
                    </div>
                </div>

                <!-- Personal Info Right -->
                <div class="col-md-6">
                    <div class="p-3 bg-light rounded h-100">
                        <div class="d-flex mb-2">
                            <strong class="me-2" style="min-width: 140px;">Given Names:</strong>
                            <span class="text-uppercase fw-bold ">{{ $worker->given_names ?? 'N/A' }}</span>
                        </div>

                        <div class="d-flex mb-2">
                            <strong class="me-2" style="min-width: 140px;">Marital Status:</strong>
                            <span>{{ $worker->marital_status ?? 'N/A' }}</span>
                        </div>

                        <div class="d-flex mb-2">
                            <strong class="me-2" style="min-width: 140px;">Date of Birth:</strong>
                            <span>{{ $worker->date_of_birth ? \Carbon\Carbon::parse($worker->date_of_birth)->format('d M Y') : 'N/A' }}</span>
                        </div>

                        <div class="d-flex mb-2">
                            <strong class="me-2" style="min-width: 140px;">Religion:</strong>
                            <span>{{ $worker->religion ?? 'N/A' }}</span>
                        </div>

                        <div class="d-flex mb-2">
                            <strong class="me-2" style="min-width: 140px;">ID Number:</strong>
                            <span>{{ $worker->id_number ?? 'N/A' }}</span>
                        </div>

                        <div class="d-flex mb-2">
                            <strong class="me-2" style="min-width: 140px;">Skills:</strong>
                            @if(!empty($worker->skills))
                                @php $skills = json_decode($worker->skills, true) ?? []; @endphp
                                @if(count($skills) > 0)
                                    <div class="d-flex flex-wrap gap-2">
                                        @foreach($skills as $skill)
                                            <span class="badge bg-primary bg-opacity-10 text-primary">{{ $skill }}</span>
                                        @endforeach
                                    </div>
                                @else
                                    <p class="mb-0">N/A</p>
                                @endif
                            @else
                                <p class="mb-0">N/A</p>
                            @endif                        </div>
                    </div>
                </div>
            </div>

            <!-- Passport Info -->
            <h5 class="text-primary fw-semibold mt-5"><i class="fas fa-map-marker-alt me-2"></i>Passport Information</h5>
            <div class="row g-4">
                <div class="col-md-6">
                    <div class="p-3 bg-light rounded h-100">
                        <div class="d-flex mb-2">
                            <strong class="me-2" style="min-width: 140px;">Passport Number:</strong>
                            <span>{{ $worker->passport_number ?? 'N/A' }}</span>
                        </div>

                        <div class="d-flex mb-2">
                            <strong class="me-2" style="min-width: 140px;">Expiry Date:</strong>
                            <span>{{ $worker->passport_expiry_date ?? 'N/A' }}</span>
                        </div>
                        <div class="d-flex mb-2">
                            <strong class="me-2" style="min-width: 140px;">Issue Date:</strong>
                            <span>{{ $worker->passport_issue_date ?? 'N/A' }}</span>
                        </div>
                        <div class="d-flex mb-2">
                            <strong class="me-2" style="min-width: 140px;">Issue Place:</strong>
                            <span>{{ $worker->passport_issue_place ?? 'N/A' }}</span>
                        </div>


                        <div class="d-flex">
                            <strong class="me-2" style="min-width: 140px;"><i class="fas fa-file-pdf me-2"></i>Passport File:</strong>
                            @if($worker->passport_file)
                                <a href="{{ asset($worker->passport_file) }}" target="_blank" class="text-primary">
                                    <i class="fas fa-passport text-secondary"></i> View
                                </a>
                            @else
                                <span>N/A</span>
                            @endif
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                <h5 class="text-primary fw-semibold"><i class="fas fa-id-card me-2"></i>Sub-Agent</h5>
                    <div class="p-3 bg-light rounded h-100">
                          <div class="d-flex mb-2">
                            <strong class="me-2" style="min-width: 140px;">Name:</strong>
                            <span>{{ $worker->subAgent->name ?? 'N/A' }}</span>
                        </div>

                        <div class="d-flex mb-2">
                            <strong class="me-2" style="min-width: 140px;">Phone No:</strong>
                            <span>{{ $worker->subAgent->phone ?? 'N/A' }}</span>
                        </div>
                        <div class="d-flex mb-2">
                            <strong class="me-2" style="min-width: 140px;">Commission:</strong>
                            <span>{{ $worker->subAgent->commission ?? 'N/A' }} <br>
                          
    </span>
                        </div>

                    </div>
                </div>
            </div>

            <!-- Address & Relative -->
            <div class="row mt-5 g-4">
                <div class="col-md-6">
                    <h5 class="text-primary fw-semibold" ><i class="fas fa-home me-2"></i>Address</h5>
                    <div class="p-3 bg-light rounded h-100">
                        <div class="d-flex mb-2">
                            <strong class="me-2" style="min-width: 140px;">Country:</strong>
                            <span>{{ $worker->country ?? 'N/A' }}</span>
                        </div>

                        <div class="d-flex mb-2">
                            <strong class="me-2" style="min-width: 140px;">City:</strong>
                            <span>{{ $worker->city ?? 'N/A' }}</span>
                        </div>

                        <div class="d-flex mb-2">
                            <strong class="me-2" style="min-width: 140px;">Address:</strong>
                            <span>{{ $worker->place_of_birth ?? 'N/A' }}</span>
                        </div>
                    
                    </div>
                </div>

                <div class="col-md-6">
                    <h5 class="text-primary fw-semibold"><i class="fas fa-home me-2"></i>Relative Contact</h5>
                    <div class="p-3 bg-light rounded h-100">
                        <div class="d-flex mb-2">
                            <strong class="me-2" style="min-width: 140px;">Name:</strong>
                            <span>{{ $worker->relative_name ?? 'N/A' }}</span>
                        </div>

                        <div class="d-flex mb-2">
                            <strong class="me-2" style="min-width: 140px;">Kinship:</strong>
                            <span>{{ $worker->relative_kinship ?? 'N/A' }}</span>
                        </div>

                        <div class="d-flex mb-2">
                            <strong class="me-2" style="min-width: 140px;">Phone:</strong>
                            <span>{{ $worker->relative_phone ?? 'N/A' }}</span>
                        </div>

                        <div class="d-flex mb-2">
                            <strong class="me-2" style="min-width: 140px;">Address:</strong>
                            <span>{{ $worker->relative_address ?? 'N/A' }}</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="mt-5 d-flex justify-content-between flex-wrap gap-2">
                <div>
                    @if($worker->status !== 'back_out')
                        <button type="button" class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#backoutModal">
                            <i class="fas fa-ban"></i> Mark as Back Out
                        </button>
                    @endif
                </div>
                <div class="ms-auto">
                    <a href="{{ route('workers.cv', $worker->id) }}" class="btn btn-primary me-2" target="_blank">
                        <i class="fas fa-eye"></i> View CV
                    </a>
                    <a href="{{ route('workers.generateCV', $worker->id) }}" class="btn btn-success">
                        <i class="fas fa-file-pdf"></i> Generate CV
                    </a>
                </div>
            </div>

            <!-- Back Out Modal -->
            <div class="modal fade" id="backoutModal" tabindex="-1" aria-labelledby="backoutModalLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="backoutModalLabel">Mark Worker as Back Out</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <form action="{{ route('workers.markAsback_out', ['worker' => $worker->id]) }}" method="POST">
                            @csrf
                            <div class="modal-body">
                                <div class="mb-3">
                                    <label for="backout_reason" class="form-label">Reason for Back Out</label>
                                    <textarea class="form-control" id="backout_reason" name="backout_reason" rows="3" required></textarea>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                <button type="submit" class="btn btn-danger">Confirm Back Out</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    // Show success message if exists
    @if(session('success'))
        const Toast = Swal.mixin({
            toast: true,
            position: 'center',
            showConfirmButton: false,
            timer: 3000,
            timerProgressBar: true,
            didOpen: (toast) => {
                toast.addEventListener('mouseenter', Swal.stopTimer)
                toast.addEventListener('mouseleave', Swal.resumeTimer)
            }
        });

        Toast.fire({
            icon: 'success',
            title: '{{ session('success') }}'
        });
    @endif
</script>
@endpush

@endsection
