<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\SuperAdminController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\VisitorController;
use App\Http\Controllers\WorkerController;
use App\Http\Controllers\JobListingController;
use App\Http\Controllers\ApplicationController;
use App\Http\Controllers\InvoiceController;
use App\Http\Controllers\EmploymentStatusController;
use App\Http\Controllers\ExternalAgencyController;
use App\Http\Controllers\VoucherController;
use App\Http\Controllers\SubAgentController;
use App\Http\Controllers\MonthlyExpenseController;
use App\Exports\ExpensesExport;
use Maatwebsite\Excel\Facades\Excel;
use App\Http\Controllers\BackupController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\DocumentController;

// Public route
Route::get('/', function () {
    return view('welcome');
});

// Auth routes
require __DIR__.'/auth.php';

// Dashboard redirect by role
Route::middleware(['auth'])->get('/dashboard', function () {
    $user = auth()->user();

    return match ($user->role) {
        \App\Models\User::ROLE_SUPER_ADMIN => redirect()->route('superadmin.dashboard'),
        \App\Models\User::ROLE_ADMIN => redirect()->route('admin.dashboard'),
        default => redirect()->route('user.dashboard'),
    };
})->name('dashboard');


// Routes for ALL authenticated users
Route::middleware(['auth'])->group(function () {
    
    // Profile
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    // User Dashboard
    Route::get('/user-dashboard', [UserController::class, 'dashboard'])->name('user.dashboard');

  // Job Listings
Route::resource('jobs', JobListingController::class)->names('jobs')->except(['edit', 'update', 'destroy']);
Route::get('/jobs/create', [JobListingController::class, 'create'])->name('jobs.create');
Route::resource('jobs', JobListingController::class);

// Applications
Route::get('applications', [ApplicationController::class, 'index'])->name('applications.index');
Route::get('jobs/{job}/apply', [ApplicationController::class, 'create'])->name('applications.create');
Route::post('jobs/{job}/apply', [ApplicationController::class, 'store'])->name('applications.store');

    // Visitors
    Route::resource('visitors', VisitorController::class)->except(['store']);
    Route::post('/visitors', [VisitorController::class, 'store'])->name('visitors.store');
    Route::get('/visitors/export/{format}', [VisitorController::class, 'export'])->name('visitors.export');
    Route::put('visitors/checkout/{id}', [VisitorController::class, 'checkout'])->name('visitors.checkout');

    // Workers
    Route::resource('workers', WorkerController::class);
    Route::get('/workers/{id}/cv', [WorkerController::class, 'showCV'])->name('workers.cv');
    Route::get('workers/{worker}/generate-cv', [WorkerController::class, 'generateCV'])->name('workers.generateCV');
    Route::post('workers/{worker}/markAsback_out', [WorkerController::class, 'markAsback_out'])->name('workers.markAsback_out');
    Route::put('/workers/{worker}/revoke-backout', [WorkerController::class, 'revokeBackout'])->name('workers.revoke-backout');

    // Logs
    Route::prefix('logs')->name('logs.')->group(function () {
        Route::get('/', [App\Http\Controllers\LogController::class, 'view'])->name('view');
        Route::get('/export/{format}', [App\Http\Controllers\LogController::class, 'export'])->name('export');
    });
});
Route::get('log', [LogController::class, 'index']);
Route::get('/logs/view', [App\Http\Controllers\LogController::class, 'view'])->name('logs.view');

// Super Admin Routes
Route::middleware(['auth', 'superadmin'])->prefix('superadmin')->name('superadmin.')->group(function () {
    Route::get('/dashboard', [SuperAdminController::class, 'dashboard'])->name('dashboard');
    Route::get('/user/{id}', [SuperAdminController::class, 'viewUser'])->name('view-user');
    Route::post('/users/{user}/update-role', [SuperAdminController::class, 'updateUserRole'])->name('update-role');
    Route::delete('/users/{id}', [SuperAdminController::class, 'deleteUser'])->name('delete-user');
    Route::get('/export-users', [SuperAdminController::class, 'exportUsers'])->name('export-users');
    Route::post('/import-users', [SuperAdminController::class, 'importUsers'])->name('import-users');
    Route::get('/download-template', [SuperAdminController::class, 'downloadTemplate'])->name('download-template');
});

// Admin Routes
Route::middleware(['auth', 'admin'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/dashboard', [AdminController::class, 'dashboard'])->name('dashboard');
});

//Invoices Routes
Route::get('/invoices', [InvoiceController::class, 'index'])->name('invoices.index');
Route::post('/invoices/store', [InvoiceController::class, 'store'])->name('invoices.store');
Route::delete('/invoices/{invoice}', [InvoiceController::class, 'destroy'])->name('invoices.destroy');

//Employment_status Routes
Route::resource('employment_status', EmploymentStatusController::class);

//External_Agencies Routes
Route::resource('external_agencies', ExternalAgencyController::class);
Route::put('/external_agencies/{id}', [ExternalAgencyController::class, 'update'])->name('external_agencies.update');

// custom routes
Route::post('/employment_status/{id}/advance', [EmploymentStatusController::class, 'advanceStatus']);
Route::post('/employment_status/{id}/cancel', [EmploymentStatusController::class, 'cancel'])->name('employment_status.cancel');

// invoice routes
Route::prefix('invoices')->group(function () {
    Route::get('/', [InvoiceController::class, 'index'])->name('invoices.index');
    Route::get('/create', [InvoiceController::class, 'create'])->name('invoices.create');
    Route::post('/', [InvoiceController::class, 'store'])->name('invoices.store');
    Route::get('/{invoice}', [InvoiceController::class, 'show'])->name('invoices.show');
    Route::get('/{invoice}/edit', [InvoiceController::class, 'edit'])->name('invoices.edit');
    Route::put('/{invoice}', [InvoiceController::class, 'update'])->name('invoices.update');
    Route::delete('/{invoice}', [InvoiceController::class, 'destroy'])->name('invoices.destroy');
    Route::post('/{invoice}/mark-as-paid', [InvoiceController::class, 'markAsPaid'])->name('invoices.markAsPaid');
    Route::post('/{invoice}/record-payment', [InvoiceController::class, 'recordPayment'])->name('invoices.recordPayment');
    Route::get('/{invoice}/export', [InvoiceController::class, 'export'])->name('invoices.export');
    Route::post('/{invoice}/send', [InvoiceController::class, 'sendToClient'])->name('invoices.send');
});

// Voucher Routes
Route::middleware(['auth'])->group(function () {
    Route::get('/vouchers', [VoucherController::class, 'index'])->name('vouchers.index');
    Route::get('/vouchers/create', [VoucherController::class, 'create'])->name('vouchers.create');
    Route::post('/vouchers', [VoucherController::class, 'store'])->name('vouchers.store');
    Route::get('/vouchers/{voucher}', [VoucherController::class, 'show'])->name('vouchers.show');
    Route::post('/vouchers/{voucher}/status', [VoucherController::class, 'updateStatus'])->name('vouchers.update-status');
    Route::delete('/vouchers/{voucher}', [VoucherController::class, 'destroy'])->name('vouchers.destroy');
    Route::get('/vouchers/{voucher}/export', [VoucherController::class, 'export'])->name('vouchers.export');
});

Route::post('/sub-agents', [SubAgentController::class, 'store'])->name('sub-agents.store');

Route::get('/monthly-expenses', [MonthlyExpenseController::class, 'index'])->name('monthly-expenses.index');
Route::post('/monthly-expenses', [MonthlyExpenseController::class, 'store'])->name('monthly-expenses.store');
Route::post('/monthly-expenses/update-credit', [MonthlyExpenseController::class, 'store'])->name('monthly-expenses.update-credit');
Route::get('/monthly-expenses/{expense}/edit', [MonthlyExpenseController::class, 'edit'])->name('monthly-expenses.edit');
Route::put('/monthly-expenses/{expense}', [MonthlyExpenseController::class, 'update'])->name('monthly-expenses.update');
Route::delete('/monthly-expenses/{expense}', [MonthlyExpenseController::class, 'destroy'])->name('monthly-expenses.destroy');

Route::get('/expenses/export', function () {
    return Excel::download(new ExpensesExport, 'monthly_expenses.xlsx');
})->name('monthly-expenses.export');
Route::get('/expenses/export-pdf', [App\Http\Controllers\MonthlyExpenseController::class, 'exportPdf'])
    ->name('monthly-expenses.export-pdf');
Route::get('/monthly-expenses-tab', [InvoiceController::class, 'expensesTab'])->name('monthly-expenses.tab');
// web.php
Route::resource('monthly-expenses', MonthlyExpenseController::class);

Route::resource('vouchers', VoucherController::class);
Route::get('vouchers/{voucher}/export', [VoucherController::class, 'export'])->name('vouchers.export');
Route::post('vouchers/{voucher}/mark-as-paid', [VoucherController::class, 'markAsPaid'])->name('vouchers.markAsPaid');
Route::get('vouchers/{voucher}', [VoucherController::class, 'show'])->name('vouchers.show');
Route::get('/vouchers/create/{worker?}', [VoucherController::class, 'create'])
    ->name('vouchers.create');

Route::get('/reports', [App\Http\Controllers\ReportController::class, 'index'])->name('reports.index');
Route::get('/reports/generate', function() {
    return redirect()->route('reports.index');
});
Route::post('/reports/generate', [App\Http\Controllers\ReportController::class, 'generate'])->name('reports.generate');

Route::get('/settings', [App\Http\Controllers\SettingsController::class, 'index'])->name('settings');

// Backup Routes
Route::middleware(['auth'])->group(function () {
    Route::get('/backup/create', [BackupController::class, 'create'])->name('backup.create');
    Route::post('/backup/create', [BackupController::class, 'store'])->name('backup.store');
    Route::get('/backup/list', [BackupController::class, 'list'])->name('backup.list');
    Route::get('/backup/download/{filename}', [BackupController::class, 'download'])->name('backup.download');
    Route::delete('/backup/delete/{filename}', [BackupController::class, 'delete'])->name('backup.delete');
});

// Settings Routes
Route::middleware(['auth', 'superadmin'])->group(function () {
    Route::get('/settings', [SettingsController::class, 'index'])->name('settings.index');
    Route::post('/settings/update', [SettingsController::class, 'update'])->name('settings.update');
    Route::get('/settings/get', [SettingsController::class, 'getSettings'])->name('settings.get');
});

Route::get('/documents/upload', [DocumentController::class, 'upload'])->name('documents.upload');