<!-- Bootstrap Modal for Creating New External Agency -->
<div class="modal fade" id="addExternalAgencyModal" tabindex="-1" aria-labelledby="addExternalAgencyModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-info text-white">
                <h5 class="modal-title" id="addExternalAgencyModalLabel">Add New External Agency</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="<?php echo e(route('external_agencies.store')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>

                    <!-- Start of Horizontal Form Layout -->
                    <div class="d-flex flex-wrap justify-content-between">

                        <!-- Company Name -->
                        <div class="mb-3 w-48">
                            <label class="form-label">Company Name</label>
                            <input type="text" name="company_name" class="form-control" required>
                        </div>

                        <!-- License Number -->
                        <div class="mb-3 w-48">
                            <label class="form-label">License Number</label>
                            <input type="text" name="license_number" class="form-control" required>
                        </div>

                        <!-- License Date -->
                        <div class="mb-3 w-48">
                            <label class="form-label">License Date</label>
                            <input type="date" name="license_date" class="form-control" required>
                        </div>

                        <!-- City -->
                        <div class="mb-3 w-48">
                            <label class="form-label">City</label>
                            <input type="text" name="city" class="form-control" required>
                        </div>

                        <!-- Country -->
                        <div class="mb-3 w-48">
                            <label class="form-label">Country</label>
                            <input type="text" name="country" class="form-control" required>
                        </div>

                        <!-- Responsible Name -->
                        <div class="mb-3 w-48">
                            <label class="form-label">Responsible Name</label>
                            <input type="text" name="responsible_name" class="form-control" required>
                        </div>

                        <!-- Email -->
                        <div class="mb-3 w-48">
                            <label class="form-label">Email</label>
                            <input type="email" name="email" class="form-control" required>
                        </div>

                        <!-- Phone -->
                        <div class="mb-3 w-48">
                            <label class="form-label">Phone</label>
                            <input type="text" name="phone" class="form-control" required>
                        </div>
                        <!-- Recruitment Fee -->
                        <div class="mb-3">
                            <label for="recruitment_fee" class="form-label">Recruitment Fee</label>
                            <input type="number" step="0.01" class="form-control" 
                                id="recruitment_fee" name="recruitment_fee"
                                value="<?php echo e(old('recruitment_fee', $agency->recruitment_fee ?? '')); ?>" required>
                        </div>

                        <!-- blank -->
                        <div class="mb-3 w-48">
                        </div>

                        <!-- Logo Upload -->
                        <div class="mb-3 w-48">
                            <label class="form-label">Logo</label>
                            <input type="file" name="logo" class="form-control" accept="image/jpeg,image/png,image/jpg" onchange="previewLogo(event)" required>
                            <small class="text-muted">Accepted formats: JPG, JPEG, PNG</small>
                        </div>

                    

                    <!-- Logo Preview -->
                    <div class="mb-3 w-48">
                        <img id="logoPreview" src="#" alt="Logo Preview" class="rounded-circle" width="100" height="100" style="display: none;">
                    </div>
               </div> <!-- End of Horizontal Form Layout -->
               <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-success">Save Agency</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    // JavaScript to preview the logo image
    function previewLogo(event) {
        const logoPreview = document.getElementById('logoPreview');
        const file = event.target.files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                logoPreview.src = e.target.result;
                logoPreview.style.display = 'block'; // Show the image preview
            };
            reader.readAsDataURL(file);
        } else {
            logoPreview.style.display = 'none'; // Hide the image preview if no file is selected
        }
    }
</script>
<?php /**PATH /home/frankie_254/HIRESTREAM-APP/resources/views/external_agencies/create.blade.php ENDPATH**/ ?>