<!-- Add Monthly Expense Modal -->
<div class="modal fade" id="addExpenseModal" tabindex="-1" aria-labelledby="addExpenseModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content border-0 shadow">
            <div class="modal-header bg-primary text-white border-0">
                <h5 class="modal-title" id="addExpenseModalLabel">
                    <i class="fas fa-plus-circle me-2"></i>Add Monthly Expense
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="<?php echo e(route('monthly-expenses.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="type" value="expense">
                <div class="modal-body p-4">
                    <div class="row g-4">
                        <div class="col-md-6">
                            <div class="form-floating">
                                <input type="text" class="form-control" id="name" name="name" placeholder="Name" required>
                                <label for="name">Name</label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-floating">
                                <input type="text" class="form-control" id="task" name="task" placeholder="Task" required>
                                <label for="task">Task</label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-floating">
                                <input type="number" step="0.01" class="form-control" id="amount_paid" name="amount_paid" placeholder="Amount Paid" required>
                                <label for="amount_paid">Amount Paid</label>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-floating">
                                <textarea class="form-control" id="notes" name="notes" placeholder="Notes" style="height: 100px"></textarea>
                                <label for="notes">Notes</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer bg-light border-0">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">
                        <i class="fas fa-times me-2"></i>Close
                    </button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-2"></i>Add Expense
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Update Credit Modal -->
<div class="modal fade" id="updateCreditModal" tabindex="-1" aria-labelledby="updateCreditModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content border-0 shadow">
            <div class="modal-header bg-success text-white border-0">
                <h5 class="modal-title" id="updateCreditModalLabel">
                    <i class="fas fa-credit-card me-2"></i>Update Credit
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="<?php echo e(route('monthly-expenses.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="type" value="credit">
                <div class="modal-body p-4">
                    <div class="row g-4">
                        <div class="col-md-6">
                            <div class="form-floating">
                                <input type="text" class="form-control" id="credit_name" name="name" placeholder="Name" required>
                                <label for="credit_name">Name</label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-floating">
                                <input type="text" class="form-control" id="credit_task" name="task" placeholder="Task" required>
                                <label for="credit_task">Task</label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-floating">
                                <input type="number" step="0.01" class="form-control" id="credit_amount" name="credit" placeholder="Credit Amount" required>
                                <label for="credit_amount">Credit Amount</label>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-floating">
                                <textarea class="form-control" id="credit_notes" name="notes" placeholder="Notes" style="height: 100px"></textarea>
                                <label for="credit_notes">Notes</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer bg-light border-0">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">
                        <i class="fas fa-times me-2"></i>Close
                    </button>
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-save me-2"></i>Update Credit
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Expense Modals -->
<?php $__currentLoopData = $expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<div class="modal fade" id="editExpenseModal<?php echo e($expense->id); ?>" tabindex="-1" aria-labelledby="editExpenseModalLabel<?php echo e($expense->id); ?>" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content border-0 shadow">
            <div class="modal-header bg-warning text-white border-0">
                <h5 class="modal-title" id="editExpenseModalLabel<?php echo e($expense->id); ?>">
                    <i class="fas fa-edit me-2"></i>Edit Expense
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="<?php echo e(route('monthly-expenses.update', $expense->id)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-body p-4">
                    <div class="row g-4">
                        <div class="col-md-6">
                            <div class="form-floating">
                                <input type="text" class="form-control" id="edit_name<?php echo e($expense->id); ?>" name="name" value="<?php echo e($expense->name); ?>" placeholder="Name" required>
                                <label for="edit_name<?php echo e($expense->id); ?>">Name</label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-floating">
                                <input type="text" class="form-control" id="edit_task<?php echo e($expense->id); ?>" name="task" value="<?php echo e($expense->task); ?>" placeholder="Task" required>
                                <label for="edit_task<?php echo e($expense->id); ?>">Task</label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-floating">
                                <input type="number" step="0.01" class="form-control" id="edit_amount_paid<?php echo e($expense->id); ?>" name="amount_paid" value="<?php echo e($expense->amount_paid); ?>" placeholder="Amount Paid" required>
                                <label for="edit_amount_paid<?php echo e($expense->id); ?>">Amount Paid</label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-floating">
                                <input type="number" step="0.01" class="form-control" id="edit_credit<?php echo e($expense->id); ?>" name="credit" value="<?php echo e($expense->credit); ?>" placeholder="Credit Amount">
                                <label for="edit_credit<?php echo e($expense->id); ?>">Credit Amount</label>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-floating">
                                <textarea class="form-control" id="edit_notes<?php echo e($expense->id); ?>" name="notes" placeholder="Notes" style="height: 100px"><?php echo e($expense->notes); ?></textarea>
                                <label for="edit_notes<?php echo e($expense->id); ?>">Notes</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer bg-light border-0">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">
                        <i class="fas fa-times me-2"></i>Close
                    </button>
                    <button type="submit" class="btn btn-warning">
                        <i class="fas fa-save me-2"></i>Update Expense
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<style>
.modal.fade .modal-dialog {
    transform: scale(0.95);
    transition: transform 0.2s ease-out;
}

.modal.show .modal-dialog {
    transform: scale(1);
}

.modal-content {
    border-radius: 0.5rem;
}

.form-floating > .form-control {
    padding: 1rem 0.75rem;
    height: calc(3.5rem + 2px);
    line-height: 1.25;
}

.form-floating > .form-control:focus {
    box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.15);
}

.form-floating > label {
    padding: 1rem 0.75rem;
}

.form-floating > textarea.form-control {
    height: 100px;
}

.modal-header {
    border-top-left-radius: 0.5rem;
    border-top-right-radius: 0.5rem;
}

.modal-footer {
    border-bottom-left-radius: 0.5rem;
    border-bottom-right-radius: 0.5rem;
}

.btn {
    padding: 0.5rem 1.5rem;
    font-weight: 500;
}

/* Custom scrollbar for textarea */
textarea::-webkit-scrollbar {
    width: 8px;
}

textarea::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 4px;
}

textarea::-webkit-scrollbar-thumb {
    background: #888;
    border-radius: 4px;
}

textarea::-webkit-scrollbar-thumb:hover {
    background: #555;
}
</style> <?php /**PATH /home/frankie_254/HIRESTREAM-APP/resources/views/invoices/partials/modals/create-expense-modal.blade.php ENDPATH**/ ?>