<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Activity Logs</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f5f5f5;
        }
        h1 {
            text-align: center;
            color: #333;
        }
        .header {
            margin-bottom: 20px;
        }
        .date {
            text-align: right;
            color: #666;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Activity Logs Report</h1>
        <div class="date">Generated on: <?php echo e(now()->format('Y-m-d H:i:s')); ?></div>
    </div>

    <table>
        <thead>
            <tr>
                <th>Description</th>
                <th>User</th>
                <th>Subject</th>
                <th>Date</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $activities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($activity->description); ?></td>
                    <td><?php echo e(optional($activity->causer)->name ?? 'System'); ?></td>
                    <td><?php echo e(class_basename($activity->subject_type)); ?> #<?php echo e($activity->subject_id); ?></td>
                    <td><?php echo e($activity->created_at->format('Y-m-d H:i:s')); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</body>
</html> <?php /**PATH /home/frankie_254/HIRESTREAM-APP/resources/views/exports/logs_pdf.blade.php ENDPATH**/ ?>