<!-- Create Invoice Modal -->
<div class="modal fade" id="createInvoiceModal" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Create New Invoice</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <!-- Available Workers Tab -->
                <div class="tab-pane fade show active" id="workers-pane" role="tabpanel" 
                     aria-labelledby="workers-tab" tabindex="0">
                    <div class="card border-0 shadow-sm">
                        <div class="card-body">
                            <div class="row mb-4">
                                <div class="col-md-6">
                                    <label for="agencyFilter" class="form-label">Filter by Agency</label>
                                    <select id="agencyFilter" class="form-select">
                                        <option value="">All Agencies</option>
                                        <?php $__currentLoopData = $agencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $agency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($agency->id); ?>"><?php echo e($agency->company_name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label fw-bold">Invoice Type:</label>
                                    <div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="checkbox" id="includeStamping" checked>
                                            <label class="form-check-label" for="includeStamping">Stamping</label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="checkbox" id="includeArrival" checked>
                                            <label class="form-check-label" for="includeArrival">Arrival</label>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="table-responsive mb-4">
                                <table class="table table-hover">
                                    <thead class="table-light">
                                        <tr>
                                            <th>#</th>
                                            <th>Worker Name</th>
                                            <th>Passport Number</th>
                                            <th>Company</th>
                                            <th>Stamping Fee</th>
                                            <th>Arrival Fee</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody id="workersTable">
                                        <?php $__currentLoopData = $eligibleWorkers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $worker): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($worker->contracted_agency): ?>
                                            <tr class="worker-row" data-agency-id="<?php echo e($worker->contracted_agency->id); ?>">
                                                <td><?php echo e($index + 1); ?></td>
                                                <td><?php echo e($worker->surname); ?> <?php echo e($worker->given_names); ?></td>
                                                <td><?php echo e($worker->passport_number); ?></td>
                                                <td><?php echo e($worker->contracted_agency->company_name); ?></td>
                                                <td>
                                                    <?php if(is_array($worker->stamping_fee)): ?>
                                                        <span class="badge bg-<?php echo e($worker->stamping_fee['status'] === 'paid' ? 'success text-white' : ($worker->stamping_fee['status'] === 'pending' ? 'warning text-dark' : 'info text-white')); ?>">
                                                            <?php echo e(ucfirst($worker->stamping_fee['status'])); ?>

                                                        </span>
                                                    <?php else: ?>
                                                        <?php echo e(number_format($worker->stamping_fee, 2)); ?>

                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <?php if(is_array($worker->arrival_fee)): ?>
                                                        <span class="badge bg-<?php echo e($worker->arrival_fee['status'] === 'paid' ? 'success text-white' : ($worker->arrival_fee['status'] === 'pending' ? 'warning text-dark' : 'info text-white')); ?>">
                                                            <?php echo e(ucfirst($worker->arrival_fee['status'])); ?>

                                                        </span>
                                                    <?php else: ?>
                                                        <?php echo e(number_format($worker->arrival_fee, 2)); ?>

                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <button class="btn btn-sm btn-primary add-to-invoice"
                                                        data-worker-id="<?php echo e($worker->id); ?>"
                                                        data-worker-name="<?php echo e($worker->surname); ?> <?php echo e($worker->given_names); ?>"
                                                        data-passport-number="<?php echo e($worker->passport_number); ?>"
                                                        data-company-id="<?php echo e($worker->contracted_agency->id); ?>"
                                                        data-company-name="<?php echo e($worker->contracted_agency->company_name); ?>"
                                                        data-company-email="<?php echo e($worker->contracted_agency->email); ?>"
                                                        data-company-phone="<?php echo e($worker->contracted_agency->phone); ?>"
                                                        data-company-city="<?php echo e($worker->contracted_agency->city); ?>"
                                                        data-company-country="<?php echo e($worker->contracted_agency->country); ?>"
                                                        data-company-recruitment-fee="<?php echo e($worker->contracted_agency->recruitment_fee); ?>"
                                                        data-stamping-fee="<?php echo e(is_array($worker->stamping_fee) ? $worker->stamping_fee['amount'] : $worker->stamping_fee); ?>"
                                                        data-arrival-fee="<?php echo e(is_array($worker->arrival_fee) ? $worker->arrival_fee['amount'] : $worker->arrival_fee); ?>"
                                                        data-stamping-status="<?php echo e(is_array($worker->stamping_fee) ? $worker->stamping_fee['status'] : 'not_invoiced'); ?>"
                                                        data-arrival-status="<?php echo e(is_array($worker->arrival_fee) ? $worker->arrival_fee['status'] : 'not_invoiced'); ?>"
                                                    >
                                                        <i class="fas fa-plus"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>

                            <div class="card mt-4">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0">Create New Invoice</h5>
                                </div>
                                <div class="card-body">
                                    <form action="<?php echo e(route('invoices.store')); ?>" method="POST" id="invoiceForm">
                                        <?php echo csrf_field(); ?>

                                        <div class="row">
                                            <div class="col-md-6">
                                                <h6 class="fw-bold">Billing Address</h6>
                                                <div class="ps-3" id="billing_address" style="white-space: pre-line; font-family: monospace; font-weight: bold;">
                                                    <!-- Content will be populated by JavaScript -->
                                                </div>

                                                <!-- Hidden Inputs to Submit -->
                                                <input type="hidden" name="client_name" id="client_name">
                                                <input type="hidden" name="client_email" id="client_email">
                                                <input type="hidden" name="client_phone" id="client_phone">
                                                <input type="hidden" name="client_city" id="client_city">
                                                <input type="hidden" name="client_country" id="client_country">
                                                <input type="hidden" name="external_agency_id" id="external_agency_id">
                                                <input type="hidden" name="total_amount" id="total_amount">
                                            </div>
                                            <div class="col-md-6">
                                                <h6 class="fw-bold">Selected Workers</h6>
                                                <div class="table-responsive">
                                                    <table class="table table-sm" id="selectedWorkersTable">
                                                        <thead>
                                                            <tr>
                                                                <th>#</th>
                                                                <th>Name</th>
                                                                <th>Stamping</th>
                                                                <th>Arrival</th>
                                                                <th>Action</th>
                                                                <th></th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!-- Filled dynamically -->
                                                        </tbody>
                                                        <tfoot class="table-light">
                                                            <tr>
                                                                <th colspan="2" class="text-end">Total</th>
                                                                <th id="totalStampingFee">0.00</th>
                                                                <th id="totalArrivalFee">0.00</th>
                                                                <th></th>
                                                            </tr>
                                                            <tr>
                                                                <th colspan="2" class="text-end">Subtotal</th>
                                                                <th colspan="2" id="subtotal">0.00</th>
                                                                <th></th>
                                                            </tr>
                                                        </tfoot>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="d-grid gap-2 d-md-flex justify-content-md-end mt-4">
                                            <button type="submit" class="btn btn-primary">
                                                <i class="fas fa-save me-1"></i> Create Invoice
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // === Invoice Functionality ===
    const selectedWorkerIds = new Set();
    const tableBody = document.querySelector('#selectedWorkersTable tbody');
    const billingAddressDiv = document.getElementById('billing_address');
    const invoiceForm = document.getElementById('invoiceForm');
    const hiddenFieldsContainer = document.createElement('div');
    hiddenFieldsContainer.id = 'hidden-fields-container';
    invoiceForm?.appendChild(hiddenFieldsContainer);

    let currentAgencyId = null;
    let isAddingWorker = false; // Flag to prevent multiple additions

    // Agency Filter
    const agencyFilter = document.getElementById('agencyFilter');
    agencyFilter?.addEventListener('change', function() {
        const selectedId = this.value;
        document.querySelectorAll('.worker-row').forEach(row => {
            row.style.display = (selectedId === "" || row.dataset.agencyId === selectedId) ? "" : "none";
        });
    });

    // Handle fee type changes
    document.getElementById('includeStamping')?.addEventListener('change', function() {
        recalculateFees();
    });

    document.getElementById('includeArrival')?.addEventListener('change', function() {
        recalculateFees();
    });

    // Recalculate fees when fee types change
    function recalculateFees() {
        const includeStamping = document.getElementById('includeStamping')?.checked ?? true;
        const includeArrival = document.getElementById('includeArrival')?.checked ?? true;

        // Only update the add buttons' states, not the already added workers
        document.querySelectorAll('.add-to-invoice:not([disabled])').forEach(button => {
            const stampingStatus = button.dataset.stampingStatus;
            const arrivalStatus = button.dataset.arrivalStatus;
            
            // Update button's visual state based on available fees
            if (stampingStatus !== 'not_invoiced') {
                button.classList.add('stamping-disabled');
            }
            if (arrivalStatus !== 'not_invoiced') {
                button.classList.add('arrival-disabled');
            }
        });
    }

    // Event delegation for Add Worker to Invoice
    const workersTable = document.getElementById('workersTable');

    // Prevent multiple event handler attachments
    if (workersTable && !window.invoiceAddHandlerAttached) {
        window.invoiceAddHandlerAttached = true;
        workersTable.addEventListener('click', async function(e) {
            const button = e.target.closest('.add-to-invoice');
            if (!button) return;
            e.preventDefault();
            e.stopPropagation();
            if (isAddingWorker) return;
            try {
                isAddingWorker = true;
                const workerId = String(button.dataset.workerId);
                const domHas = !!tableBody.querySelector(`tr[data-worker-id="${workerId}"]`);
                const setHas = selectedWorkerIds.has(workerId);
                console.log('Trying to add workerId:', workerId, 'DOM has:', domHas, 'Set has:', setHas);
                if (domHas && setHas) {
                    showErrorAlert('Error!', 'This worker is already in the invoice.');
                    return;
                }
                const agencyId = button.dataset.companyId;
                const workerName = button.dataset.workerName;
                const passportNumber = button.dataset.passportNumber;
                const companyName = button.dataset.companyName;
                const companyEmail = button.dataset.companyEmail;
                const companyPhone = button.dataset.companyPhone;
                const companyCity = button.dataset.companyCity;
                const companyCountry = button.dataset.companyCountry;
                if (!workerId || !agencyId || !workerName || !passportNumber || !companyName) {
                    showErrorAlert('Error!', 'Required worker or agency information is missing. Please contact support.');
                    return;
                }
                const stampingStatus = button.dataset.stampingStatus;
                const arrivalStatus = button.dataset.arrivalStatus;
                const stampingCheckbox = document.getElementById('includeStamping');
                const arrivalCheckbox = document.getElementById('includeArrival');
                const includeStamping = stampingStatus === 'not_invoiced' && stampingCheckbox.checked;
                const includeArrival = arrivalStatus === 'not_invoiced' && arrivalCheckbox.checked;
                const hasAvailableStamping = stampingStatus === 'not_invoiced';
                const hasAvailableArrival = arrivalStatus === 'not_invoiced';
                if (!hasAvailableStamping && !hasAvailableArrival) {
                    showErrorAlert('Error!', 'All fees for this worker have already been invoiced.');
                    return;
                }
                if (!includeStamping && !includeArrival) {
                    showErrorAlert('Error!', 'Please select at least one available fee type to include in the invoice.');
                    return;
                }
                if (stampingStatus !== 'not_invoiced') {
                    stampingCheckbox.checked = false;
                }
                if (arrivalStatus !== 'not_invoiced') {
                    arrivalCheckbox.checked = false;
                }
                const stampingFee = includeStamping ? parseFloat(button.dataset.stampingFee) || 0 : 0;
                const arrivalFee = includeArrival ? parseFloat(button.dataset.arrivalFee) || 0 : 0;
                if (currentAgencyId && currentAgencyId !== agencyId) {
                    showErrorAlert('Error!', 'Only workers from the same agency can be added.');
                    return;
                }
                if (selectedWorkerIds.size === 0) {
                    currentAgencyId = agencyId;
                    document.getElementById('external_agency_id').value = agencyId;
                    document.getElementById('client_name').value = companyName;
                    document.getElementById('client_email').value = companyEmail || '';
                    document.getElementById('client_phone').value = companyPhone || '';
                    document.getElementById('client_city').value = companyCity || '';
                    document.getElementById('client_country').value = companyCountry || '';
                    if (billingAddressDiv) {
                        billingAddressDiv.innerHTML = `
                            ${companyName}
                            ${companyEmail || 'No email provided'}
                            Phone: ${companyPhone || 'No phone provided'}
                            ${companyCity || 'No city'}, ${companyCountry || 'No country'}
                        `;
                    }
                }
                const workerData = {
                    id: workerId,
                    name: workerName,
                    passport: passportNumber,
                    stamping_fee: stampingFee,
                    arrival_fee: arrivalFee,
                    include_stamping: includeStamping,
                    include_arrival: includeArrival
                };
                const row = document.createElement('tr');
                row.className = 'selected-worker-row';
                row.dataset.workerId = workerId;
                row.dataset.stampingFee = stampingFee;
                row.dataset.arrivalFee = arrivalFee;
                row.dataset.includeStamping = includeStamping;
                row.dataset.includeArrival = includeArrival;
                row.innerHTML = `
                    <td>${selectedWorkerIds.size + 1}</td>
                    <td>${workerName}</td>
                    <td>${stampingFee.toFixed(2)}</td>
                    <td>${arrivalFee.toFixed(2)}</td>
                    <td class="text-end">
                        <button type="button" class="btn btn-sm btn-outline-danger remove-worker-btn" data-worker-id="${workerId}">
                            <i class="fas fa-times"></i>
                        </button>
                    </td>
                    <td></td>
                `;
                tableBody.appendChild(row);
                hiddenFieldsContainer.innerHTML += `
                    <input type="hidden" name="workers[]" value="${workerId}">
                    <input type="hidden" name="worker_names[]" value="${workerName}">
                    <input type="hidden" name="passport_numbers[]" value="${passportNumber}">
                    <input type="hidden" name="stamping_fees[]" value="${stampingFee}">
                    <input type="hidden" name="arrival_fees[]" value="${arrivalFee}">
                `;
                selectedWorkerIds.add(workerId);
                button.disabled = true;
                button.classList.replace('btn-primary', 'btn-secondary');
                console.log('Worker added:', workerId, 'Current selectedWorkerIds:', Array.from(selectedWorkerIds));
                calculateInvoice();
            } finally {
                isAddingWorker = false;
            }
        });
    }

    // Remove Worker from Invoice
    tableBody?.addEventListener('click', function(e) {
        if (e.target.closest('.remove-worker-btn')) {
            const btn = e.target.closest('.remove-worker-btn');
            const workerId = String(btn.dataset.workerId);
            
            selectedWorkerIds.delete(workerId);
            console.log('Removed workerId:', workerId, 'Current selectedWorkerIds:', Array.from(selectedWorkerIds));
            btn.closest('tr')?.remove();

            const addButton = document.querySelector(`.add-to-invoice[data-worker-id="${workerId}"]`);
            if (addButton) {
                addButton.disabled = false;
                addButton.classList.replace('btn-secondary', 'btn-primary');
            }

            if (selectedWorkerIds.size === 0) {
                currentAgencyId = null;
                // Clear hidden client fields
                document.getElementById('client_name').value = '';
                document.getElementById('client_email').value = '';
                document.getElementById('client_phone').value = '';
                document.getElementById('client_city').value = '';
                document.getElementById('client_country').value = '';
                if (billingAddressDiv) billingAddressDiv.innerHTML = '';
            } else {
                // Update row numbers to be sequential starting from 1
                document.querySelectorAll('#selectedWorkersTable tbody tr').forEach((row, index) => {
                    row.cells[0].textContent = index + 1;
                });
            }

            hiddenFieldsContainer.querySelectorAll(`input[value="${workerId}"]`).forEach(input => input.remove());
            calculateInvoice();
        }
    });

    // Calculate Invoice Totals
    window.calculateInvoice = function() {
        let totalStamping = 0, totalArrival = 0;
        document.querySelectorAll('#selectedWorkersTable tbody tr').forEach(row => {
            totalStamping += parseFloat(row.dataset.stampingFee) || 0;
            totalArrival += parseFloat(row.dataset.arrivalFee) || 0;
        });

        const subtotal = totalStamping + totalArrival;
        document.getElementById('totalStampingFee').textContent = totalStamping.toFixed(2);
        document.getElementById('totalArrivalFee').textContent = totalArrival.toFixed(2);
        document.getElementById('subtotal').textContent = subtotal.toFixed(2);
        document.getElementById('total_amount').value = subtotal.toFixed(2);
    };

    // Form Validation and Submission
    invoiceForm?.addEventListener('submit', function(e) {
        e.preventDefault();
        
        if (selectedWorkerIds.size === 0) {
            showErrorAlert('Error!', 'Please add at least one worker to the invoice.');
            return;
        }

        // Validate required fields
        const requiredFields = ['client_name', 'client_email', 'client_phone', 'client_city', 'client_country'];
        for (const field of requiredFields) {
            const value = document.getElementById(field).value.trim();
            if (!value) {
                showErrorAlert('Error!', 'Please ensure all client information is filled out.');
                return;
            }
        }

        // Validate total amount
        const totalAmount = parseFloat(document.getElementById('total_amount').value);
        if (isNaN(totalAmount) || totalAmount <= 0) {
            showErrorAlert('Error!', 'Please ensure the total amount is valid.');
            return;
        }

        // Show loading indicator
        Swal.fire({
            title: 'Creating Invoice',
            html: 'Please wait while we process your invoice...',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        // Submit the form traditionally
        this.submit();
    });

    // Reset form when modal is closed
    document.getElementById('createInvoiceModal').addEventListener('hidden.bs.modal', function () {
        document.getElementById('invoiceForm').reset();
        document.getElementById('billing_address').innerHTML = '';
        document.querySelector('#selectedWorkersTable tbody').innerHTML = '';
        selectedWorkerIds.clear();
        console.log('Modal closed, selectedWorkerIds cleared:', Array.from(selectedWorkerIds));
        currentAgencyId = null;
        
        // Reset all add buttons
        document.querySelectorAll('.add-to-invoice').forEach(button => {
            button.disabled = false;
            button.classList.replace('btn-secondary', 'btn-primary');
        });

        // Reset and enable fee type checkboxes
        const stampingCheckbox = document.getElementById('includeStamping');
        const arrivalCheckbox = document.getElementById('includeArrival');
        stampingCheckbox.checked = true;
        arrivalCheckbox.checked = true;
        stampingCheckbox.disabled = false;
        arrivalCheckbox.disabled = false;

        // Clear hidden fields
        document.getElementById('client_name').value = '';
        document.getElementById('client_email').value = '';
        document.getElementById('client_phone').value = '';
        document.getElementById('client_city').value = '';
        document.getElementById('client_country').value = '';
        document.getElementById('external_agency_id').value = '';
        document.getElementById('total_amount').value = '';
        
        calculateInvoice();
    });

    // Add CSS for modal toast positioning
    const style = document.createElement('style');
    style.textContent = `
        .modal-toast-container {
            position: absolute !important;
            top: 50% !important;
            left: 50% !important;
            transform: translate(-50%, -50%) !important;
            z-index: 1060 !important;
        }
        .colored-toast {
            background-color: white !important;
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15) !important;
            min-width: 300px !important;
            text-align: center !important;
        }
        .colored-toast.swal2-icon-success {
            border-left: 4px solid #28a745 !important;
        }
        .colored-toast.swal2-icon-error {
            border-left: 4px solid #dc3545 !important;
        }
        .colored-toast.swal2-icon-warning {
            border-left: 4px solid #ffc107 !important;
        }
        .colored-toast .swal2-title {
            font-size: 1rem !important;
            margin: 0.5em 1em !important;
        }
        .colored-toast .swal2-html-container {
            margin: 0.5em 1em !important;
            font-size: 0.875rem !important;
        }
    `;
    document.head.appendChild(style);
});

// General function to show SweetAlert
function showAlert(icon, title, text, confirmButtonText = 'OK') {
    Swal.fire({
        icon: icon,
        title: title,
        text: text,
        toast: true,
        position: 'center',
        showConfirmButton: false,
        timer: 3000,
        timerProgressBar: true,
        width: 'auto',
        padding: '0.5em',
        customClass: {
            popup: 'colored-toast',
            container: 'modal-toast-container'
        },
        target: '#createInvoiceModal .modal-content'
    });
}

// Success alert
function showSuccessAlert(title, text) {
    showAlert('success', title, text);
}

// Error alert
function showErrorAlert(title, text) {
    showAlert('error', title, text);
}

// Confirmation dialog
function showConfirmDialog(title, text, confirmButtonText, callback) {
    Swal.fire({
        title: title,
        text: text,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: confirmButtonText,
        customClass: {
            popup: 'colored-toast',
            container: 'modal-toast-container'
        },
        target: '#createInvoiceModal .modal-content'
    }).then((result) => {
        if (result.isConfirmed) {
            callback();
        }
    });
}
</script>
<?php $__env->stopPush(); ?><?php /**PATH /home/frankie_254/HIRESTREAM-APP/resources/views/invoices/partials/modals/create-invoice-modal.blade.php ENDPATH**/ ?>