<?php $__env->startSection('content'); ?>
<section class="py-4 py-lg-5">
    <div class="container">
        <!-- Search/Filter Bar -->
        <div class="row mb-4">
            <div class="col-md-10 mx-auto">
                <div class="input-group mb-3">
                    <input type="text" id="jobs-search-input" class="form-control" placeholder="Job title, company, Country, or keywords">
                    <select id="location-filter" class="form-select" style="max-width: 150px;">
                        <option>All Locations</option>
                        <option>UAE</option>
                        <option>Saudi Arabia</option>
                        <option>Qatar</option>
                        <option>Kuwait</option>
                        <option>Oman</option>
                        <option>East Zoiemouth
</option>
                    </select>
                    <select id="salary-filter" class="form-select" style="max-width: 150px;">
                        <option>Salary Range</option>
                        <option>1,000+ </option>
                        <option>1,500+ </option>
                        <option>2,000+</option>
                        <option>2,500+ </option>
                        <option>3,500+ </option>
                        <option>5,000+</option>
                    </select>
                    <button id="jobs-search-btn" class="btn btn-primary" type="button">
                        <i class="bi bi-search"></i> Search
                    </button>
                </div>
                <div class="d-flex flex-wrap gap-2">
                    <span class="badge bg-light text-dark border filter-badge active">All Jobs</span>
                    <span class="badge bg-light text-dark border filter-badge">Full-time</span>
                    <span class="badge bg-light text-dark border filter-badge">Contract</span>
                    <span class="badge bg-light text-dark border filter-badge">High Salary</span>
                    <span class="badge bg-light text-dark border filter-badge">Urgent Hiring</span>
                </div>
            </div>
        </div>
<!-- Create Job Button -->
<div class="mb-4 d-flex justify-content-end">
<a href="<?php echo e(route('jobs.create')); ?>" class="btn btn-success mb-4">
    <i class="bi bi-plus-circle"></i> Create Job
</a>

</div>

        <!-- Job Cards -->
        <div class="row mt-4" id="jobs-container">
            <?php $__currentLoopData = $jobs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $job): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-md-6 col-lg-4 mb-4">
                <div class="job-card">
                    <div class="job-header">
                        <h3><?php echo e($job->title); ?></h3>
                                        <div class="d-flex flex-wrap gap-2">
                        <!-- Job Type Badge -->
                        <span class="badge bg-primary"><?php echo e($job->type); ?></span>

                        <!-- Urgent Hiring Badge -->
                        <?php if($job->urgent): ?>
                        <span class="badge bg-danger">Urgent Hiring</span>
                        <?php endif; ?>

                        <!-- High Salary Badge -->
                        <?php if($job->highSalary): ?>
                        <span class="badge bg-warning text-dark">High Salary</span>
                        <?php endif; ?>

                        <!-- Commission Badge -->
                        <?php if($job->commission): ?>
                        <span class="badge bg-success">Commission</span>
                        <?php endif; ?>
                    </div>
                    </div>
                    <div class="job-meta">
                        <p><i class="bi bi-building"></i> <?php echo e($job->company); ?></p>
                        <p><i class="bi bi-geo-alt"></i> <?php echo e($job->location); ?></p>
                        <p><i class="bi bi-cash-stack"></i> <strong><?php echo e($job->salary); ?></strong></p>
                        <p><i class="bi bi-calendar-event"></i> Posted: <?php echo e(\Carbon\Carbon::parse($job->posted)->format('d M Y')); ?></p>
                        <p><i class="bi bi-clock-history"></i> Closes in: 
                            <strong><?php echo e(\Carbon\Carbon::now()->diffInDays(\Carbon\Carbon::parse($job->closes), false)); ?> days</strong>
                        </p>
                    </div>
                    <p class="job-desc"><?php echo e($job->description); ?></p>
                    <div class="job-skills">
                        <?php $__currentLoopData = explode(',', $job->skills); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $skill): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <span class="skill-tag"><?php echo e(trim($skill)); ?></span>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <div class="d-flex justify-content-between align-items-center mt-3">
                        <a href="#" class="text-blue"><i class="bi bi-bookmark"></i> Save</a>
                       
                        <a href="<?php echo e(route('applications.create', ['job' => $job->id])); ?>" class="btn btn-primary">Apply</a>
                                      </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <!-- Pagination -->
        <nav class="mt-5">
            <?php echo e($jobs->links()); ?>

        </nav>
    </div>

   

</section>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', () => {
    const jobsContainer = document.getElementById('jobs-container');
    const searchInput = document.getElementById('jobs-search-input');
    const locationFilter = document.getElementById('location-filter');
    const salaryFilter = document.getElementById('salary-filter');
    const filterBadges = document.querySelectorAll('.filter-badge');
    const searchBtn = document.getElementById('jobs-search-btn');

    // Normalize text to lower case for case-insensitive matching
    function normalizeText(text) {
        return text.toLowerCase();
    }

    // Parse salary for comparison
    function parseSalary(salaryText) {
        const match = salaryText.replace(/[^0-9\-]/g, '').split('+').map(Number);
        return match.length > 0 ? match[0] : 0;
    }

    // Get the active filter type (Full-time, Contract, etc.)
    function getActiveFilterType() {
        const active = document.querySelector('.filter-badge.active');
        return active && active.textContent !== 'All Jobs' ? active.textContent : null;
    }

    // Filter jobs based on input values
    function filterJobs() {
        console.log('Filtering jobs...');

        const searchTerm = normalizeText(searchInput.value.trim());
        const locationVal = locationFilter.value;
        const salaryVal = salaryFilter.value;
        const filterType = getActiveFilterType();

        const cards = jobsContainer.querySelectorAll('.job-card');
        console.log('Jobs found:', cards.length);

        cards.forEach(card => {
            const title = normalizeText(card.querySelector('.job-header h3').textContent);
            const company = normalizeText(card.querySelector('.job-meta').textContent);
            const description = normalizeText(card.querySelector('.job-desc').textContent);
            const location = card.querySelector('.bi-geo-alt')?.parentElement.textContent || '';
            const salaryText = card.querySelector('.bi-cash-stack')?.parentElement.textContent || '';
            const badges = Array.from(card.querySelectorAll('.job-header .badge')).map(b => b.textContent.trim());
            const combinedText = `${title} ${company} ${description}`;

            let show = true;

            // Search term match
            if (searchTerm && !combinedText.includes(searchTerm)) {
                show = false;
            }

            // Location filter
            if (locationVal !== 'All Locations' && !location.includes(locationVal)) {
                show = false;
            }

            // Salary filter
            if (salaryVal !== 'Salary Range') {
                const minSalary = parseSalary(salaryVal);
                const actualSalary = parseSalary(salaryText);
                if (actualSalary < minSalary) {
                    show = false;
                }
            }

            // Filter badge (type, urgent, etc.)
            if (filterType && !badges.includes(filterType)) {
                show = false;
            }

            // Show or hide the job card based on filters
            card.closest('.col-md-6').style.display = show ? 'block' : 'none';
        });
    }

    // Event listeners for each filter
    searchBtn.addEventListener('click', () => {
        console.log('Search button clicked');
        filterJobs();
    });

    searchInput.addEventListener('keyup', event => {
        console.log('Key pressed: ', event.key);
        if (event.key === 'Enter') filterJobs();
    });

    locationFilter.addEventListener('change', filterJobs);
    salaryFilter.addEventListener('change', filterJobs);

    filterBadges.forEach(badge => {
        badge.addEventListener('click', () => {
            filterBadges.forEach(b => b.classList.remove('active'));
            badge.classList.add('active');
            filterJobs();
        });
    });
       

});
</script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.jobs', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/frankie_254/HIRESTREAM-APP/resources/views/jobs/index.blade.php ENDPATH**/ ?>