<?php $__env->startSection('content'); ?>
<div class="container">
    <!-- Back Navigation -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <a href="<?php echo e(route('invoices.index')); ?>" class="text-blue hover:text-blue-200">
            <i class="fas fa-arrow-left"></i> Back to List
        </a>
        <h4 class="mb-0">Invoice Details</h4>
    </div>

    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h2>Invoice #<?php echo e($invoice->invoice_number); ?></h2>
            <div class="d-flex gap-2">
                <a href="<?php echo e(route('invoices.export', $invoice->id)); ?>" class="btn btn-info">
                    <i class="fas fa-file-pdf"></i> Export PDF
                </a>
                <a href="<?php echo e(route('invoices.edit', $invoice->id)); ?>" class="btn btn-primary">
                    <i class="fas fa-edit"></i> Edit
                </a>
                <form action="<?php echo e(route('invoices.send', $invoice->id)); ?>" method="POST" class="d-inline">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-paper-plane"></i> Send to Client
                    </button>
                </form>
            </div>
        </div>

        <div class="card-body">
            <!-- Status and Payment Progress -->
            <div class="row mb-4">
                <div class="col-md-6">
                    <div class="card bg-light">
                        <div class="card-body">
                            <h5 class="card-title">Payment Status</h5>
                            <div class="d-flex align-items-center mb-3">
                                <div class="flex-grow-1">
                                    <div class="progress" style="height: 20px;">
                                        <div class="progress-bar bg-success" role="progressbar" 
                                             style="width: <?php echo e($invoice->getPaymentProgress()); ?>%"
                                             aria-valuenow="<?php echo e($invoice->getPaymentProgress()); ?>" 
                                             aria-valuemin="0" aria-valuemax="100">
                                            <?php echo e(number_format($invoice->getPaymentProgress(), 1)); ?>%
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-6">
                                    <p class="mb-1">Total Amount:</p>
                                    <h4>$<?php echo e(number_format($invoice->total_amount, 2)); ?></h4>
                                </div>
                                <div class="col-6">
                                    <p class="mb-1">Paid Amount:</p>
                                    <h4>$<?php echo e(number_format($invoice->paid_amount, 2)); ?></h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card bg-light">
                        <div class="card-body">
                            <h5 class="card-title">Invoice Details</h5>
                            <p><strong>Status:</strong> 
                                <span class="badge bg-<?php echo e($invoice->status == 'paid' ? 'success' : 'info'); ?>">
                                    <?php echo e(ucfirst($invoice->status)); ?>

                                </span>
                            </p>
                            <p><strong>Issue Date:</strong> <?php echo e($invoice->invoice_date ? $invoice->invoice_date->format('d M Y') : 'N/A'); ?></p>
                            <p><strong>Due Date:</strong> <?php echo e($invoice->due_date ? $invoice->due_date->format('d M Y') : 'N/A'); ?></p>
                            <?php if($invoice->payment_date): ?>
                                <p><strong>Last Payment:</strong> <?php echo e($invoice->payment_date->format('d M Y')); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Billing Information -->
            <div class="row mb-4">
                <div class="col-md-6">
                    <h5>Billing Information</h5>
                    <p>
                        <strong><?php echo e($invoice->client_name); ?></strong><br>
                        <?php echo e($invoice->client_city); ?>, <?php echo e($invoice->client_country); ?><br>
                        <?php echo e($invoice->client_email); ?><br>
                        <?php echo e($invoice->client_phone); ?>

                    </p>
                </div>
            </div>

            <!-- Workers List -->
            <div class="card mt-4">
                <div class="card-header">
                    <h5 class="mb-0">Workers</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th class="text-center">#</th>
                                    <th class="text-center">Name</th>
                                    <th class="text-center">Passport</th>
                                    <th class="text-center">Stamping Fee</th>
                                    <th class="text-center">Arrival Fee</th>
                                    <th class="text-center">Total</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    $totalStampingFee = 0;
                                    $totalArrivalFee = 0;
                                ?>
                                <?php $__currentLoopData = $workers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $worker): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $stampingFee = $worker['stamping_fee'] ?? 0;
                                        $arrivalFee = $worker['arrival_fee'] ?? 0;
                                        $workerTotal = $stampingFee + $arrivalFee;
                                        $totalStampingFee += $stampingFee;
                                        $totalArrivalFee += $arrivalFee;
                                    ?>
                                    <tr>
                                        <td class="text-center fw-bold"><?php echo e($index + 1); ?></td>
                                        <td class="text-center fw-bold"><?php echo e($worker['worker_name']); ?></td>
                                        <td class="text-center fw-bold"><?php echo e($worker['passport_number']); ?></td>
                                        <td class="text-center fw-bold"><?php echo e(number_format($stampingFee, 2)); ?></td>
                                        <td class="text-center fw-bold"><?php echo e(number_format($arrivalFee, 2)); ?></td>
                                        <td class="text-center fw-bold"><?php echo e(number_format($workerTotal, 2)); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                            <tfoot class="table-light">
                                <tr>
                                    <th colspan="3" class="text-end">Subtotals:</th>
                                    <th class="text-center fw-bold"><?php echo e(number_format($totalStampingFee, 2)); ?></th>
                                    <th class="text-center fw-bold"><?php echo e(number_format($totalArrivalFee, 2)); ?></th>
                                    <th class="text-center fw-bold"><?php echo e(number_format($totalStampingFee + $totalArrivalFee, 2)); ?></th>
                                </tr>
                                <tr>
                                    <th colspan="5" class="text-end">Grand Total:</th>
                                    <th class="text-center fw-bold"><?php echo e(number_format($totalStampingFee + $totalArrivalFee, 2)); ?></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Payment History -->
            <?php if($invoice->paid_amount > 0): ?>
                <div class="card mt-4">
                    <div class="card-header">
                        <h5 class="mb-0">Payment History</h5>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-sm">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Amount</th>
                                        <th>Method</th>
                                        <th>Notes</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $invoice->payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($payment->payment_date->format('d M Y')); ?></td>
                                            <td>$<?php echo e(number_format($payment->amount, 2)); ?></td>
                                            <td><?php echo e(ucfirst(str_replace('_', ' ', $payment->payment_method))); ?></td>
                                            <td><?php echo e($payment->payment_notes); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Payment Form -->
            <?php if($invoice->status !== 'paid'): ?>
                <div class="card mt-4">
                    <div class="card-header">
                        <h5 class="mb-0">Record Payment</h5>
                    </div>
                    <div class="card-body">
                        <form id="paymentForm" action="<?php echo e(route('invoices.recordPayment', $invoice->id)); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label for="amount" class="form-label">Amount</label>
                                        <div class="input-group">
                                            <span class="input-group-text">$</span>
                                            <input type="number" step="0.01" class="form-control" id="amount" 
                                                   name="amount" required 
                                                   max="<?php echo e($invoice->total_amount - $invoice->paid_amount); ?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label for="payment_method" class="form-label">Payment Method</label>
                                        <select class="form-select" id="payment_method" name="payment_method" required>
                                            <option value="bank_transfer">Bank Transfer</option>
                                            <option value="cash">Cash</option>
                                            <option value="credit_card">Credit Card</option>
                                            <option value="other">Other</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label for="payment_date" class="form-label">Payment Date</label>
                                        <input type="date" class="form-control" id="payment_date" 
                                               name="payment_date" required 
                                               value="<?php echo e(date('Y-m-d')); ?>">
                                    </div>
                                </div>
                            </div>
                            <div class="mb-3">
                                <label for="payment_notes" class="form-label">Notes</label>
                                <textarea class="form-control" id="payment_notes" name="payment_notes" rows="2"></textarea>
                            </div>
                            <button type="submit" class="btn btn-primary">Record Payment</button>
                        </form>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
let isSubmitting = false;

document.getElementById('paymentForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    if (isSubmitting) {
        return; // Prevent double submission
    }
    
    const form = this;
    const formData = new FormData(form);
    const submitButton = form.querySelector('button[type="submit"]');
    
    // Set submitting flag and disable form
    isSubmitting = true;
    submitButton.disabled = true;
    form.querySelectorAll('input, select, textarea').forEach(input => {
        input.disabled = true;
    });
    
    fetch(form.action, {
        method: 'POST',
        body: formData,
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
            'Accept': 'application/json'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Show success toast using SweetAlert
            const Toast = Swal.mixin({
                toast: true,
                position: 'center',
                showConfirmButton: false,
                timer: 3000,
                timerProgressBar: true,
                width: 'auto',
                padding: '0.5em',
                customClass: {
                    popup: 'colored-toast'
                }
            });

            Toast.fire({
                icon: 'success',
                title: 'Success!',
                text: 'Payment recorded successfully!'
            }).then(() => {
                window.location.reload();
            });
        } else {
            // Reset form state on error
            isSubmitting = false;
            submitButton.disabled = false;
            form.querySelectorAll('input, select, textarea').forEach(input => {
                input.disabled = false;
            });
            
            // Show error toast using SweetAlert
            const ErrorAlert = Swal.mixin({
                toast: true,
                position: 'center',
                showConfirmButton: true,
                confirmButtonColor: '#3085d6',
                confirmButtonText: 'OK',
                icon: 'error',
                width: 'auto',
                padding: '0.5em',
                customClass: {
                    popup: 'colored-toast'
                }
            });

            ErrorAlert.fire({
                title: 'Error',
                text: data.message || 'Error recording payment'
            });
        }
    })
    .catch(error => {
        // Reset form state on error
        isSubmitting = false;
        submitButton.disabled = false;
        form.querySelectorAll('input, select, textarea').forEach(input => {
            input.disabled = false;
        });
        
        console.error('Error:', error);
        // Show error toast using SweetAlert
        const ErrorAlert = Swal.mixin({
            toast: true,
            position: 'center',
            showConfirmButton: true,
            confirmButtonColor: '#3085d6',
            confirmButtonText: 'OK',
            icon: 'error',
            width: 'auto',
            padding: '0.5em',
            customClass: {
                popup: 'colored-toast'
            }
        });

        ErrorAlert.fire({
            title: 'Error',
            text: 'Error recording payment'
        });
    });
});

// Add custom styles for smaller popups
const style = document.createElement('style');
style.textContent = `
    .colored-toast {
        font-size: 0.9em !important;
        min-width: 200px !important;
        max-width: 400px !important;
    }
    .colored-toast .swal2-title {
        font-size: 1.1em !important;
        margin: 0.5em !important;
    }
    .colored-toast .swal2-html-container {
        font-size: 0.9em !important;
        margin: 0.5em !important;
    }
    .colored-toast .swal2-confirm {
        padding: 0.3em 1em !important;
        font-size: 0.9em !important;
    }
`;
document.head.appendChild(style);
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.invoices', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/frankie_254/HIRESTREAM-APP/resources/views/invoices/show.blade.php ENDPATH**/ ?>