<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['expenses', 'activeTab']));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['expenses', 'activeTab']), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars); ?>

<div class="tab-pane fade <?php echo e($activeTab === 'expenses' ? 'show active' : ''); ?>" id="expenses" role="tabpanel" aria-labelledby="expenses-tab" tabindex="0">
    <div class="card border-0 shadow-sm">
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h5 class="card-title mb-0">Monthly Expenses</h5>
                <div class="btn-group">
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addExpenseModal">
                        <i class="fas fa-plus me-2"></i>Add Monthly Expense
                    </button>
                    <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#updateCreditModal">
                        <i class="fas fa-credit-card me-2"></i>Update Credit
                    </button>
                </div>
            </div>

            <?php
                $totalAmountPaid = $expenses->sum('amount_paid');
                $totalCredit = $expenses->sum('credit');
            ?>

            <div class="table-responsive">
                <table class="table table-striped align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>Name</th>
                            <th>Task</th>
                            <th>Amount Paid</th>
                            <th>Credit</th>
                            <th>Current Account</th>
                            <th>Due Date</th>
                            <th>Notes</th>
                            <th>Actions</th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php $runningBalance = 0; ?>
                        <?php $__currentLoopData = $expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $runningBalance += $expense->credit - $expense->amount_paid;
                            ?>
                            <tr>
                                <td><?php echo e($expense->name); ?></td>
                                <td><?php echo e($expense->task); ?></td>
                                <td><?php echo e(number_format($expense->amount_paid, 2)); ?></td>
                                <td><?php echo e(number_format($expense->credit, 2)); ?></td>
                                <td><?php echo e(number_format($runningBalance, 2)); ?></td>
                                <td><?php echo e(\Carbon\Carbon::parse($expense->due_date)->format('Y-m-d')); ?></td>
                                <td><?php echo e($expense->notes); ?></td>
                                <td>
                                    <button class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#editExpenseModal<?php echo e($expense->id); ?>">
                                        <i class="fas fa-edit me-1"></i>Edit
                                    </button>
                                    <form action="<?php echo e(route('monthly-expenses.destroy', $expense->id)); ?>" method="POST" style="display:inline-block;">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">
                                            <i class="fas fa-trash me-1"></i>Delete
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>

                    <tfoot class="table-light fw-bold">
                        <tr>
                            <td colspan="2">Totals</td>
                            <td><?php echo e(number_format($totalAmountPaid, 2)); ?></td>
                            <td><?php echo e(number_format($totalCredit, 2)); ?></td>
                            <td colspan="3" class="<?php echo e(($totalCredit - $totalAmountPaid) >= 0 ? 'text-success' : 'text-danger'); ?>">
                                <?php echo e(number_format($totalCredit - $totalAmountPaid, 2)); ?>

                            </td>
                            <td colspan="3"></td>
                        </tr>
                        <tr>
                            <td colspan="2">Net Balance (Credit - Amount Paid)</td>
                            <td colspan="3" class="<?php echo e(($totalCredit - $totalAmountPaid) >= 0 ? 'text-success' : 'text-danger'); ?>">
                                <?php echo e(number_format($totalCredit - $totalAmountPaid, 2)); ?>

                            </td>
                            <td colspan="3"></td>
                        </tr>
                    </tfoot>
                </table>
            </div>

            <div class="d-flex justify-content-end mb-3 gap-2">
                <a href="<?php echo e(route('monthly-expenses.export')); ?>" class="btn btn-success">
                    <i class="fas fa-file-excel me-2"></i>Export to Excel
                </a>
                <a href="<?php echo e(route('monthly-expenses.export-pdf')); ?>" class="btn btn-danger">
                    <i class="fas fa-file-pdf me-2"></i>Export to PDF
                </a>
            </div>
        </div>
    </div>
</div>

<?php echo $__env->make('invoices.partials.modals.create-expense-modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?> <?php /**PATH /home/frankie_254/HIRESTREAM-APP/resources/views/components/invoices/expenses-tab.blade.php ENDPATH**/ ?>