<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            <?php echo e(__('Settings')); ?>

        </h2>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    <!-- Tab Navigation -->
                    <div class="border-b border-gray-200 mb-6">
                        <nav class="-mb-px flex space-x-8" aria-label="Tabs">
                            <button onclick="showTab('general')" class="tab-button border-indigo-500 text-indigo-600 whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm" aria-current="page">
                                General
                            </button>
                            <button onclick="showTab('backup')" class="tab-button border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                                Backup
                            </button>
                            <button onclick="showTab('notifications')" class="tab-button border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                                Notifications
                            </button>
                            <button onclick="showTab('security')" class="tab-button border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                                Security
                            </button>
                            <button onclick="showTab('system')" class="tab-button border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                                System Info
                            </button>
                        </nav>
                    </div>

                    <!-- Error Messages -->
                    <div id="error-messages" class="hidden mb-4">
                        <div class="rounded-md bg-red-50 p-4">
                            <div class="flex">
                                <div class="flex-shrink-0">
                                    <svg class="h-5 w-5 text-red-400" viewBox="0 0 20 20" fill="currentColor">
                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"/>
                                    </svg>
                                </div>
                                <div class="ml-3">
                                    <h3 class="text-sm font-medium text-red-800">There were errors with your submission</h3>
                                    <div class="mt-2 text-sm text-red-700">
                                        <ul id="error-list" class="list-disc pl-5 space-y-1"></ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Success Message -->
                    <div id="success-message" class="hidden mb-4">
                        <div class="rounded-md bg-green-50 p-4">
                            <div class="flex">
                                <div class="flex-shrink-0">
                                    <svg class="h-5 w-5 text-green-400" viewBox="0 0 20 20" fill="currentColor">
                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                                    </svg>
                                </div>
                                <div class="ml-3">
                                    <p class="text-sm font-medium text-green-800">Settings updated successfully</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <form id="settingsForm">
                        <!-- General Settings -->
                        <div id="general" class="settings-section mb-4">
                            <h4 class="text-lg font-semibold mb-3">General Settings</h4>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div class="form-group">
                                    <label for="site_name" class="block text-sm font-medium text-gray-700">Site Name</label>
                                    <input type="text" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" id="site_name" name="settings[site_name]" value="<?php echo e($settings['general']['site_name'] ?? ''); ?>">
                                    <p class="mt-1 text-sm text-red-600 error-message" data-field="site_name"></p>
                                </div>
                                <div class="form-group">
                                    <label for="site_description" class="block text-sm font-medium text-gray-700">Site Description</label>
                                    <input type="text" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" id="site_description" name="settings[site_description]" value="<?php echo e($settings['general']['site_description'] ?? ''); ?>">
                                    <p class="mt-1 text-sm text-red-600 error-message" data-field="site_description"></p>
                                </div>
                            </div>
                            <div class="mt-4">
                                <button type="button" onclick="saveSection('general')" class="inline-flex items-center px-4 py-2 bg-gray-800 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-gray-700 focus:bg-gray-700 active:bg-gray-900 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 transition ease-in-out duration-150">
                                    Save General Settings
                                </button>
                            </div>
                        </div>

                        <!-- Backup Settings -->
                        <div id="backup" class="settings-section mb-4 hidden">
                            <h4 class="text-lg font-semibold mb-3">Backup Settings</h4>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div class="form-group">
                                    <label for="backup_frequency" class="block text-sm font-medium text-gray-700">Backup Frequency</label>
                                    <select class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" id="backup_frequency" name="settings[backup_frequency]">
                                        <option value="daily" <?php echo e(($settings['backup']['backup_frequency'] ?? '') == 'daily' ? 'selected' : ''); ?>>Daily</option>
                                        <option value="weekly" <?php echo e(($settings['backup']['backup_frequency'] ?? '') == 'weekly' ? 'selected' : ''); ?>>Weekly</option>
                                        <option value="monthly" <?php echo e(($settings['backup']['backup_frequency'] ?? '') == 'monthly' ? 'selected' : ''); ?>>Monthly</option>
                                    </select>
                                    <p class="mt-1 text-sm text-red-600 error-message" data-field="backup_frequency"></p>
                                </div>
                                <div class="form-group">
                                    <label for="backup_retention" class="block text-sm font-medium text-gray-700">Backup Retention (days)</label>
                                    <input type="number" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" id="backup_retention" name="settings[backup_retention]" value="<?php echo e($settings['backup']['backup_retention'] ?? '30'); ?>">
                                    <p class="mt-1 text-sm text-red-600 error-message" data-field="backup_retention"></p>
                                </div>
                            </div>
                            <div class="mt-4">
                                <button type="button" onclick="saveSection('backup')" class="inline-flex items-center px-4 py-2 bg-gray-800 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-gray-700 focus:bg-gray-700 active:bg-gray-900 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 transition ease-in-out duration-150">
                                    Save Backup Settings
                                </button>
                            </div>
                        </div>

                        <!-- Notification Settings -->
                        <div id="notifications" class="settings-section mb-4 hidden">
                            <h4 class="text-lg font-semibold mb-3">Notification Settings</h4>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div class="form-group">
                                    <label for="email_notifications" class="block text-sm font-medium text-gray-700">Email Notifications</label>
                                    <select class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" id="email_notifications" name="settings[email_notifications]">
                                        <option value="enabled" <?php echo e(($settings['notifications']['email_notifications'] ?? '') == 'enabled' ? 'selected' : ''); ?>>Enabled</option>
                                        <option value="disabled" <?php echo e(($settings['notifications']['email_notifications'] ?? '') == 'disabled' ? 'selected' : ''); ?>>Disabled</option>
                                    </select>
                                    <p class="mt-1 text-sm text-red-600 error-message" data-field="email_notifications"></p>
                                </div>
                                <div class="form-group">
                                    <label for="notification_email" class="block text-sm font-medium text-gray-700">Notification Email</label>
                                    <input type="email" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" id="notification_email" name="settings[notification_email]" value="<?php echo e($settings['notifications']['notification_email'] ?? ''); ?>">
                                    <p class="mt-1 text-sm text-red-600 error-message" data-field="notification_email"></p>
                                </div>
                            </div>
                            <div class="mt-4">
                                <button type="button" onclick="saveSection('notifications')" class="inline-flex items-center px-4 py-2 bg-gray-800 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-gray-700 focus:bg-gray-700 active:bg-gray-900 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 transition ease-in-out duration-150">
                                    Save Notification Settings
                                </button>
                            </div>
                        </div>

                        <!-- Security Settings -->
                        <div id="security" class="settings-section mb-4 hidden">
                            <h4 class="text-lg font-semibold mb-3">Security Settings</h4>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div class="form-group">
                                    <label for="session_timeout" class="block text-sm font-medium text-gray-700">Session Timeout (minutes)</label>
                                    <input type="number" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" id="session_timeout" name="settings[session_timeout]" value="<?php echo e($settings['security']['session_timeout'] ?? '30'); ?>">
                                    <p class="mt-1 text-sm text-red-600 error-message" data-field="session_timeout"></p>
                                </div>
                                <div class="form-group">
                                    <label for="max_login_attempts" class="block text-sm font-medium text-gray-700">Max Login Attempts</label>
                                    <input type="number" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" id="max_login_attempts" name="settings[max_login_attempts]" value="<?php echo e($settings['security']['max_login_attempts'] ?? '5'); ?>">
                                    <p class="mt-1 text-sm text-red-600 error-message" data-field="max_login_attempts"></p>
                                </div>
                            </div>
                            <div class="mt-4">
                                <button type="button" onclick="saveSection('security')" class="inline-flex items-center px-4 py-2 bg-gray-800 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-gray-700 focus:bg-gray-700 active:bg-gray-900 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 transition ease-in-out duration-150">
                                    Save Security Settings
                                </button>
                            </div>
                        </div>

                        <!-- System Info -->
                        <div id="system" class="settings-section mb-4 hidden">
                            <h4 class="text-lg font-semibold mb-3">System Information</h4>
                            <div class="bg-gray-50 p-4 rounded-lg">
                                <dl class="grid grid-cols-1 gap-x-4 gap-y-6 sm:grid-cols-2">
                                    <div>
                                        <dt class="text-sm font-medium text-gray-500">PHP Version</dt>
                                        <dd class="mt-1 text-sm text-gray-900"><?php echo e(phpversion()); ?></dd>
                                    </div>
                                    <div>
                                        <dt class="text-sm font-medium text-gray-500">Laravel Version</dt>
                                        <dd class="mt-1 text-sm text-gray-900"><?php echo e(app()->version()); ?></dd>
                                    </div>
                                    <div>
                                        <dt class="text-sm font-medium text-gray-500">Server Software</dt>
                                        <dd class="mt-1 text-sm text-gray-900"><?php echo e($_SERVER['SERVER_SOFTWARE'] ?? 'N/A'); ?></dd>
                                    </div>
                                    <div>
                                        <dt class="text-sm font-medium text-gray-500">Database</dt>
                                        <dd class="mt-1 text-sm text-gray-900"><?php echo e(config('database.default')); ?></dd>
                                    </div>
                                </dl>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
    <!-- Add SweetAlert2 CDN -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
    function showTab(tabId) {
        // Hide all sections
        document.querySelectorAll('.settings-section').forEach(section => {
            section.classList.add('hidden');
        });
        
        // Show selected section
        document.getElementById(tabId).classList.remove('hidden');
        
        // Update tab styles
        document.querySelectorAll('.tab-button').forEach(button => {
            button.classList.remove('border-indigo-500', 'text-indigo-600');
            button.classList.add('border-transparent', 'text-gray-500');
        });
        
        // Style active tab
        event.target.classList.remove('border-transparent', 'text-gray-500');
        event.target.classList.add('border-indigo-500', 'text-indigo-600');
    }

    function showError(field, message) {
        const errorElement = document.querySelector(`.error-message[data-field="${field}"]`);
        if (errorElement) {
            errorElement.textContent = message;
        }
    }

    function clearErrors() {
        document.querySelectorAll('.error-message').forEach(element => {
            element.textContent = '';
        });
        document.getElementById('error-messages').classList.add('hidden');
        document.getElementById('error-list').innerHTML = '';
    }

    function showSuccess() {
        const Toast = Swal.mixin({
            toast: true,
            position: 'center',
            showConfirmButton: false,
            timer: 3000,
            timerProgressBar: true,
            didOpen: (toast) => {
                toast.addEventListener('mouseenter', Swal.stopTimer)
                toast.addEventListener('mouseleave', Swal.resumeTimer)
            }
        });

        Toast.fire({
            icon: 'success',
            title: 'Settings updated successfully',
            customClass: {
                popup: 'colored-toast'
            }
        });
    }

    function showErrorToast(message) {
        const Toast = Swal.mixin({
            toast: true,
            position: 'center',
            showConfirmButton: false,
            timer: 5000,
            timerProgressBar: true,
            didOpen: (toast) => {
                toast.addEventListener('mouseenter', Swal.stopTimer)
                toast.addEventListener('mouseleave', Swal.resumeTimer)
            }
        });

        Toast.fire({
            icon: 'error',
            title: message,
            customClass: {
                popup: 'colored-toast'
            }
        });
    }

    async function saveSection(section) {
        clearErrors();
        
        try {
            const form = document.getElementById('settingsForm');
            const formData = new FormData(form);
            const settings = {};
            
            // Get only the settings for the current section
            for (let [key, value] of formData.entries()) {
                if (key.startsWith('settings[')) {
                    const settingKey = key.match(/settings\[(.*?)\]/)[1];
                    if (isSettingInSection(settingKey, section)) {
                        settings[settingKey] = value;
                    }
                }
            }

            const response = await fetch('<?php echo e(route("settings.update")); ?>', {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                    'Accept': 'application/json',
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({ settings: settings })
            });

            const result = await response.json();

            if (result.success) {
                showSuccess();
            } else {
                if (result.errors) {
                    // Show validation errors in a more user-friendly way
                    const errorMessages = Object.entries(result.errors)
                        .map(([field, message]) => `${field}: ${message}`)
                        .join('\n');
                    
                    Swal.fire({
                        icon: 'error',
                        title: 'Validation Error',
                        text: errorMessages,
                        confirmButtonText: 'OK',
                        position: 'center',
                        customClass: {
                            popup: 'colored-toast'
                        }
                    });

                    // Also show field-specific errors
                    Object.entries(result.errors).forEach(([field, message]) => {
                        showError(field, message);
                    });
                } else {
                    showErrorToast(result.message || 'Failed to update settings');
                }
            }
        } catch (error) {
            console.error('Error:', error);
            showErrorToast('An error occurred while updating settings');
        }
    }

    function isSettingInSection(settingKey, section) {
        const sectionSettings = {
            'general': ['site_name', 'site_description'],
            'backup': ['backup_frequency', 'backup_retention'],
            'notifications': ['email_notifications', 'notification_email'],
            'security': ['session_timeout', 'max_login_attempts']
        };
        
        return sectionSettings[section]?.includes(settingKey) || false;
    }
    </script>
    <?php $__env->stopPush(); ?>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?> <?php /**PATH /home/frankie_254/HIRESTREAM-APP/resources/views/settings/index.blade.php ENDPATH**/ ?>