<?php $__env->startSection('title', 'Office Visitors'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>
    <?php if(session('error')): ?>
        <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
    <?php endif; ?>
    <div class="card">
        <div class="card-header d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center gap-2">
            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#create">
                Add Visitor
            </button>

            <!-- Export Buttons -->
            <div class="btn-group">
                <a href="<?php echo e(route('visitors.export', ['format' => 'csv'])); ?>" class="btn btn-sm btn-outline-primary">Export to CSV</a>
                <a href="<?php echo e(route('visitors.export', ['format' => 'pdf'])); ?>" class="btn btn-sm btn-outline-danger">Export to PDF</a>
            </div>

            <!-- Filters -->
            <div class="btn-group flex-wrap">
                <a href="<?php echo e(route('visitors.index')); ?>" class="btn btn-secondary <?php echo e(request('filter') == null ? 'active' : ''); ?>">
                    All (<?php echo e($allCount); ?>)
                </a>
                <a href="<?php echo e(route('visitors.index', ['filter' => 'checked-in'])); ?>" class="btn btn-warning <?php echo e(request('filter') == 'checked-in' ? 'active' : ''); ?>">
                    Checked-In (<?php echo e($checkedInCount); ?>)
                </a>
                <a href="<?php echo e(route('visitors.index', ['filter' => 'checked-out'])); ?>" class="btn btn-success <?php echo e(request('filter') == 'checked-out' ? 'active' : ''); ?>">
                    Checked-Out (<?php echo e($checkedOutCount); ?>)
                </a>
                <a href="<?php echo e(route('visitors.index', ['filter' => 'deleted'])); ?>" class="btn btn-primary <?php echo e(request('filter') == 'deleted' ? 'active' : ''); ?>">
                    Registered (<?php echo e($deletedCount); ?>)
                </a>
            </div>

            <!-- Search -->
            <form action="<?php echo e(route('visitors.index')); ?>" method="GET" class="d-flex flex-wrap gap-2 mt-2">
                <input type="text" name="search" class="form-control" placeholder="Search visitors..." value="<?php echo e(request('search')); ?>">
                <button type="submit" class="btn btn-primary">Search</button>
            </form>
        </div>

        <div class="card-body">
            <h3>Visitors List</h3>
            <div class="table-responsive">
                <table class="table table-striped table-bordered align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>#</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Phone</th>
                            <th>Purpose</th>
                            <th>Check-in</th>
                            <th>Check-out</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $visitors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $visitor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($index + 1); ?></td>
                            <td><?php echo e($visitor->name); ?></td>
                            <td><?php echo e($visitor->email ?? 'N/A'); ?></td>
                            <td><?php echo e($visitor->phone ?? 'N/A'); ?></td>
                            <td><?php echo e($visitor->purpose); ?></td>
                            <td><?php echo e($visitor->check_in ? \Carbon\Carbon::parse($visitor->check_in)->format('d M Y H:i') : 'N/A'); ?></td>
                            <td>
                                <?php if($visitor->check_out): ?>
                                    <?php echo e($visitor->check_out ? \Carbon\Carbon::parse($visitor->check_out)->format('d M Y H:i') : 'N/A'); ?>

                                <?php else: ?>
                                    <span class="badge bg-warning text-dark">Not Checked Out</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if(!$visitor->check_out): ?>
                                    <form action="<?php echo e(route('visitors.checkout', $visitor->id)); ?>" method="POST" class="d-inline">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="btn btn-warning btn-sm">Check Out</button>
                                    </form>
                                <?php else: ?>
                                    <span class="badge bg-success">Checked Out</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <?php if(method_exists($visitors, 'links')): ?>
                <div class="d-flex justify-content-center mt-3">
                    <?php echo e($visitors->links()); ?>

                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Visitor Logs Section -->
    <div class="card mt-4">
        <div class="card-header d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center gap-2">
            <h3>Visitor Logs</h3>

            <!-- Export -->
            <div class="btn-group">
                <a href="<?php echo e(route('logs.export', ['format' => 'csv'])); ?>" class="btn btn-sm btn-outline-primary">Export to CSV</a>
                <a href="<?php echo e(route('logs.export', ['format' => 'pdf'])); ?>" class="btn btn-sm btn-outline-danger">Export to PDF</a>
            </div>

            <!-- Filters -->
            <form action="<?php echo e(route('visitors.index')); ?>" method="GET" class="d-flex flex-wrap gap-2 mt-2">
                <input type="text" name="search" class="form-control" placeholder="Search logs..." value="<?php echo e(request('search')); ?>">
                <select name="log_filter" class="form-select">
                    <option value="">All Actions</option>
                    <option value="Checked In" <?php echo e(request('log_filter') == 'Checked In' ? 'selected' : ''); ?>>Checked In</option>
                    <option value="Checked Out" <?php echo e(request('log_filter') == 'Checked Out' ? 'selected' : ''); ?>>Checked Out</option>
                </select>
                <button type="submit" class="btn btn-primary">Filter</button>
            </form>
        </div>
        <div class="card-body">
            <?php if($visitorLogs->isEmpty()): ?>
                <p class="text-danger">No logs found!</p>
            <?php else: ?>
                <div class="table-responsive">
                    <table class="table table-striped table-bordered align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>#</th>
                                <th>Visitor</th>
                                <th>Action</th>
                                <th>Time</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $visitorLogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($index + 1); ?></td>
                                <td><?php echo e(optional($log->visitor)->name ?? 'Unknown'); ?></td>
                                <td><?php echo e($log->action); ?></td>
                                <td><?php echo e(\Carbon\Carbon::parse($log->action_time)->format('d M Y H:i')); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
            <?php if(method_exists($visitorLogs, 'links')): ?>
                <div class="d-flex justify-content-center mt-3">
                    <?php echo e($visitorLogs->links()); ?>

                </div>
            <?php endif; ?>
        </div>
    </div>

    <?php echo $__env->make('visitors.create', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
<link href="https://cdn.jsdelivr.net/npm/sweetalert2@11.4.27/dist/sweetalert2.min.css" rel="stylesheet">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.4.27/dist/sweetalert2.min.js"></script>
<script>
    document.addEventListener("DOMContentLoaded", function() {
        let now = new Date();
        let formattedDateTime = now.getFullYear() + "-" 
            + String(now.getMonth() + 1).padStart(2, '0') + "-" 
            + String(now.getDate()).padStart(2, '0') + " " 
            + String(now.getHours()).padStart(2, '0') + ":" 
            + String(now.getMinutes()).padStart(2, '0') + ":" 
            + String(now.getSeconds()).padStart(2, '0');
        document.getElementById("check_in_time").value = formattedDateTime;
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.visitors', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/frankie_254/HIRESTREAM-APP/resources/views/visitors/index.blade.php ENDPATH**/ ?>