<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['invoices', 'agencies']));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['invoices', 'agencies']), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars); ?>

<div class="tab-pane fade <?php echo e($activeTab === 'invoices' ? 'show active' : ''); ?>" id="invoices">
    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-info text-white text-center">
                    <h5 class="mb-0">Search Invoices</h5>
                </div>
                <div class="card-body">
                    <form action="<?php echo e(route('invoices.index')); ?>" method="GET">
                        <div class="row g-2 align-items-end">
                            <div class="col-lg col-md-6 col-sm-12">
                                <label class="form-label">Invoice Number</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="fas fa-file-invoice"></i></span>
                                    <input type="text" name="invoice_number" class="form-control" placeholder="Enter invoice number" value="<?php echo e(request('invoice_number')); ?>">
                                </div>
                            </div>

                            <div class="col-lg col-md-6 col-sm-12">
                                <label class="form-label">Agency</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="fas fa-building"></i></span>
                                    <select name="external_agency_id" class="form-select">
                                        <option value="">All Agencies</option>
                                        <?php $__currentLoopData = $agencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $agency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($agency->id); ?>" <?php echo e(request('external_agency_id') == $agency->id ? 'selected' : ''); ?>>
                                                <?php echo e($agency->company_name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>

                            <div class="col-lg col-md-6 col-sm-12">
                                <label class="form-label">Payment Status</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="fas fa-money-bill"></i></span>
                                    <select name="payment_status" class="form-select">
                                        <option value="">All Payment Statuses</option>
                                        <option value="pending" <?php echo e(request('payment_status') === 'pending' ? 'selected' : ''); ?>>Pending</option>
                                        <option value="partial" <?php echo e(request('payment_status') === 'partial' ? 'selected' : ''); ?>>Partial</option>
                                        <option value="paid" <?php echo e(request('payment_status') === 'paid' ? 'selected' : ''); ?>>Paid</option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-lg col-md-6 col-sm-12">
                                <label class="form-label">From Date</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="fas fa-calendar"></i></span>
                                    <input type="date" name="from_date" class="form-control" value="<?php echo e(request('from_date')); ?>">
                                </div>
                            </div>

                            <div class="col-lg col-md-6 col-sm-12">
                                <label class="form-label">To Date</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="fas fa-calendar"></i></span>
                                    <input type="date" name="to_date" class="form-control" value="<?php echo e(request('to_date')); ?>">
                                </div>
                            </div>

                            <div class="col-lg-auto col-md-6 col-sm-12">
                                <div class="d-flex gap-2">
                                    <button type="submit" class="btn btn-info">
                                        <i class="fas fa-filter"></i> Filter
                                    </button>
                                    <a href="<?php echo e(route('invoices.index')); ?>" class="btn btn-outline-secondary">
                                        <i class="fas fa-times"></i> Clear
                                    </a>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Invoices</h5>
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createInvoiceModal">
                        <i class="fas fa-plus"></i> New Invoice
                    </button>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th class="text-center">Invoice #</th>
                                    <th class="text-center">Date</th>
                                    <th class="text-center">Client</th>
                                    <th class="text-center">Workers</th>
                                    <th class="text-center">Amount</th>
                                    <th class="text-center">Status</th>
                                    <th class="text-center">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td class="text-center fw-bold"><?php echo e($invoice->invoice_number); ?></td>
                                        <td class="text-center fw-bold"><?php echo e($invoice->invoice_date->format('d M Y')); ?></td>
                                        <td class="text-center fw-bold"><?php echo e($invoice->client_name); ?></td>
                                        <td class="text-center fw-bold"><?php echo e(is_array($invoice->workers_data) ? count($invoice->workers_data) : count(json_decode($invoice->workers_data, true))); ?></td>
                                        <td class="text-center fw-bold"><?php echo e(number_format($invoice->total_amount, 2)); ?></td>
                                        <td class="text-center">
                                            <?php if($invoice->status === 'paid'): ?>
                                                <span class="badge bg-success text-white fw-bold">Paid</span>
                                            <?php elseif($invoice->status === 'overdue'): ?>
                                                <span class="badge bg-danger text-white fw-bold">Overdue</span>
                                            <?php elseif($invoice->payment_status === 'partial'): ?>
                                                <span class="badge bg-warning text-dark fw-bold">Partially Paid</span>
                                            <?php elseif($invoice->status === 'draft'): ?>
                                                <span class="badge bg-secondary text-white fw-bold">Draft</span>
                                            <?php else: ?>
                                                <span class="badge bg-warning text-dark fw-bold">Pending</span>
                                            <?php endif; ?>
                                        </td>
                                        <td class="text-center">
                                            <div class="d-flex justify-content-center gap-1">
                                                <a href="<?php echo e(route('invoices.show', $invoice)); ?>" class="btn btn-xxs btn-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="<?php echo e(route('invoices.edit', $invoice)); ?>" class="btn btn-xxs btn-primary">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <button type="button" class="btn btn-xxs btn-danger" 
                                                        onclick="deleteInvoice(<?php echo e($invoice->id); ?>)">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="7" class="text-center fw-bold">No invoices found</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-3">
                        <div class="d-flex justify-content-between align-items-center">
                            <div class="d-flex align-items-center gap-2">
                                <span class="text-muted">Show</span>
                                <select class="form-select form-select-sm" style="width: auto;" onchange="window.location.href = this.value">
                                    <option value="<?php echo e(request()->fullUrlWithQuery(['per_page' => 5])); ?>" <?php echo e(request('per_page', 5) == 5 ? 'selected' : ''); ?>>5</option>
                                    <option value="<?php echo e(request()->fullUrlWithQuery(['per_page' => 10])); ?>" <?php echo e(request('per_page') == 10 ? 'selected' : ''); ?>>10</option>
                                    <option value="<?php echo e(request()->fullUrlWithQuery(['per_page' => 25])); ?>" <?php echo e(request('per_page') == 25 ? 'selected' : ''); ?>>25</option>
                                    <option value="<?php echo e(request()->fullUrlWithQuery(['per_page' => 50])); ?>" <?php echo e(request('per_page') == 50 ? 'selected' : ''); ?>>50</option>
                                    <option value="<?php echo e(request()->fullUrlWithQuery(['per_page' => 100])); ?>" <?php echo e(request('per_page') == 100 ? 'selected' : ''); ?>>100</option>
                                </select>
                                <span class="text-muted">entries</span>
                            </div>
                            <?php echo e($invoices->appends(request()->query())->links()); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Toast Notification -->
<div class="position-fixed bottom-0 end-0 p-3" style="z-index: 11">
    <div id="successToast" class="toast align-items-center text-white bg-success border-0" role="alert" aria-live="assertive" aria-atomic="true">
        <div class="d-flex">
            <div class="toast-body">
                <i class="fas fa-check-circle me-2"></i>
                <span id="toastMessage">Invoice created successfully!</span>
            </div>
            <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    // Show success toast
    function showSuccessToast(message = 'Invoice created successfully!') {
        const toast = document.getElementById('successToast');
        const toastMessage = document.getElementById('toastMessage');
        toastMessage.textContent = message;
        
        const bsToast = new bootstrap.Toast(toast, {
            autohide: true,
            delay: 3000
        });
        bsToast.show();
    }

    // Check for success message in session
    <?php if(session('success')): ?>
        showSuccessToast("<?php echo e(session('success')); ?>");
    <?php endif; ?>
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<style>
.btn-xs {
    padding: 0.15rem 0.3rem;
    font-size: 0.75rem;
    line-height: 1;
    border-radius: 0.2rem;
}

.btn-xs i {
    font-size: 0.75rem;
}

.btn-xxs {
    padding: 0.1rem 0.2rem;
    font-size: 0.65rem;
    line-height: 1;
    border-radius: 0.15rem;
}

.btn-xxs i {
    font-size: 0.65rem;
}
</style>
<?php $__env->stopPush(); ?> <?php /**PATH /home/frankie_254/HIRESTREAM-APP/resources/views/invoices/partials/tabs/invoices-tab.blade.php ENDPATH**/ ?>