<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['vouchers', 'subAgents']));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['vouchers', 'subAgents']), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars); ?>

<div class="tab-pane fade <?php echo e($activeTab === 'vouchers' ? 'show active' : ''); ?>" id="vouchers">
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Payment Vouchers</h5>
            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createVoucherModal">
                <i class="fas fa-plus"></i> New Voucher
            </button>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Voucher #</th>
                            <th>Date</th>
                            <th>Sub Agent</th>
                            <th>Workers</th>
                            <th>Total Amount</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $vouchers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $voucher): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($voucher->voucher_number); ?></td>
                                <td><?php echo e($voucher->created_at->format('Y-m-d')); ?></td>
                                <td><?php echo e($voucher->subAgent->name); ?></td>
                                <td><?php echo e($voucher->workers->count()); ?></td>
                                <td>$<?php echo e(number_format($voucher->total_amount, 2)); ?></td>
                                <td>
                                    <span class="badge bg-<?php echo e($voucher->status === 'paid' ? 'success' : 'warning'); ?>">
                                        <?php echo e(ucfirst($voucher->status)); ?>

                                    </span>
                                </td>
                                <td>
                                    <div class="btn-group">
                                        <a href="<?php echo e(route('vouchers.show', $voucher)); ?>" class="btn btn-sm btn-info">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="<?php echo e(route('vouchers.edit', $voucher)); ?>" class="btn btn-sm btn-primary">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <button type="button" class="btn btn-sm btn-danger" 
                                                onclick="deleteVoucher(<?php echo e($voucher->id); ?>)">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="7" class="text-center">No vouchers found</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <?php if(method_exists($vouchers, 'links')): ?>
                <div class="mt-3">
                    <?php echo e($vouchers->links()); ?>

                </div>
            <?php endif; ?>
        </div>
    </div>
</div> <?php /**PATH /home/frankie_254/HIRESTREAM-APP/resources/views/invoices/partials/tabs/vouchers-tab.blade.php ENDPATH**/ ?>