<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <div class="flex items-center justify-between">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                Domestic Service Workers
            </h2>

            <a href="<?php echo e(route('workers.create')); ?>" class="btn btn-success">
                <i class="fas fa-plus"></i> Add New Candidates
            </a>
        </div>
     <?php $__env->endSlot(); ?>

    <div class="py-6">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">

            
            <div class="card shadow-sm border-light rounded mb-4">
                <div class="card-header bg-info text-white text-center">
                    <h5>Search Workers</h5>
                </div>

                <form method="GET" action="<?php echo e(route('workers.index')); ?>" class="p-3">
                    <div class="row g-2 align-items-end">
                        
                        <div class="col-md">
                            <label class="form-label">Sort</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-calendar-range"></i></span>
                                <select name="sort" class="form-select">
                                    <option value="newest" <?php echo e(request('sort') == 'newest' ? 'selected' : ''); ?>>Date (Newest)</option>
                                    <option value="oldest" <?php echo e(request('sort') == 'oldest' ? 'selected' : ''); ?>>Date (Oldest)</option>
                                </select>
                            </div>
                        </div>

                        
                        <div class="col-md">
                            <label class="form-label">Passport No</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-passport"></i></span>
                                <input type="text" name="passport_number" class="form-control" placeholder="Enter passport number" value="<?php echo e(request('passport_number')); ?>">
                            </div>
                        </div>

                        
                        <div class="col-md">
                            <label class="form-label">Skill</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-tools"></i></span>
                                <select name="skill" class="form-select">
                                    <option value="">All</option>
                                    <?php $__currentLoopData = $skills; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $skill): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($skill); ?>" <?php echo e(request('skill') == $skill ? 'selected' : ''); ?>><?php echo e($skill); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>

                        
                        <div class="col-md">
                            <label class="form-label">Education</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-mortarboard-fill"></i></span>
                                <select name="education_level" class="form-select">
                                    <option value="">All</option>
                                    <option value="Primary" <?php echo e(request('education_level') == 'Primary' ? 'selected' : ''); ?>>Primary</option>
                                    <option value="Secondary" <?php echo e(request('education_level') == 'Secondary' ? 'selected' : ''); ?>>Secondary</option>
                                    <option value="Tertiary" <?php echo e(request('education_level') == 'Tertiary' ? 'selected' : ''); ?>>Tertiary</option>
                                </select>
                            </div>
                        </div>

                        
                        <div class="col-md">
                            <label class="form-label">Gender</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-gender-ambiguous"></i></span>
                                <select name="gender" class="form-select">
                                    <option value="">All</option>
                                    <option value="Male" <?php echo e(request('gender') == 'Male' ? 'selected' : ''); ?>>Male</option>
                                    <option value="Female" <?php echo e(request('gender') == 'Female' ? 'selected' : ''); ?>>Female</option>
                                </select>
                            </div>
                        </div>

                        
                        <div class="col-md">
                            <label class="form-label">Religion</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-book"></i></span>
                                <select name="religion" class="form-select">
                                    <option value="">All</option>
                                    <option value="Christian" <?php echo e(request('religion') == 'Christian' ? 'selected' : ''); ?>>Christian</option>
                                    <option value="Muslim" <?php echo e(request('religion') == 'Muslim' ? 'selected' : ''); ?>>Muslim</option>
                                </select>
                            </div>
                        </div>

                        
                        <div class="col-md">
                            <label class="form-label">Keywords</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-search"></i></span>
                                <input type="text" name="keywords" class="form-control" placeholder="Search..." value="<?php echo e(request('keywords')); ?>">
                            </div>
                        </div>

                        
                        <div class="col-auto">
                            <button type="submit" class="btn btn-info mt-2">
                                <i class="bi bi-funnel-fill"></i> Filter
                            </button>
                            <a href="<?php echo e(route('workers.index')); ?>" class="btn btn-outline-secondary mt-2 ms-2">
                                <i class="bi bi-x-circle"></i> Clear
                            </a>
                        </div>
                    </div>
                </form>
            </div>

            
            <?php
                $currentStatus = request('status', 'All');
                $queryParams = request()->except('status', 'page');
            ?>
            <ul class="nav nav-tabs mb-3" id="statusTabs">
                <?php $__currentLoopData = ['All', 'Available', 'Processing', 'Employee', 'Back_Out']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e($currentStatus === $status ? 'active' : ''); ?>"
                           href="<?php echo e(route('workers.index', array_merge($queryParams, ['status' => $status]))); ?>">
                            <?php echo e($status); ?>

                        </a>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>

            
            <div class="card shadow-sm border-light rounded">
                <div class="card-header bg-light">
                    <h5 class="mb-0">Candidates List</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <?php $__currentLoopData = $workers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $worker): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-12 mb-4 worker-card" data-status="<?php echo e($worker->status); ?>">
                                <div class="card shadow rounded shadow-lg">
                                    <div class="card-body">
                                        <div class="row align-items-center">
                                            
                                            <div class="col-auto text-center">
                                                <div class="mb-2">
                                                   <span class="badge bg-<?php echo e($worker->status === 'available' ? 'primary' : (
                                                            $worker->status === 'processing' ? 'info' : (
                                                                $worker->status === 'employee' ? 'success' : 'danger'
                                                            )
                                                        )); ?>">

                                                    <?php echo e($worker->status === 'available' ? 'Available' :
                                                        ($worker->status === 'processing' ? 'Processing' :
                                                        ($worker->status === 'employee' ? 'Employee' : 'Back Out'))); ?>

                                                </span>
                                                </div>
                                                <img src="<?php echo e($worker->photo_url ? asset($worker->photo_url) : asset('default-avatar.png')); ?>"
                                                     alt="Photo of <?php echo e($worker->surname); ?>"
                                                     class="rounded-circle"
                                                     style="width: 60px; height: 60px; object-fit: cover;">
                                            </div>

                                            
                                            <div class="col">
                                                <div class="row g-3">
                                                    <div class="col-6 col-md-2"><div class="text-muted small">Full Name</div><strong><?php echo e($worker->surname); ?> <?php echo e($worker->given_names); ?></strong></div>
                                                    <div class="col-6 col-md-2"><div class="text-muted small">Religion</div><?php echo e($worker->religion ?? 'N/A'); ?></div>
                                                    <div class="col-6 col-md-2"><div class="text-muted small">Passport No </div><?php echo e($worker->passport_number ?? 'N/A'); ?></div>
                                                    <div class="col-6 col-md-2"><div class="text-muted small">Occupation</div><?php echo e($worker->occupation ?? 'N/A'); ?></div>
                                                    <div class="col-6 col-md-2"><div class="text-muted small">Mobile</div><?php echo e($worker->mobile_number ?? 'N/A'); ?></div>
                                                    <div class="col-6 col-md-2"><div class="text-muted small">Location</div><?php echo e($worker->city ?? 'N/A'); ?>, <?php echo e($worker->country ?? 'N/A'); ?></div>
                                                </div>
                                            </div>

                                            
                                            <div class="col-auto text-end">
                                                <div class="d-flex flex-column gap-1">
                                                    <a href="<?php echo e(route('workers.show', $worker->id)); ?>" class="btn btn-success btn-sm text-white">Details</a>
                                                    <?php
                                                        // Normalize the worker's status to lowercase and trim any whitespace
                                                        $normalizedStatus = strtolower(trim($worker->status));
                                                    ?>

                                                    <?php if($normalizedStatus === 'available'): ?>
                                                        <a href="<?php echo e(route('workers.edit', $worker->id)); ?>" class="btn btn-info btn-sm text-white">
                                                            Edit
                                                        </a>
                                                    <?php elseif($normalizedStatus === 'back_out'): ?>
                                                        <form action="<?php echo e(route('workers.revoke-backout', $worker->id)); ?>" method="POST" class="d-inline">
                                                            <?php echo csrf_field(); ?>
                                                            <?php echo method_field('PUT'); ?>
                                                            <button type="submit" class="btn btn-warning btn-sm text-white">
                                                                Revoke
                                                            </button>
                                                        </form>
                                                    <?php endif; ?>

                                                    <?php
                                                    $canDelete = in_array(strtolower($worker->status), ['available', 'back_out']);
                                                ?>

                                                <?php if($canDelete): ?>
                                                    <button type="button" 
                                                            class="btn btn-link text-danger text-decoration-underline p-0 m-0 btn-sm delete-worker"
                                                            data-worker-id="<?php echo e($worker->id); ?>"
                                                            data-worker-name="<?php echo e($worker->surname); ?> <?php echo e($worker->given_names); ?>">
                                                        Delete
                                                    </button>
                                                <?php endif; ?>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        
                        <div id="noResultsMessage" class="text-center text-muted w-100 my-4" style="display: none;">
                            <p>No results match your search.</p>
                        </div>
                    </div>

                    
                    <div class="d-flex justify-content-center mt-3">
                        <?php echo e($workers->appends(request()->query())->links('pagination::bootstrap-4')); ?>

                    </div>
                </div>
            </div>

        </div>
    </div>

    
    <?php $__env->startPush('scripts'); ?>
        
        <?php if(session('success')): ?>
            <script>
                document.addEventListener("DOMContentLoaded", function() {
                    const Toast = Swal.mixin({
                        toast: true,
                        position: 'center',
                        showConfirmButton: false,
                        timer: 3000,
                        timerProgressBar: true,
                        width: 'auto',
                        padding: '0.5em',
                        customClass: {
                            popup: 'colored-toast'
                        }
                    });

                    <?php if(is_array(session('success'))): ?>
                        Toast.fire({
                            icon: 'success',
                            title: "<?php echo e(session('success')['title'] ?? 'Success'); ?>",
                            text: "<?php echo e(session('success')['message'] ?? ''); ?>"
                        });
                    <?php else: ?>
                        Toast.fire({
                            icon: 'success',
                            title: "<?php echo e(session('success')); ?>"
                        });
                    <?php endif; ?>
                });
            </script>
        <?php endif; ?>

        
        <?php if(session('error')): ?>
            <script>
                document.addEventListener("DOMContentLoaded", function() {
                    const ErrorAlert = Swal.mixin({
                        toast: true,
                        position: 'center',
                        showConfirmButton: true,
                        confirmButtonColor: '#3085d6',
                        confirmButtonText: 'OK',
                        icon: 'error',
                        width: 'auto',
                        padding: '0.5em',
                        customClass: {
                            popup: 'colored-toast'
                        }
                    });

                    ErrorAlert.fire({
                        title: 'Error',
                        text: "<?php echo e(session('error')); ?>"
                    });
                });
            </script>
        <?php endif; ?>

        
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                // Handle delete buttons
                document.querySelectorAll('.delete-worker').forEach(button => {
                    button.addEventListener('click', function() {
                        const workerId = this.getAttribute('data-worker-id');
                        const workerName = this.getAttribute('data-worker-name');
                        
                        Swal.fire({
                            title: 'Are you sure?',
                            text: `Do you want to delete ${workerName}?`,
                            icon: 'warning',
                            showCancelButton: true,
                            confirmButtonColor: '#d33',
                            cancelButtonColor: '#3085d6',
                            confirmButtonText: 'Yes, delete it!',
                            width: 'auto',
                            padding: '0.5em',
                            customClass: {
                                popup: 'colored-toast'
                            }
                        }).then((result) => {
                            if (result.isConfirmed) {
                                // Create a form and submit it
                                const form = document.createElement('form');
                                form.method = 'POST';
                                form.action = `/workers/${workerId}`;

                                // Add CSRF token
                                const csrfInput = document.createElement('input');
                                csrfInput.type = 'hidden';
                                csrfInput.name = '_token';
                                csrfInput.value = document.querySelector('meta[name="csrf-token"]').content;
                                form.appendChild(csrfInput);

                                // Add method spoofing for DELETE
                                const methodInput = document.createElement('input');
                                methodInput.type = 'hidden';
                                methodInput.name = '_method';
                                methodInput.value = 'DELETE';
                                form.appendChild(methodInput);

                                // Add form to document and submit
                                document.body.appendChild(form);
                                form.submit();
                            }
                        });
                    });
                });

                // Add custom styles for smaller popups
                const style = document.createElement('style');
                style.textContent = `
                    .colored-toast {
                        font-size: 0.9em !important;
                        min-width: 200px !important;
                        max-width: 400px !important;
                    }
                    .colored-toast .swal2-title {
                        font-size: 1.1em !important;
                        margin: 0.5em !important;
                    }
                    .colored-toast .swal2-html-container {
                        font-size: 0.9em !important;
                        margin: 0.5em !important;
                    }
                    .colored-toast .swal2-confirm {
                        padding: 0.3em 1em !important;
                        font-size: 0.9em !important;
                    }
                `;
                document.head.appendChild(style);
            });
        </script>

        
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                const tabs = document.querySelectorAll('#statusTabs .nav-link');
                const cards = document.querySelectorAll('.worker-card');
                const noResults = document.getElementById('noResultsMessage');

                tabs.forEach(tab => {
                    tab.addEventListener('click', function () {
                        const status = this.getAttribute('data-status');
                        let count = 0;
                        cards.forEach(card => {
                            const cardStatus = card.getAttribute('data-status');
                            if (status === 'All' || cardStatus === status) {
                                card.style.display = 'block';
                                count++;
                            } else {
                                card.style.display = 'none';
                            }
                        });
                        noResults.style.display = count === 0 ? 'block' : 'none';
                    });
                });
            });
        </script>
    <?php $__env->stopPush(); ?>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH /home/frankie_254/HIRESTREAM-APP/resources/views/workers/index.blade.php ENDPATH**/ ?>