<?php $__env->startSection('title', 'User Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid mt-4">
    <!-- Welcome Section -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card shadow">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h2 class="h4 mb-0 text-gray-800">Welcome back, <?php echo e($user->name); ?>!</h2>
                            <p class="text-muted mb-0">Here's what's happening with your account today.</p>
                        </div>
                        <div class="d-flex align-items-center">
                            <span class="badge bg-success me-3">
                                <i class="fas fa-check-circle me-1"></i> Active
                            </span>
                            <small class="text-muted">Last login: <?php echo e($user->last_login_at ? $user->last_login_at->diffForHumans() : 'Never'); ?></small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <!-- Documents Card -->
        <div class="col-xl-4 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Documents</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e($documentsCount); ?></div>
                            <div class="text-xs text-muted mt-1">Total uploaded documents</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-file-alt fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Applications Card -->
        <div class="col-xl-4 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Applications</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e($applicationsCount); ?></div>
                            <div class="text-xs text-muted mt-1">Active applications</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-clipboard-list fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Messages Card -->
        <div class="col-xl-4 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">Unread Messages</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e($messagesCount); ?></div>
                            <div class="text-xs text-muted mt-1">New messages</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-envelope fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content Area -->
    <div class="row">
        <!-- Recent Activities -->
        <div class="col-lg-8">
            <div class="card shadow mb-4">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">Recent Activities</h5>
                </div>
                <div class="card-body">
                    <div class="activity-feed">
                        <?php $__empty_1 = true; $__currentLoopData = $recentActivities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="activity-item mb-3">
                            <div class="d-flex align-items-center">
                                <div class="activity-icon me-3">
                                    <i class="fas fa-history text-info"></i>
                                </div>
                                <div class="activity-content">
                                    <p class="mb-0"><?php echo e($activity->description); ?></p>
                                    <small class="text-muted"><?php echo e($activity->created_at->diffForHumans()); ?></small>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="text-center text-muted py-4">
                            <i class="fas fa-history fa-3x mb-3"></i>
                            <p>No recent activities</p>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Actions & Notifications -->
        <div class="col-lg-4">
            <!-- Quick Actions -->
            <div class="card shadow mb-4">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">Quick Actions</h5>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="<?php echo e(route('documents.upload')); ?>" class="btn btn-outline-primary">
                            <i class="fas fa-upload me-2"></i> Upload New Document
                        </a>
                        <a href="<?php echo e(route('profile.edit')); ?>" class="btn btn-outline-info">
                            <i class="fas fa-user me-2"></i> View Profile
                        </a>
                        <a href="<?php echo e(route('settings.index')); ?>" class="btn btn-outline-secondary">
                            <i class="fas fa-cog me-2"></i> Settings
                        </a>
                    </div>
                </div>
            </div>

            <!-- Notifications -->
            <div class="card shadow">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">Notifications</h5>
                </div>
                <div class="card-body">
                    <div class="notification-list">
                        <?php $__empty_1 = true; $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="notification-item mb-3 p-2 rounded <?php echo e($notification->read_at ? 'bg-light' : 'bg-white'); ?>">
                            <div class="d-flex align-items-center">
                                <div class="notification-icon me-3">
                                    <i class="fas fa-bell text-primary"></i>
                                </div>
                                <div class="notification-content">
                                    <p class="mb-0"><?php echo e($notification->data['title'] ?? 'Notification'); ?></p>
                                    <p class="text-muted mb-0 small"><?php echo e($notification->data['message'] ?? ''); ?></p>
                                    <small class="text-muted"><?php echo e($notification->created_at->diffForHumans()); ?></small>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="text-center text-muted py-4">
                            <i class="fas fa-bell fa-3x mb-3"></i>
                            <p>No new notifications</p>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('styles'); ?>
<style>
.border-left-primary { border-left: 4px solid #4e73df !important; }
.border-left-success { border-left: 4px solid #1cc88a !important; }
.border-left-info { border-left: 4px solid #36b9cc !important; }
.activity-feed, .notification-list {
    max-height: 300px;
    overflow-y: auto;
}
.activity-item, .notification-item {
    padding: 10px;
    border-bottom: 1px solid #eee;
}
.activity-item:last-child, .notification-item:last-child {
    border-bottom: none;
}
.activity-icon, .notification-icon {
    width: 40px;
    height: 40px;
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 50%;
    background: #f8f9fc;
}
</style>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.user-dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/frankie_254/HIRESTREAM-APP/resources/views/user/dashboard.blade.php ENDPATH**/ ?>