<?php
    use App\Models\EmploymentStatus;
?>

<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <div class="flex items-center justify-between">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                Employment Status
            </h2>

            <a href="<?php echo e(route('employment_status.create')); ?>" class="btn btn-success">
                <i class="fas fa-plus"></i> Assign Contract
            </a>
        </div>
     <?php $__env->endSlot(); ?>

    <div class="py-6">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">

            
            <div class="card shadow-sm border-light rounded mb-4">
                <div class="card-header bg-info text-white text-center">
                    <h5>Filter Employment Status</h5>
                </div>

                <form method="GET" action="<?php echo e(route('employment_status.index')); ?>" class="p-3">
                    <div class="row g-2 align-items-end">
                    
                    <div class="col-md">
                        <label class="form-label">Passport Number</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="bi bi-passport"></i></span> 
                            <input type="text" name="passport_number" class="form-control" placeholder="Passport Number" value="<?php echo e(request('passport_number')); ?>">
                        </div>
                    </div>

                        
                        <div class="col-md">
                            <label class="form-label">Visa Number</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-file-earmark-person"></i></span>
                                <input type="text" name="visa_number" class="form-control" placeholder="Visa Number" value="<?php echo e(request('visa_number')); ?>">
                            </div>
                        </div>

                        
                        <div class="col-md">
                            <label class="form-label">Status</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-check-circle"></i></span>
                                <select name="status" class="form-select">
                                    <option value="">Filter by Status</option>
                                    <?php
                                        $statuses = [
                                            'Pending',
                                            'Sent NEA',                                            
                                            'NEA Approved',
                                            'Medical Fit',
                                            'Ready for Submission',
                                            'Submited Embassy',
                                            'Visa Issued',
                                            'Travelled ',
                                        ];
                                    ?>
                                    <?php $__currentLoopData = $statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($status); ?>" <?php echo e(request('status') == $status ? 'selected' : ''); ?>>
                                            <?php echo e($status); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>


                        
                        <div class="col-md">
                            <label class="form-label">Payment Status</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-credit-card"></i></span>
                                <select name="payment_status" class="form-select">
                                    <option value="">Payment Status</option>
                                    <option value="Paid" <?php echo e(request('payment_status') == 'Paid' ? 'selected' : ''); ?>>Paid</option>
                                    <option value="Pending" <?php echo e(request('payment_status') == 'Pending' ? 'selected' : ''); ?>>Pending</option>
                                </select>
                            </div>
                        </div>

                        
                        <div class="col-auto">
                            <button type="submit" class="btn btn-info mt-2">
                                <i class="bi bi-funnel-fill"></i> Filter
                            </button>
                            <a href="<?php echo e(route('employment_status.index')); ?>" class="btn btn-outline-secondary mt-2 ms-2">
                                <i class="bi bi-x-circle"></i> Clear
                            </a>
                        </div>
                    </div>
                </form>
            </div>

            
                <?php
                    $currentStatus = request('status', 'All'); // Default status is 'All' if no status is selected
                    $queryParams = request()->except('status', 'page'); // Get all current query parameters, except 'status' and 'page'
                ?>
                <ul class="nav nav-tabs mb-3" id="statusTabs">
                    <?php $__currentLoopData = ['All','Pending', 'Sent NEA','NEA Approved', 'Medical Fit', 'Ready for Submission', 'Submitted Embassy', 'Visa Issued', 'Travelled', 'Canceled']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="nav-item">
                            <a class="nav-link <?php echo e($currentStatus === $status ? 'active' : ''); ?>"
                            href="<?php echo e(route('employment_status.index', $status === 'All' ? $queryParams : array_merge($queryParams, ['status' => $status]))); ?>">
                                <?php echo e($status); ?>

                            </a>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>

            
            <div class="card shadow-sm border-light rounded">
                <div class="card-header bg-light">
                    <h5 class="mb-0">Employment Status List</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <?php $__currentLoopData = $EmploymentStatus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-12 mb-4 employment-card" data-status="<?php echo e($status->status); ?>">
                                <div class="card shadow rounded shadow-lg">
                                    <div class="card-body">
                                        <div class="row align-items-start">
                                            
                                                <div class="col-auto d-flex flex-column align-items-center justify-content-center" style="min-width: 80px;">
                                                <?php
                                                    $cleanStatus = trim($status->status);
                                                    $badgeColor = match ($cleanStatus) {
                                                        'Pending' => 'secondary',
                                                        'Sent NEA' => 'secondary',
                                                        'NEA Approved' => 'primary',
                                                        'Medical Fit' => 'warning text-dark',
                                                        'Ready for Submission' => 'dark',
                                                        'Submitted Embassy' => 'info',
                                                        'Visa Issued', 'Travelled' => 'success',
                                                        default => 'secondary',
                                                    };
                                                ?>


                                                    <div class="mb-2">
                                                        <span class="badge bg-<?php echo e($badgeColor); ?> text-uppercase" style="font-size: 0.6rem; line-height: 1.0; padding: 0.2rem 0.4rem;">
                                                            <?php echo e(strtoupper($cleanStatus ?? 'N/A')); ?>

                                                        </span>
                                                    </div>

                                                
                                                <img src="<?php echo e($status->worker->photo_url ?? asset('default-avatar.png')); ?>"
                                                     alt="Photo of <?php echo e($status->worker->full_name ?? 'N/A'); ?>"
                                                     class="rounded-circle"
                                                     style="width: 80px; height: 80px; object-fit: cover;">
                                            </div>

                                            
                                            <div class="col">
                                                <div class="row g-3">
                                                    <div class="col-6 col-md-2">
                                                        <div class="text-muted small">Contract #</div>
                                                        <strong><?php echo e($status->contract_number); ?></strong>
                                                    </div>
                                                    <div class="col-6 col-md-2">
                                                        <div class="text-muted small">Visa</div>
                                                        <?php echo e($status->visa_number ?? 'N/A'); ?>

                                                    </div>
                                                    
                                                    <div class="col-6 col-md-2">
                                                    <div class="text-muted small">Candidate</div>
                                                        <?php if($status->worker): ?>
                                                            <a href="<?php echo e(route('workers.show', $status->worker->id)); ?>" class="text-primary">
                                                            <strong> <?php echo e($status->worker->surname); ?> <?php echo e($status->worker->given_names); ?></strong>
                                                            </a>
                                                        <?php else: ?>
                                                            N/A
                                                        <?php endif; ?>
                                                </div>

                                                <div class="col-6 col-md-2">
                                                    <div class="text-muted small">Passport No</div>
                                                    <?php echo e($status->worker->passport_number ?? 'N/A'); ?>  
                                                </div>

                                                <div class="col-6 col-md-2">
                                                    <div class="text-muted small">Occupation</div>
                                                    <?php echo e($status->worker->occupation ?? 'N/A'); ?>

                                                </div>

                                                <div class="col-6 col-md-2">
                                                    <div class="text-muted small">e_Agency</div>
                                                    <?php echo e($status->externalAgency->company_name ?? 'N/A'); ?>

                                                </div>

                                                </div>

                                                <div class="row mt-3 g-3">
                                                    <div class="col-6 col-md-2">
                                                        <div class="text-muted small">Nationality</div>
                                                        <?php echo e($status->worker->country ?? 'N/A'); ?>

                                                    </div>
                                                    <div class="col-6 col-md-2">
                                                        <div class="text-muted small">Payment</div>
                                                        <span class="badge bg-<?php echo e($status->payment_status == 'Paid' ? 'success' : 'warning text-dark'); ?>">
                                                            <?php echo e($status->payment_status); ?>

                                                        </span>
                                                    </div>
                                                    <div class="col-6 col-md-2">
                                                        <div class="text-muted small">Created on</div>
                                                        <?php echo e(\Carbon\Carbon::parse($status->created_at)->format('d M Y')); ?>

                                                    </div>
                                                </div>
                                            </div>

                                            
                                            <div class="col-auto text-end">
                                                <div class="d-flex flex-column gap-1">
                                                <?php
                                                            // Normalize status values
                                                            $normalize = [
                                                                'pending' => EmploymentStatus::STATUS_PENDING,
                                                                'sent nea' => EmploymentStatus::STATUS_SENT_NEA,
                                                                'nea approved' => EmploymentStatus::STATUS_NEA_APPROVED,
                                                                'medical fit' => EmploymentStatus::STATUS_MEDICAL_FIT,
                                                                'ready for submission' => EmploymentStatus::STATUS_READY_FOR_SUBMISSION,
                                                                'submitted embassy' => EmploymentStatus::STATUS_SUBMITTED_EMBASSY,
                                                                'visa issued' => EmploymentStatus::STATUS_VISA_ISSUED,
                                                                'travelled' => EmploymentStatus::STATUS_TRAVELLED,
                                                                'canceled' => EmploymentStatus::STATUS_CANCELED,
                                                            ];

                                                            $statusRaw = trim($status->status);
                                                            $statusKey = $normalize[strtolower($statusRaw)] ?? $statusRaw;

                                                            $statusMap = [
                                                                EmploymentStatus::STATUS_PENDING => 'Send NEA',
                                                                EmploymentStatus::STATUS_SENT_NEA => 'Mark as NEA Approved',
                                                                EmploymentStatus::STATUS_NEA_APPROVED => 'Mark as Medical Fit',
                                                                EmploymentStatus::STATUS_MEDICAL_FIT => 'Mark as Ready for Submission',
                                                                EmploymentStatus::STATUS_READY_FOR_SUBMISSION => 'Mark as Submitted to Embassy',
                                                                EmploymentStatus::STATUS_SUBMITTED_EMBASSY => 'Mark as Visa Issued',
                                                                EmploymentStatus::STATUS_VISA_ISSUED => 'Mark as Travelled',
                                                                EmploymentStatus::STATUS_TRAVELLED => 'Travel Complete',
                                                            ];

                                                            $isFinal = $statusKey === EmploymentStatus::STATUS_TRAVELLED;
                                                            $isCanceled = $statusKey === EmploymentStatus::STATUS_CANCELED;
                                                            $buttonText = $statusMap[$statusKey] ?? 'Update Status';
                                                        ?>

                                                        <?php if($isFinal): ?>
                                                            <button class="btn btn-secondary btn-sm" disabled><?php echo e($buttonText); ?></button>
                                                        <?php elseif($isCanceled): ?>
                                                        <button class="bg-red-600 hover:bg-red-700 text-white font-semibold py-1 px-3 rounded text-sm flex items-center gap-1" disabled>
                                                            <i class="fas fa-ban"></i> Cancelled
                                                        </button>
                                                        <?php else: ?>
                                                            <form action="/employment_status/<?php echo e($status->id); ?>/advance" method="POST" class="d-inline">
                                                                <?php echo csrf_field(); ?>
                                                                <button type="submit" class="btn btn-link text-info text-decoration-underline p-0 m-0 btn-sm"><?php echo e($buttonText); ?></button>
                                                            </form>
                                                        <?php endif; ?>


                                                        <?php if($status->status !== \App\Models\EmploymentStatus::STATUS_CANCELED): ?>
                                                            <a href="<?php echo e(route('employment_status.edit', $status->id)); ?>" class="btn btn-info btn-sm">Edit</a>
                                                        <?php endif; ?>
                                                        
                                                        <?php
                                                        $isCancelled = strtolower(trim($status->status)) === strtolower(\App\Models\EmploymentStatus::STATUS_CANCELED);
                                                    ?>

                                                    <?php if($isCancelled): ?>
                                                        <!-- View Cancellation Button -->
                                                        <button class="btn btn-link text-danger text-decoration-underline p-0 m-0 btn-sm" onclick="showCancellationDetails('<?php echo e($status->worker->given_names ?? 'N/A'); ?>', '<?php echo e($status->status); ?>', '<?php echo e($status->cancelledByUser->name ?? 'System/Admin'); ?>', '<?php echo e($status->updated_at->format('d M Y, h:i A')); ?>', '<?php echo e($status->cancellation_reason ?? 'N/A'); ?>')">
                                                            View Cancellation
                                                        </button>
                                                    <?php else: ?>
                                                       <!-- Cancel Contract Button -->
                                                    <button type="button" class="btn btn-link text-danger text-decoration-underline p-0 m-0 btn-sm"
                                                        onclick="confirmCancellation('<?php echo e($status->id); ?>')">
                                                        Cancel Contract
                                                    </button>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        
                        <?php if($EmploymentStatus->isEmpty()): ?>
                            <div class="col-12 text-center text-muted">
                                <p>No employment status records found.</p>
                            </div>
                        <?php endif; ?>
                    </div>

                    
                    <div class="d-flex justify-content-center mt-3">
                        <?php echo e($EmploymentStatus->appends(request()->query())->links('pagination::bootstrap-4')); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- SweetAlert Scripts -->
    <script>
        function confirmAdvance(event, actionText) {
            event.preventDefault();
            const form = event.target.closest('form');
            
            Swal.fire({
                title: 'Confirm Status Update',
                text: `Are you sure you want to ${actionText.toLowerCase()}?`,
                icon: 'question',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, proceed',
                cancelButtonText: 'Cancel'
            }).then((result) => {
                if (result.isConfirmed) {
                    form.submit();
                }
            });
        }

        function confirmCancellation(employmentStatusId) {
            Swal.fire({
                title: 'Cancel Contract',
                html: `
                    <form id="cancelForm" action="/employment_status/${employmentStatusId}/cancel" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="mb-3">
                            <label for="reason" class="form-label">Reason for Cancellation</label>
                            <textarea name="cancellation_reason" id="reason" class="form-control" rows="4" required placeholder="Enter reason..."></textarea>
                        </div>
                    </form>
                `,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Confirm Cancel',
                cancelButtonText: 'Go Back',
                focusConfirm: false,
                preConfirm: () => {
                    const reason = document.getElementById('reason').value;
                    if (!reason) {
                        Swal.showValidationMessage('Please enter a cancellation reason');
                        return false;
                    }
                    return true;
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('cancelForm').submit();
                }
            });
        }

        function showCancellationDetails(name, status, cancelledBy, cancelledOn, reason) {
            Swal.fire({
                title: 'Cancellation Details',
                html: `
                    <div class="text-left">
                        <div class="mb-3">
                            <h6 class="font-bold text-gray-800">Worker</h6>
                            <p class="text-gray-600">${name}</p>
                        </div>
                        <div class="mb-3">
                            <h6 class="font-bold text-gray-800">Status</h6>
                            <span class="badge bg-danger text-white">${status}</span>
                        </div>
                        <div class="mb-3">
                            <h6 class="font-bold text-gray-800">Cancelled By</h6>
                            <p class="text-gray-600">${cancelledBy}</p>
                        </div>
                        <div class="mb-3">
                            <h6 class="font-bold text-gray-800">Cancelled On</h6>
                            <p class="text-gray-600">${cancelledOn}</p>
                        </div>
                        <div class="mb-3">
                            <h6 class="font-bold text-gray-800">Reason</h6>
                            <p class="text-gray-600">${reason}</p>
                        </div>
                    </div>
                `,
                icon: 'info',
                confirmButtonColor: '#3085d6',
                confirmButtonText: 'Close'
            });
        }

        // Show success message if exists
        <?php if(session('success')): ?>
            const Toast = Swal.mixin({
                toast: true,
                position: 'center',
                showConfirmButton: false,
                timer: 3000,
                timerProgressBar: true,
                didOpen: (toast) => {
                    toast.addEventListener('mouseenter', Swal.stopTimer)
                    toast.addEventListener('mouseleave', Swal.resumeTimer)
                }
            });

            Toast.fire({
                icon: 'success',
                title: '<?php echo e(is_array(session('success')) ? (session('success')['message'] ?? 'Operation completed successfully.') : session('success')); ?>'
            });
        <?php endif; ?>

        // Show error message if exists
        <?php if(session('error')): ?>
            Swal.fire({
                title: '<?php echo e(is_array(session('error')) ? (session('error')['title'] ?? 'Error!') : 'Error!'); ?>',
                <?php if(is_array(session('error'))): ?>
                    <?php if(isset(session('error')['errors'])): ?>
                    html: `
                        <div class="text-left">
                            <p><?php echo e(session('error')['message'] ?? 'An error occurred.'); ?></p>
                            <ul class="list-disc list-inside mt-2">
                                <?php $__currentLoopData = session('error')['errors']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $field => $errors): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php $__currentLoopData = $errors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    `,
                    <?php else: ?>
                    text: '<?php echo e(session('error')['message'] ?? 'An error occurred.'); ?>',
                    <?php endif; ?>
                <?php else: ?>
                text: '<?php echo e(session('error')); ?>',
                <?php endif; ?>
                icon: 'error'
            });
        <?php endif; ?>
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?><?php /**PATH /home/frankie_254/HIRESTREAM-APP/resources/views/employment_status/index.blade.php ENDPATH**/ ?>